/*
 * Decompiled with CFR 0.152.
 */
package com.miratech.nE2Link.choice.converter;

import com.miratech.nE2Link.choice.BDynamicChoice;
import com.miratech.nE2Link.choice.BStatusDynamicChoice;
import javax.baja.agent.BIAgent;
import javax.baja.nre.annotations.Adapter;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusBoolean;
import javax.baja.status.BStatusEnum;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusString;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BConverter;

@NiagaraType(agent={@AgentOn(types={"baja:ConversionLink"})}, adapter=@Adapter(from="nE2Link:StatusDynamicChoice", to="baja:StatusValue"))
public class BStatusDynamicChoiceToStatusValue
extends BConverter
implements BIAgent {
    public static final Type TYPE = Sys.loadType(BStatusDynamicChoiceToStatusValue.class);

    public Type getType() {
        return TYPE;
    }

    public BObject convert(BObject from, BObject to, Context context) {
        BStatusDynamicChoice statusValue = (BStatusDynamicChoice)from;
        BStatus status = statusValue.getStatus();
        BDynamicChoice fromChoice = statusValue.getValue();
        BSimple fromKey = fromChoice.getKey();
        if (fromKey == null) {
            BStatusValue nullValue = (BStatusValue)((BStatusValue)to).newCopy();
            nullValue.setStatus(BStatus.nullStatus);
            return nullValue;
        }
        BBoolean toValue = null;
        if (to.getType().is(BStatusBoolean.TYPE)) {
            toValue = fromChoice.getKeyAsBoolean();
        } else if (to.getType().is(BStatusNumeric.TYPE)) {
            toValue = fromChoice.getKeyAsNumber();
        } else if (to.getType().is(BStatusString.TYPE)) {
            toValue = fromChoice.getKeyAsString();
        } else if (to.getType().is(BStatusEnum.TYPE)) {
            toValue = ((BStatusEnum)to).getValue();
            BEnumRange range = ((BEnum)toValue).getRange();
            toValue = fromChoice.getKeyAsEnum(range);
        }
        if (toValue != null) {
            BStatusValue retVal = (BStatusValue)((BStatusValue)to).newCopy();
            retVal.setValueValue((BValue)toValue);
            retVal.setStatus(status);
            return retVal;
        }
        throw new IllegalStateException(String.format("Cannot convert %s to %s", from, to));
    }
}

