/*
 * Decompiled with CFR 0.152.
 */
package com.miratech.nE2Link.parser.binary;

import com.miratech.nE2Link.BNanoExtension;
import com.miratech.nE2Link.actions.BNanoAddExtensionArg;
import com.miratech.nE2Link.parser.binary.AbstractNanoData;
import com.miratech.serialization.DataMarker;
import com.miratech.serialization.SerializableForm;
import java.util.Objects;

public class AddExtensionData
extends AbstractNanoData {
    private String assemblyName;
    private String typeName;
    private Short parentGlobalIndex;

    private AddExtensionData(SerializableForm serializableForm) {
        super(serializableForm);
        this.assemblyName = serializableForm.data[0].toString();
        this.typeName = serializableForm.data[1].toString();
        this.parentGlobalIndex = (Short)serializableForm.data[2];
    }

    public static AddExtensionData make(BNanoAddExtensionArg addExtensionArg) {
        BNanoExtension extension = addExtensionArg.getExtension();
        Short parentGlobalIndex = (short)addExtensionArg.getExtensionParent().getGlobalIndex();
        SerializableForm serializableForm = new SerializableForm(DataMarker.AddExtensionData, new Object[]{extension.getAssemblyInfo(), extension.getOriginNameFromLibrary(), parentGlobalIndex});
        return new AddExtensionData(serializableForm);
    }

    public String getAssemblyName() {
        return this.assemblyName;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public Short getParentGlobalIndex() {
        return this.parentGlobalIndex;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AddExtensionData that = (AddExtensionData)o;
        return Objects.equals(this.assemblyName, that.assemblyName) && Objects.equals(this.typeName, that.typeName) && Objects.equals(this.parentGlobalIndex, that.parentGlobalIndex);
    }

    public int hashCode() {
        return Objects.hash(this.assemblyName, this.typeName, this.parentGlobalIndex);
    }

    public String toString() {
        return "AddExtensionData{assemblyName='" + this.assemblyName + '\'' + ", typeName='" + this.typeName + '\'' + ", parentGlobalIndex=" + this.parentGlobalIndex + '}';
    }
}

