/*
 * Decompiled with CFR 0.152.
 */
package com.miratech.nE2Link.parser.binary;

import com.miratech.nE2Link.BUnitMap;
import com.miratech.nE2Link.parser.binary.AttributeData;
import java.util.HashMap;
import java.util.Locale;
import java.util.logging.Logger;
import javax.baja.data.BIDataValue;
import javax.baja.naming.SlotPath;
import javax.baja.nre.util.Array;
import javax.baja.sys.BDouble;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BString;
import javax.baja.units.BUnit;

public class Attributes {
    public static final Logger LOGGER = Logger.getLogger("nE2Link");
    private boolean _rangeCreated = false;
    private BEnumRange _cachedRange = null;
    private boolean _unitCreated = false;
    private BUnit _cachedUnit = null;
    private HashMap<String, AttributeData> _attributes = new HashMap();
    public static final String ATTRIB_NAME_VISIBILITY = "visibility";
    public static final String ATTRIB_NAME_MIN = "min";
    public static final String ATTRIB_NAME_MAX = "max";
    public static final String ATTRIB_NAME_NOTATION = "notation";
    public static final String ATTRIB_NAME_RANGE = "range";
    public static final String ATTRIB_NAME_READ_ONLY = "readonly";
    public static final String ATTRIB_NAME_NULLABLE = "nullable";
    public static final String ATTRIB_NAME_UNIT = "unit";
    public static final String ATTRIB_NAME_TRUE_TEXT = "truetext";
    public static final String ATTRIB_NAME_FALSE_TEXT = "falsetext";
    public static final String ATTRIB_NAME_ACTION = "action";
    public static final String ATTRIB_NAME_PROTECTED = "protected";
    public static final String ATTRIB_NAME_DYNAMIC_CHOICE = "dynamicchoice";
    public static final String ATTRIB_NAME_ENUMERATED = "enumerated";
    public static final String ATTRIB_VALUE_VISIBILITY_NOWHERE = "nowhere";
    public static final String ATTRIB_VALUE_VISIBILITY_EVERYWHERE = "everywhere";
    public static final String ATTRIB_VALUE_VISIBILITY_NORMAL = "normal";

    protected Attributes() {
    }

    public static Attributes parse(Object serializedAttributes) {
        Attributes attributes = new Attributes();
        if (serializedAttributes instanceof Array) {
            Array attributesArray = (Array)serializedAttributes;
            for (Object serializedAttribute : attributesArray) {
                AttributeData attribute = AttributeData.parse(serializedAttribute);
                if (attribute == null) continue;
                attributes.addAttribute(attribute);
            }
        } else {
            LOGGER.severe(String.format("[Attributes.parse()]: Unexpected Data type. Expected: '%s', Received: '%s'.\nSkipping attribute.", Array.class, serializedAttributes.getClass()));
        }
        return attributes;
    }

    public int size() {
        return this._attributes.size();
    }

    public void addAttribute(AttributeData[] attributes) {
        for (AttributeData attribute : attributes) {
            this.addAttribute(attribute);
        }
    }

    public void addAttribute(AttributeData attribute) {
        if (attribute.getAttrName().equalsIgnoreCase(ATTRIB_NAME_UNIT) && this.contains(attribute.getAttrName().toLowerCase(Locale.ROOT))) {
            this._unitCreated = false;
        }
        if (attribute.getAttrName().equalsIgnoreCase(ATTRIB_NAME_RANGE) && this.contains(attribute.getAttrName().toLowerCase(Locale.ROOT))) {
            this._rangeCreated = false;
        }
        this._attributes.put(attribute.getAttrName().toLowerCase(Locale.ROOT), attribute);
    }

    public AttributeData getAttribute(String attrName) {
        return this._attributes.get(attrName.toLowerCase(Locale.ROOT));
    }

    public BFacets getAttributesAsFacets() {
        String[] keys;
        BFacets facets = BFacets.NULL;
        block18: for (String key : keys = this._attributes.keySet().toArray(new String[0])) {
            AttributeData attribute = this.getAttribute(key);
            String attrValue = attribute.getAttrValue();
            facets = BFacets.make((BFacets)facets, (BFacets)BFacets.make((String)("nano_attr_" + key), (String)attrValue));
            facets = BFacets.make((BFacets)facets, (BFacets)BFacets.make((String)("nano_attr_type_" + key), (String)attribute.getAttrValueType()));
            switch (key) {
                case "notation": {
                    facets = BFacets.make((BFacets)facets, (String)"precision", (BIDataValue)BInteger.make((String)attrValue));
                    continue block18;
                }
                case "unit": {
                    BUnit unit = this.getNiagaraUnit();
                    if (unit == null) continue block18;
                    facets = BFacets.make((BFacets)facets, (String)"units", (BIDataValue)unit);
                    continue block18;
                }
                case "range": {
                    BEnumRange range = this.getNiagaraRange();
                    if (range == null) continue block18;
                    facets = BFacets.make((BFacets)facets, (String)ATTRIB_NAME_RANGE, (BIDataValue)range);
                    continue block18;
                }
                case "falsetext": {
                    facets = BFacets.make((BFacets)facets, (String)"falseText", (BIDataValue)BString.make((String)attrValue));
                    continue block18;
                }
                case "truetext": {
                    facets = BFacets.make((BFacets)facets, (String)"trueText", (BIDataValue)BString.make((String)attrValue));
                    continue block18;
                }
                case "min": {
                    facets = BFacets.make((BFacets)facets, (String)ATTRIB_NAME_MIN, (BIDataValue)BDouble.make((String)attrValue));
                    continue block18;
                }
                case "max": {
                    facets = BFacets.make((BFacets)facets, (String)ATTRIB_NAME_MAX, (BIDataValue)BDouble.make((String)attrValue));
                }
            }
        }
        return facets;
    }

    public String getAttributeValue(String attrName) {
        AttributeData attr = this._attributes.get(attrName.toLowerCase(Locale.ROOT));
        return attr != null ? attr.getAttrValue() : null;
    }

    public String getAttributeValue(String attrName, String def) {
        AttributeData attr = this._attributes.get(attrName.toLowerCase(Locale.ROOT));
        return attr != null ? attr.getAttrValue() : def;
    }

    public boolean contains(String attrName) {
        return this._attributes.containsKey(attrName.toLowerCase(Locale.ROOT));
    }

    public boolean contains(AttributeData attr) {
        return this._attributes.containsKey(attr.getAttrName().toLowerCase(Locale.ROOT));
    }

    public BUnit getNiagaraUnit() {
        if (this._unitCreated) {
            return this._cachedUnit;
        }
        if (this.contains(ATTRIB_NAME_UNIT)) {
            Integer nanoUnitId = Integer.parseInt(this.getAttributeValue(ATTRIB_NAME_UNIT));
            this._cachedUnit = BUnitMap.getNiagaraUnit(nanoUnitId);
        }
        this._unitCreated = true;
        return this._cachedUnit;
    }

    public BEnumRange getNiagaraRange() {
        if (this._rangeCreated) {
            return this._cachedRange;
        }
        if (this.contains(ATTRIB_NAME_RANGE)) {
            this._cachedRange = Attributes.makeRange(this.getAttributeValue(ATTRIB_NAME_RANGE));
        }
        this._rangeCreated = true;
        return this._cachedRange;
    }

    private static BEnumRange makeRange(String nanoRangeString) {
        try {
            if (nanoRangeString.isEmpty()) {
                return null;
            }
            String[] rangeTags = nanoRangeString.split(",\\s*");
            int[] rangeOrdinals = new int[rangeTags.length];
            int lastOrdinal = 0;
            for (int i = 0; i < rangeTags.length; ++i) {
                String[] tagAndOrdinal = rangeTags[i].split("\\s*=\\s*");
                if (tagAndOrdinal[0].isEmpty()) {
                    tagAndOrdinal[0] = " ";
                }
                rangeTags[i] = SlotPath.escape((String)tagAndOrdinal[0]);
                if (tagAndOrdinal.length >= 2) {
                    Integer ordinal = Integer.parseInt(tagAndOrdinal[1]);
                    if (ordinal != null) {
                        lastOrdinal = ordinal;
                    } else {
                        LOGGER.warning("[Attributes.makeRange()]: Invalid enum range ordinal in '" + nanoRangeString + "' for tag '" + tagAndOrdinal[0] + "'\nApplying default ordinal '" + lastOrdinal + "'");
                    }
                }
                rangeOrdinals[i] = lastOrdinal++;
            }
            return BEnumRange.make((int[])rangeOrdinals, (String[])rangeTags);
        }
        catch (Exception e) {
            LOGGER.warning("[Attributes.makeRange()]: Invalid enum range '" + nanoRangeString + "'\nApplying BEnumRange.NULL '\nException: " + e.getMessage());
            return BEnumRange.NULL;
        }
    }
}

