/*
 * Decompiled with CFR 0.152.
 */
package com.miratech.nE2Link.parser.binary;

import com.miratech.nE2Link.BLibrary;
import com.miratech.nE2Link.BMarkerEnum;
import com.miratech.nE2Link.BNanoBaseComponent;
import com.miratech.nE2Link.BNanoExtension;
import com.miratech.nE2Link.BNe2DeviceExt;
import com.miratech.nE2Link.BRequestEnum;
import com.miratech.nE2Link.parser.binary.AssemblyInfoData;
import com.miratech.nE2Link.parser.binary.ComponentSchema;
import com.miratech.nE2Link.parser.binary.ExtensionSchema;
import com.miratech.nE2Link.parser.binary.ObjectData;
import com.miratech.serialization.DataMarker;
import com.miratech.serialization.SerializableForm;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

public class BinaryApplicationParser {
    public static final Logger LOGGER = Logger.getLogger("nE2Link");
    public static final String FRAMEWORK_SDK_COMPONENT = "Framework.SDK.Component";
    public static final String FRAMEWORK_SDK_SERVICE = "Framework.SDK.Service";
    public static final String FRAMEWORK_CORE_CONTAINER = "Framework.Core.Container";
    public static final String FRAMEWORK_CORE_APPLICATION_CONTAINER = "Framework.Core.ApplicationContainer";
    public static final String LIBRARY_CORE_APPLICATION = "Library.Core.Application";
    public static final String FRAMEWORK_CORE_NETWORK_CONTAINER = "Framework.Core.NetworkContainer";
    public static final String FRAMEWORK_CORE_SPECIALIZED_CONTAINER = "Framework.Core.SpecializedContainer";
    public static final String LIBRARY_CORE_INTERFACES = "Library.Core.Interfaces";
    public static final String LIBRARY_CORE_EQUIPMENT = "Library.Core.Equipment";
    public static final String LIBRARY_CORE_FOLDER = "Library.Core.Folder";
    public static final String LIBRARY_SCHEDULES_SCHEDULE_COMPONENT = "Library.Schedules.ScheduleComponent";
    public static final String LIBRARY_SCHEDULES_ANALOG_SCHEDULE = "Library.Schedules.AnalogSchedule";
    public static final String LIBRARY_SCHEDULES_BINARY_SCHEDULE = "Library.Schedules.BinarySchedule";
    public static final String LIBRARY_SCHEDULES_MULTISTATE_SCHEDULE = "Library.Schedules.MultistateSchedule";
    public static final String FRAMEWORK_CORE_SYSTEM_SERVICE = "Framework.Core.SystemService";
    public static final String FRAMEWORK_CORE_BACKUP_SERVICE = "Framework.Core.SystemServices.BackupService";
    public static final String FRAMEWORK_CORE_USER = "Framework.Core.User";
    public static final String FRAMEWORK_CORE_LOG_SERVICE = "Framework.Core.LogService";

    public static BLibrary[] parseLibraries(List<SerializableForm> schemaData) {
        ArrayList<BLibrary> libraries = new ArrayList<BLibrary>();
        if (schemaData.size() > 0) {
            LOGGER.info("[BinaryApplicationParser.parseLibraries()]: schemaData.size: " + schemaData.size());
            int i = 0;
            for (SerializableForm serializedSchema : schemaData) {
                DataMarker marker = serializedSchema.marker;
                String requestType = serializedSchema.data[0].toString();
                if (!requestType.equals(BRequestEnum.DeviceSchemaRequest.getTag())) {
                    LOGGER.severe(String.format("[BinaryApplicationParser.parseLibraries()]: Unexpected Data type: schema[%d]: marker: '%s' requestType: '%s'.\nSkipping schema processing.", i++, marker.toString(), requestType));
                    continue;
                }
                LOGGER.info(String.format("[BinaryApplicationParser.parseLibraries()]: Processing: schema[%d]: marker: '%s' requestType: '%s'", new Object[]{i++, marker, requestType}));
                List<SerializableForm> serializedLibraries = serializedSchema.elements.toSerializableForms();
                if (serializedLibraries.size() > 0) {
                    BLibrary currentLibrary = null;
                    block6: for (SerializableForm libraryData : serializedLibraries) {
                        marker = libraryData.marker;
                        switch (marker.getValue()) {
                            case 91: {
                                BLibrary library = AssemblyInfoData.parse(libraryData).getLibrary();
                                if (library == null) continue block6;
                                libraries.add(library);
                                currentLibrary = library;
                                continue block6;
                            }
                            case 44: 
                            case 46: {
                                if (currentLibrary == null) {
                                    LOGGER.severe(String.format("[BinaryApplicationParser.parseComponentSchema()]: Parent library is null. Cannot add component", new Object[0]));
                                    continue block6;
                                }
                                BNanoBaseComponent component = ComponentSchema.parse(libraryData).getNanoComponent();
                                if (component == null) continue block6;
                                currentLibrary.addComponent(component, true);
                                continue block6;
                            }
                            case 47: {
                                if (currentLibrary == null) {
                                    LOGGER.severe(String.format("[BinaryApplicationParser.parseExtensionSchema()]: Parent library is null. Cannot add component", new Object[0]));
                                    continue block6;
                                }
                                BNanoExtension extension = (BNanoExtension)ExtensionSchema.parse(libraryData).getNanoExtension();
                                if (extension == null) continue block6;
                                currentLibrary.addComponent(extension, true);
                                continue block6;
                            }
                        }
                        LOGGER.severe(String.format("[BinaryApplicationParser.parseLibraries()]: Unexpected Data type: marker: '%s'.\nSkipping data processing.", new Object[]{marker}));
                    }
                    continue;
                }
                LOGGER.info("[BinaryApplicationParser.parseLibraries()]: No libraries found");
            }
        } else {
            LOGGER.info("[BinaryApplicationParser.parseLibraries()]: No libraries found");
        }
        return libraries.toArray(new BLibrary[0]);
    }

    private static BLibrary parseAssemblyInfoData(SerializableForm libraryData) {
        DataMarker marker = libraryData.marker;
        if (marker.getValue() != 91) {
            LOGGER.severe(String.format("BinaryApplicationParser.parseAssemblyInfoData(): Unexpected Data type: marker: '%s'.\nSkipping data processing.", new Object[]{marker}));
            return null;
        }
        String[] assemblyNameAndVersion = libraryData.data[0].toString().split(",");
        LOGGER.info(String.format("[BinaryApplicationParser.parseAssemblyInfoData()]: Processing Library '%s' '%s'", assemblyNameAndVersion[0], assemblyNameAndVersion[1]));
        return new BLibrary(BMarkerEnum.AssemblyInfoData, Integer.parseInt(libraryData.data[1].toString()), assemblyNameAndVersion[0].trim(), assemblyNameAndVersion[1].replaceFirst("Version=", "").trim());
    }

    public static BNanoBaseComponent parseTree(List<SerializableForm> treeData, BNe2DeviceExt controller) {
        BNanoBaseComponent treeRoot = null;
        ArrayList treeComponents = new ArrayList();
        if (treeData == null || treeData.size() == 0) {
            LOGGER.info("[BinaryApplicationParser.parseTree()]: No tree data found");
            return null;
        }
        LOGGER.info("[BinaryApplicationParser.parseTree()]: treeData.size: " + treeData.size());
        int i = 0;
        for (SerializableForm serializedTree : treeData) {
            ObjectData nanoObject;
            DataMarker marker = serializedTree.marker;
            String requestType = serializedTree.data[0].toString();
            if (!requestType.equals(BRequestEnum.TreeRequest.getTag())) {
                LOGGER.severe(String.format("[BinaryApplicationParser.parseTree()]: Unexpected Data type: treeData[%d]: marker: '%s' requestType: '%s'.\nSkipping tree processing.", i++, marker.toString(), requestType));
                continue;
            }
            LOGGER.info(String.format("[BinaryApplicationParser.parseTree()]: Processing: treeData[%d]: marker: '%s' requestType: '%s'", new Object[]{i++, marker, requestType}));
            List<SerializableForm> responseElements = serializedTree.elements.toSerializableForms();
            if (responseElements.size() > 1) {
                LOGGER.severe("[BinaryApplicationParser.parseTree()]: Unexpected data: multiple tree roots found " + responseElements.size() + ".\nTree processing stopped.");
                return null;
            }
            SerializableForm responseElement = responseElements.get(0);
            marker = responseElement.marker;
            if (marker.getValue() != 66) {
                LOGGER.severe(String.format("[BinaryApplicationParser.parseTree()]: Unexpected Data type: expected marker: '%s'. received marker: '%s'.\nSkipping data processing.", new Object[]{DataMarker.TreeData, marker}));
                return null;
            }
            BNanoBaseComponent newComponent = null;
            List<SerializableForm> serializedObjects = responseElement.elements.toSerializableForms();
            if (serializedObjects.size() == 0) {
                LOGGER.info("[BinaryApplicationParser.parseTree()]: Empty tree / No tree components found.");
                return null;
            }
            for (SerializableForm serializedObject : serializedObjects) {
                nanoObject = ObjectData.parse(serializedObject, controller, false);
                BNanoBaseComponent component = (BNanoBaseComponent)controller.getLibraries().getLibraryComponentsCache().get(nanoObject.getTypeId()).newCopy();
                component.setNanoName(nanoObject.getNanoName());
                component.setGlobalIndex(nanoObject.getGlobalIndex());
                component.setParentGlobalIndex(nanoObject.getParentGlobalIndex());
                component.setPersistentId(nanoObject.getPersistentId());
                controller.getComponentCache().put(component);
            }
            for (SerializableForm serializedObject : serializedObjects) {
                nanoObject = ObjectData.parse(serializedObject, controller);
                if (nanoObject == null) continue;
                try {
                    newComponent = nanoObject.createNiagaraComponent(controller);
                    if (newComponent == null || newComponent.getParentGlobalIndex() != -1) continue;
                    treeRoot = newComponent;
                }
                catch (Exception e) {
                    LOGGER.severe(String.format("BinaryApplicationParser.parseTree(): Invalid child '%s' (%d )for parent '%s' (%d)", new Object[]{nanoObject.getNanoName(), nanoObject.getGlobalIndex(), controller.getComponentCache().get(nanoObject.getParentGlobalIndex()), nanoObject.getParentGlobalIndex()}));
                    e.printStackTrace();
                }
            }
            return treeRoot;
        }
        return null;
    }
}

