/*
 * Decompiled with CFR 0.152.
 */
package com.miratech.nE2Link.parser.binary;

import com.miratech.nE2Link.actions.BNanoLinkInfoArg;
import com.miratech.nE2Link.parser.binary.AbstractNanoData;
import com.miratech.serialization.DataMarker;
import com.miratech.serialization.SerializableForm;
import java.util.Objects;
import javax.baja.sys.BLink;

public class ExistingLinkData
extends AbstractNanoData {
    private int sourceObjectId;
    private int sourceSlotId;
    private int targetObjectId;
    private int targetSlotId;

    private ExistingLinkData(SerializableForm serializedLinkData) {
        super(serializedLinkData);
        this.sourceObjectId = Short.toUnsignedInt((Short)serializedLinkData.data[0]);
        this.sourceSlotId = Byte.toUnsignedInt((Byte)serializedLinkData.data[1]);
        this.targetObjectId = Short.toUnsignedInt((Short)serializedLinkData.data[2]);
        this.targetSlotId = Byte.toUnsignedInt((Byte)serializedLinkData.data[3]);
    }

    public static ExistingLinkData make(BNanoLinkInfoArg linkInfoArg) {
        SerializableForm serializableForm = new SerializableForm(DataMarker.ExisitingLinkData, new Object[]{(short)linkInfoArg.getSourceComponentGlobalIndex(), (byte)linkInfoArg.getSourceSlotId(), (short)linkInfoArg.getTargetComponentGlobalIndex(), (byte)linkInfoArg.getTargetSlotId()});
        return new ExistingLinkData(serializableForm);
    }

    public static ExistingLinkData make(BLink link) {
        return ExistingLinkData.make(new BNanoLinkInfoArg(link));
    }

    public static ExistingLinkData parse(SerializableForm serializedLinkData) {
        DataMarker marker = serializedLinkData.marker;
        if (marker.getValue() != 68) {
            LOGGER.severe(String.format("[ExistingLinkData.parse](): Unexpected Data type: Expected marker: '%s', Received marker: '%s'.\nSkipping data processing.", new Object[]{DataMarker.ExisitingLinkData, marker}));
            return null;
        }
        return new ExistingLinkData(serializedLinkData);
    }

    public int getSourceObjectId() {
        return this.sourceObjectId;
    }

    public int getSourceSlotId() {
        return this.sourceSlotId;
    }

    public int getTargetObjectId() {
        return this.targetObjectId;
    }

    public int getTargetSlotId() {
        return this.targetSlotId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExistingLinkData that = (ExistingLinkData)o;
        return this.sourceObjectId == that.sourceObjectId && this.sourceSlotId == that.sourceSlotId && this.targetObjectId == that.targetObjectId && this.targetSlotId == that.targetSlotId;
    }

    public int hashCode() {
        return Objects.hash(this.sourceObjectId, this.sourceSlotId, this.targetObjectId, this.targetSlotId);
    }

    public String toString() {
        return "ExistingLinkData{sourceObjectId=" + this.sourceObjectId + ", sourceSlotId=" + this.sourceSlotId + ", targetObjectId=" + this.targetObjectId + ", targetSlotId=" + this.targetSlotId + '}';
    }
}

