/*
 * Decompiled with CFR 0.152.
 */
package com.miratech.nE2Link.parser.binary;

import com.miratech.nE2Link.parser.binary.AbstractNanoData;
import com.miratech.nE2Link.utils.BFileDataArgs;
import com.miratech.serialization.DataMarker;
import com.miratech.serialization.SerializableForm;
import java.time.LocalDateTime;
import javax.baja.nre.util.Array;

public class FileData
extends AbstractNanoData {
    private String fileName;
    private byte[] fileContent;
    private LocalDateTime timestamp;
    private int offset;
    private int partialContent;
    public static final int MAX_PARTIAL_FILE_CONTENT = 65536;

    public String getFileName() {
        return this.fileName;
    }

    public byte[] getFileContent() {
        Object fileContent;
        Object object = fileContent = this.getSerializableForm().data.length >= 2 ? this.getSerializableForm().data[1] : null;
        if (fileContent instanceof Array && ((Array)fileContent).size() > 0) {
            return (byte[])((Array)fileContent).get(0);
        }
        return new byte[0];
    }

    public LocalDateTime getTimestamp() {
        return this.timestamp;
    }

    public int getOffset() {
        return this.offset;
    }

    public int getPartialContent() {
        return this.partialContent;
    }

    private FileData(SerializableForm serializableFileData) {
        super(serializableFileData);
    }

    public static FileData make(BFileDataArgs fileDataArgs) {
        String folderPath = fileDataArgs.getFolderPath();
        String filePath = fileDataArgs.getFilePath();
        int offset = fileDataArgs.getOffset();
        int partialFileContent = fileDataArgs.getPartialFileContent();
        byte[] fileContent = fileDataArgs.getFileContent();
        return FileData.make(folderPath, filePath, offset, partialFileContent, fileContent);
    }

    public static FileData make(String folderPath, String filePath, int offset, int partialFileContent, byte[] fileContent) {
        Object[] fileData = new Object[3];
        String fileName = folderPath + "/" + filePath;
        byte[] transferData = new byte[]{};
        if (null == fileContent) {
            fileData[0] = fileName;
            fileData[1] = partialFileContent;
            fileData[2] = offset;
        } else {
            transferData = new byte[partialFileContent];
            System.arraycopy(fileContent, offset, transferData, 0, partialFileContent);
            fileData[0] = fileName;
            Object[] objetcs = new Byte[partialFileContent];
            for (int i = 0; i < partialFileContent; ++i) {
                objetcs[i] = transferData[i];
            }
            Array byteArray = new Array(Byte.class, partialFileContent);
            byteArray.addAll(objetcs);
            fileData[1] = byteArray;
            fileData[2] = offset;
        }
        SerializableForm serializableForm = new SerializableForm(DataMarker.FileData, fileData);
        FileData fd = new FileData(serializableForm);
        fd.offset = offset;
        fd.fileName = fileName;
        fd.fileContent = transferData;
        fd.partialContent = partialFileContent;
        return fd;
    }

    public static FileData parse(SerializableForm fileData) {
        if (fileData == null) {
            LOGGER.severe(String.format("[FileData.parse()]): Unexpected null data for serializableForm", new Object[0]));
            return null;
        }
        if (!fileData.marker.equals((Object)DataMarker.FileData)) {
            LOGGER.severe(String.format("[FileData.parse()]): Unexpected Data type: Expected marker: '%s', Received marker: '%s'.\nSkipping data processing.", new Object[]{DataMarker.FileData, fileData.marker}));
            return null;
        }
        FileData fd = new FileData(fileData);
        fd.fileName = (String)fileData.data[0];
        if (fileData.data.length >= 3 && fileData.data[2] instanceof LocalDateTime) {
            fd.timestamp = (LocalDateTime)fileData.data[2];
        }
        return fd;
    }
}

