/*
 * Decompiled with CFR 0.152.
 */
package com.miratech.nE2Link.parser.binary;

import com.miratech.nE2Link.parser.binary.AbstractNanoData;
import com.miratech.serialization.DataMarker;
import com.miratech.serialization.SerializableForm;
import java.time.LocalDateTime;

public class LogData
extends AbstractNanoData {
    private LocalDateTime timestamp;
    private String message;
    private String channel;
    private int severity;

    private LogData(SerializableForm serializedLogData) {
        super(serializedLogData);
        this.timestamp = (LocalDateTime)serializedLogData.data[0];
        this.message = serializedLogData.data[1].toString();
        this.channel = serializedLogData.data[2].toString();
        this.severity = Short.toUnsignedInt((Short)serializedLogData.data[3]);
    }

    public static LogData parse(SerializableForm serializedLinkData) {
        DataMarker marker = serializedLinkData.marker;
        if (marker.getValue() != DataMarker.LogData.getValue()) {
            LOGGER.severe(String.format("[ExistingLinkData.parse](): Unexpected Data type: Expected marker: '%s', Received marker: '%s'.\nSkipping data processing.", new Object[]{DataMarker.ExisitingLinkData, marker}));
            return null;
        }
        return new LogData(serializedLinkData);
    }
}

