/*
 * Decompiled with CFR 0.152.
 */
package com.miratech.nE2Link.parser.binary;

import com.miratech.nE2Link.parser.binary.AbstractNanoData;
import com.miratech.nE2Link.parser.binary.AbstractNanoRequest;
import com.miratech.nE2Link.parser.binary.AbstractNanoResponse;
import com.miratech.nE2Link.parser.binary.ObjectData;
import com.miratech.nE2Link.parser.binary.PollData;
import com.miratech.nE2Link.parser.binary.ResponseCode;
import com.miratech.nE2Link.parser.binary.TreeData;
import com.miratech.serialization.DataMarker;
import com.miratech.serialization.SerializableForm;
import java.util.List;

public class PollResponse
extends AbstractNanoResponse {
    private PollResponse(AbstractNanoRequest request, ResponseCode responseCode) {
        super(request, responseCode);
    }

    private PollResponse(AbstractNanoRequest request, List<SerializableForm> response) {
        super(request, response);
    }

    public static PollResponse make(AbstractNanoRequest request, ResponseCode responseCode) {
        return new PollResponse(request, responseCode);
    }

    public static PollResponse parse(AbstractNanoRequest request, List<SerializableForm> response) {
        return new PollResponse(request, response);
    }

    @Override
    public AbstractNanoData getResponseData() {
        return super.getResponseData(0);
    }

    @Override
    protected boolean isMalformedResponse(SerializableForm responseContentElement) {
        return !responseContentElement.marker.equals((Object)DataMarker.PollData) && !responseContentElement.marker.equals((Object)DataMarker.TreeData) && !responseContentElement.marker.equals((Object)DataMarker.ObjectData);
    }

    @Override
    public ResponseCode getResponseCode() {
        boolean allOK = true;
        ResponseCode lastResponseCode = ResponseCode.OK;
        for (int i = 0; i < this.getResponseDataSize() && lastResponseCode.equals((Object)ResponseCode.OK); ++i) {
            lastResponseCode = this.getResponseCode(i);
        }
        return lastResponseCode;
    }

    @Override
    protected AbstractNanoData doParseResponseContentElement(SerializableForm responseContentElement) {
        AbstractNanoData nanoData = null;
        if (responseContentElement.marker == DataMarker.TreeData) {
            nanoData = TreeData.parse(responseContentElement, this.getRequest().getNe2DeviceExt());
        } else if (responseContentElement.marker == DataMarker.ObjectData) {
            nanoData = ObjectData.parse(responseContentElement, this.getRequest().getNe2DeviceExt());
        } else if (responseContentElement.marker == DataMarker.PollData) {
            nanoData = PollData.parse(responseContentElement);
        }
        return nanoData;
    }

    @Override
    public String getLocalizedMessage(int index) {
        String message = "";
        switch (this.getResponseCode()) {
            case OK: {
                message = LEX.getText("POLL_OK");
                break;
            }
            case ERROR: {
                message = LEX.getText("POLL_ERROR", new Object[]{this.getErrorMessage(), this.getExceptionMessage(), this.getStackTrace()});
                break;
            }
            case NOT_CONNECTED: {
                message = LEX.getText("POLL_NOT_CONNECTED");
                break;
            }
            case NO_RESPONSE: {
                message = LEX.getText("POLL_NO_RESPONSE");
                break;
            }
            case INVALID_RESPONSE: {
                message = LEX.getText("POLL_INVALID_RESPONSE");
                break;
            }
            default: {
                message = LEX.getText("ILLEGAL_RESPONSE_CODE");
            }
        }
        return message;
    }
}

