/*
 * Decompiled with CFR 0.152.
 */
package com.miratech.nE2Link.parser.binary;

import com.miratech.ifnetclient.model.RemoteDevice;
import com.miratech.nE2Link.BNanoBaseComponent;
import com.miratech.nE2Link.BNe2DeviceExt;
import com.miratech.nE2Link.actions.BNanoScheduleChangedArg;
import com.miratech.nE2Link.parser.binary.AbstractNanoRequest;
import com.miratech.nE2Link.parser.binary.ResponseCode;
import com.miratech.nE2Link.parser.binary.ScheduleData;
import com.miratech.nE2Link.parser.binary.ScheduleResponse;
import com.miratech.serialization.SerializableForm;
import java.util.ArrayList;
import java.util.List;
import javax.baja.schedule.BAbstractSchedule;

public class ScheduleRequest
extends AbstractNanoRequest {
    private ScheduleRequest(BNe2DeviceExt ne2DeviceExt, BAbstractSchedule clientRequestData, ScheduleData requestData) {
        super(ne2DeviceExt, clientRequestData, requestData);
    }

    public static ScheduleRequest make(BNe2DeviceExt ne2DeviceExt, String persistentId, BAbstractSchedule schedule) {
        return new ScheduleRequest(ne2DeviceExt, schedule, ScheduleData.make(persistentId, schedule));
    }

    @Override
    public ScheduleData getRequestData() {
        return (ScheduleData)super.getRequestData();
    }

    public BAbstractSchedule getClientRequestData() {
        return (BAbstractSchedule)super.getClientRequestData();
    }

    @Override
    public ScheduleResponse postRequest(RemoteDevice remoteDevice) {
        if (remoteDevice == null || !remoteDevice.Remote.isConnected()) {
            return ScheduleResponse.make(this, ResponseCode.NOT_CONNECTED);
        }
        ArrayList<SerializableForm> response = remoteDevice.Remote.Schedule(this.getRequestData().getSerializableForm());
        if (response == null) {
            return ScheduleResponse.make(this, ResponseCode.NO_RESPONSE);
        }
        if (this.isResponseMalformed(response)) {
            return ScheduleResponse.make(this, ResponseCode.INVALID_RESPONSE);
        }
        return ScheduleResponse.parse(this, response);
    }

    @Override
    public String getLocalizedMessage() {
        BAbstractSchedule requestData = this.getClientRequestData();
        BNanoScheduleChangedArg changedArg = (BNanoScheduleChangedArg)requestData.getParent();
        BNanoBaseComponent nanoComponent = this.getNe2DeviceExt().getComponentCache().get(String.valueOf(changedArg.getPersistentId()));
        return LEX.getText("SCHEDULE_REQUEST", new Object[]{nanoComponent.getNanoName()});
    }

    @Override
    protected boolean isResponseMalformed(List<SerializableForm> response) {
        return response.size() != 0;
    }
}

