/*
 * Decompiled with CFR 0.152.
 */
package com.miratech.nE2Link.parser.binary;

import com.miratech.nE2Link.BNanoBaseComponent;
import com.miratech.nE2Link.BNanoStatusNumeric;
import com.miratech.nE2Link.actions.BNanoAction;
import com.miratech.nE2Link.actions.BNanoBooleanAction;
import com.miratech.nE2Link.actions.BNanoDoubleAction;
import com.miratech.nE2Link.actions.BNanoDynamicChoiceAction;
import com.miratech.nE2Link.actions.BNanoStringAction;
import com.miratech.nE2Link.choice.BDynamicChoice;
import com.miratech.nE2Link.choice.BStatusDynamicChoice;
import com.miratech.nE2Link.parser.binary.AbstractNanoData;
import com.miratech.nE2Link.parser.binary.Attributes;
import com.miratech.nE2Link.parser.binary.BNanoReference;
import com.miratech.serialization.DataMarker;
import com.miratech.serialization.SerializableForm;
import javax.baja.data.BIDataValue;
import javax.baja.naming.SlotPath;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusBoolean;
import javax.baja.status.BStatusEnum;
import javax.baja.status.BStatusString;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Flags;
import javax.baja.sys.Slot;

public class SlotSchema
extends AbstractNanoData {
    private String slotName;
    private String valueType;
    private Attributes attributes;

    private SlotSchema(SerializableForm slotData) {
        super(slotData);
        try {
            this.slotName = slotData.data[0].toString().trim();
            this.valueType = slotData.data[1].toString().trim();
            this.attributes = Attributes.parse(slotData.data[2]);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static SlotSchema parse(SerializableForm serializedSlotData) {
        DataMarker marker = serializedSlotData.marker;
        if (marker.getValue() != 45) {
            LOGGER.severe(String.format("[SlotSchema.parse())]: Unexpected Data type: marker: '%s'.\nSkipping data processing.", new Object[]{marker}));
            return null;
        }
        return new SlotSchema(serializedSlotData);
    }

    public String getNiagaraSlotName() {
        return SlotPath.escape((String)this.slotName);
    }

    public String getNanoSlotName() {
        return this.slotName;
    }

    public String getValueType() {
        return this.valueType;
    }

    public Attributes getAttributes() {
        return this.attributes;
    }

    public BFacets getNiagaraFacets() {
        BFacets facets = BFacets.make((String)"nano_name", (String)this.getNanoSlotName());
        facets = BFacets.make((BFacets)facets, (BFacets)BFacets.make((String)"nano_type", (String)this.getValueType()));
        if (!(this.isNiagaraAction() || this.isNiagaraReference() || this.isNiagaraDynamicChoice() && !this.isNiagaraEnumerated())) {
            facets = BFacets.make((BFacets)facets, (String)"fieldEditor", (BIDataValue)BString.make((String)"nE2Link:NanoStatusValueFE"));
        }
        facets = BFacets.make((BFacets)facets, (BFacets)this.getAttributes().getAttributesAsFacets());
        String attrValue = this.getAttributes().getAttributeValue("nullable", "false");
        facets = BFacets.make((BFacets)facets, (String)"allowNull", (BIDataValue)BBoolean.make((String)attrValue));
        return facets;
    }

    public int getNiagaraFlags() {
        String visibility;
        boolean readOnly = Boolean.parseBoolean(this.getAttributes().getAttributeValue("readonly", "false"));
        int initialFlags = readOnly ? Flags.add((int)1, (int[])new int[0]) : 0;
        switch (visibility = this.getAttributes().getAttributeValue("visibility", "normal")) {
            case "nowhere": {
                initialFlags = Flags.add((int)initialFlags, (int[])new int[]{4});
                initialFlags = Flags.remove((int)initialFlags, (int[])new int[]{8});
                break;
            }
            case "everywhere": {
                initialFlags = Flags.remove((int)initialFlags, (int[])new int[]{4});
                initialFlags = Flags.add((int)initialFlags, (int[])new int[]{8});
                break;
            }
            case "normal": {
                initialFlags = Flags.remove((int)initialFlags, (int[])new int[]{8});
                initialFlags = Flags.remove((int)initialFlags, (int[])new int[]{4});
            }
        }
        return initialFlags;
    }

    public BValue makeNiagaraDefaultValue() {
        boolean nullable = Boolean.parseBoolean(this.getAttributes().getAttributeValue("nullable", "false"));
        if (this.isNiagaraAction()) {
            String parameterType = this.getAttributes().getAttribute("action").getAttrValue();
            if (SlotSchema.isNiagaraBoolean(parameterType)) {
                return new BNanoBooleanAction();
            }
            if (SlotSchema.isNiagaraNumeric(parameterType, this.getAttributes())) {
                return new BNanoDoubleAction();
            }
            if (SlotSchema.isNiagaraDynamicChoice(this.getAttributes())) {
                return new BNanoDynamicChoiceAction();
            }
            if (SlotSchema.isNiagaraString(parameterType)) {
                return new BNanoStringAction();
            }
            if (SlotSchema.isNiagaraVoid(parameterType)) {
                return new BNanoAction();
            }
            return null;
        }
        if (this.isNiagaraDynamicChoice()) {
            BDynamicChoice value = BDynamicChoice.DEFAULT;
            if (!this.isNiagaraEnumerated()) {
                return value;
            }
            if (nullable) {
                return new BStatusDynamicChoice(value, BStatus.nullStatus);
            }
            return new BStatusDynamicChoice(value);
        }
        if (this.isNiagaraBoolean()) {
            if (nullable) {
                return new BStatusBoolean(false, BStatus.nullStatus);
            }
            return new BStatusBoolean(false);
        }
        if (this.isNiagaraNumeric()) {
            if (nullable) {
                return new BNanoStatusNumeric(0.0, BStatus.nullStatus);
            }
            return new BNanoStatusNumeric(0.0);
        }
        if (this.isNiagaraEnum()) {
            if (nullable) {
                return new BStatusEnum((BEnum)BDynamicEnum.make((BEnumRange)this.getAttributes().getNiagaraRange()), BStatus.nullStatus);
            }
            return new BStatusEnum((BEnum)BDynamicEnum.make((BEnumRange)this.getAttributes().getNiagaraRange()));
        }
        if (this.isNiagaraString()) {
            if (nullable) {
                return new BStatusString("", BStatus.nullStatus);
            }
            return new BStatusString("");
        }
        if (this.isNiagaraReference()) {
            return new BNanoReference();
        }
        return null;
    }

    public boolean isNiagaraBoolean() {
        return SlotSchema.isNiagaraBoolean(this.getValueType());
    }

    public boolean isNiagaraNumeric() {
        return SlotSchema.isNiagaraNumeric(this.getValueType(), this.getAttributes());
    }

    public boolean isNiagaraEnum() {
        return SlotSchema.isNiagaraEnum(this.getAttributes());
    }

    public boolean isNiagaraString() {
        return SlotSchema.isNiagaraString(this.getValueType());
    }

    public boolean isNiagaraDynamicChoice() {
        return SlotSchema.isNiagaraDynamicChoice(this.getAttributes());
    }

    public boolean isNiagaraEnumerated() {
        return SlotSchema.isNiagaraEnumerated(this.attributes);
    }

    public static boolean isNiagaraBoolean(String valueType) {
        return "boolean".equalsIgnoreCase(valueType) || "bool".equalsIgnoreCase(valueType);
    }

    public static boolean isNiagaraBoolean(Slot slot) {
        return SlotSchema.isNiagaraBoolean(SlotSchema.getNanoValueType(slot));
    }

    public static boolean isNiagaraNumeric(String valueType, Attributes attributes) {
        return "double".equalsIgnoreCase(valueType) && !SlotSchema.isNiagaraEnum(attributes) && !SlotSchema.isNiagaraEnumerated(attributes);
    }

    public static boolean isNiagaraNumeric(Slot slot) {
        String valueType = SlotSchema.getNanoValueType(slot);
        return SlotSchema.isNiagaraNumeric(valueType, slot.getFacets());
    }

    public static boolean isNiagaraNumeric(String valueType, BFacets slotFacets) {
        return "double".equalsIgnoreCase(valueType) && !SlotSchema.isNiagaraEnum(slotFacets);
    }

    public static boolean isNiagaraEnum(Attributes attributes) {
        return attributes.getNiagaraRange() != null;
    }

    public static boolean isNiagaraEnum(BFacets slotFacets) {
        return BNanoBaseComponent.getNanoAttribute(slotFacets, "range") != null;
    }

    public static boolean isNiagaraString(Slot slot) {
        return SlotSchema.isNiagaraString(SlotSchema.getNanoValueType(slot));
    }

    public static boolean isNiagaraString(String valueType) {
        return "string".equalsIgnoreCase(valueType);
    }

    public static boolean isNiagaraVoid(String valueType) {
        return "void".equalsIgnoreCase(valueType);
    }

    public static boolean isNiagaraDynamicChoice(Attributes attributes) {
        return attributes.getAttribute("dynamicchoice") != null || SlotSchema.isNiagaraEnumerated(attributes);
    }

    public static String getNanoValueType(Slot slot) {
        BFacets facets = slot.getFacets();
        return SlotSchema.getNanoValueType(facets);
    }

    public static String getNanoValueType(BFacets slotFacets) {
        return slotFacets.gets("nano_type", null);
    }

    public static boolean isNiagaraEnumerated(Attributes attributes) {
        return attributes.getAttribute("enumerated") != null;
    }

    public boolean isNiagaraAction() {
        return this.getAttributes().contains("action");
    }

    public boolean isNiagaraReference() {
        return "reference".equalsIgnoreCase(this.getNanoSlotName()) && SlotSchema.isNiagaraVoid(this.getValueType());
    }
}

