/*
 * Decompiled with CFR 0.152.
 */
package com.miratech.nE2Link.parser.binary;

import com.miratech.ifnetclient.model.RemoteDevice;
import com.miratech.nE2Link.BNanoBaseComponent;
import com.miratech.nE2Link.BNe2DeviceExt;
import com.miratech.nE2Link.parser.binary.AbstractNanoRequest;
import com.miratech.nE2Link.parser.binary.ObjectIdsData;
import com.miratech.nE2Link.parser.binary.ResponseCode;
import com.miratech.nE2Link.parser.binary.SubscribeResponse;
import com.miratech.serialization.SerializableForm;
import java.util.ArrayList;

public class SubscribeRequest
extends AbstractNanoRequest {
    private SubscribeRequest(BNe2DeviceExt ne2DeviceExt, BNanoBaseComponent[] clientRequestData, ObjectIdsData requestData) {
        super(ne2DeviceExt, clientRequestData, requestData);
    }

    public static SubscribeRequest make(BNe2DeviceExt ne2DeviceExt, BNanoBaseComponent[] components) {
        return new SubscribeRequest(ne2DeviceExt, components, ObjectIdsData.make(components));
    }

    @Override
    public SubscribeResponse postRequest(RemoteDevice remoteDevice) {
        if (remoteDevice == null || !remoteDevice.Remote.isConnected()) {
            return SubscribeResponse.make(this, ResponseCode.NOT_CONNECTED);
        }
        ArrayList<SerializableForm> response = remoteDevice.Remote.Subscribe(this.getRequestData().getSerializableForm());
        if (response == null) {
            return SubscribeResponse.make(this, ResponseCode.NO_RESPONSE);
        }
        if (this.isResponseMalformed(response)) {
            return SubscribeResponse.make(this, ResponseCode.INVALID_RESPONSE);
        }
        return SubscribeResponse.parse(this, response);
    }

    @Override
    public ObjectIdsData getRequestData() {
        return (ObjectIdsData)super.getRequestData();
    }

    public BNanoBaseComponent[] getClientRequestData() {
        return (BNanoBaseComponent[])super.getClientRequestData();
    }

    @Override
    public String getLocalizedMessage() {
        StringBuilder sb = new StringBuilder();
        BNanoBaseComponent[] componentsToSubscribe = this.getClientRequestData();
        if (componentsToSubscribe.length == 0) {
            sb.append(LEX.getText("NONE"));
        } else {
            for (BNanoBaseComponent componentToSubscribe : componentsToSubscribe) {
                sb.append(LEX.getText("SUBSCRIBE_LIST_ENTRY", new Object[]{componentToSubscribe.getGlobalIndex(), componentToSubscribe.getNavOrd().toString()})).append('\n');
            }
        }
        return LEX.getText("SUBSCRIBE_REQUEST", new Object[]{sb.toString()});
    }
}

