/*
 * Decompiled with CFR 0.152.
 */
package com.miratech.nE2Link.parser.binary;

import com.miratech.nE2Link.BNanoBaseComponent;
import com.miratech.nE2Link.parser.binary.AbstractNanoData;
import com.miratech.nE2Link.parser.binary.AbstractNanoRequest;
import com.miratech.nE2Link.parser.binary.AbstractNanoResponse;
import com.miratech.nE2Link.parser.binary.PollData;
import com.miratech.nE2Link.parser.binary.ResponseCode;
import com.miratech.serialization.DataMarker;
import com.miratech.serialization.SerializableForm;
import java.util.List;

public class SubscribeResponse
extends AbstractNanoResponse {
    private SubscribeResponse(AbstractNanoRequest request, ResponseCode responseCode) {
        super(request, responseCode);
    }

    private SubscribeResponse(AbstractNanoRequest request, List<SerializableForm> response) {
        super(request, response);
    }

    public static SubscribeResponse make(AbstractNanoRequest request, ResponseCode responseCode) {
        return new SubscribeResponse(request, responseCode);
    }

    public static SubscribeResponse parse(AbstractNanoRequest request, List<SerializableForm> response) {
        return new SubscribeResponse(request, response);
    }

    @Override
    public PollData getResponseData(int index) {
        return (PollData)super.getResponseData(index);
    }

    @Override
    protected boolean isMalformedResponse(SerializableForm responseContentElement) {
        return !responseContentElement.marker.equals((Object)DataMarker.PollData);
    }

    @Override
    protected AbstractNanoData doParseResponseContentElement(SerializableForm responseContentElement) {
        return PollData.parse(responseContentElement);
    }

    @Override
    public PollData getResponseData() {
        return (PollData)super.getResponseData();
    }

    @Override
    public String getLocalizedMessage() {
        StringBuilder sb = new StringBuilder("-----------------SUBSCRIPTION RESULT: ---------------\n");
        for (int i = 0; i < this.getResponseDataSize(); ++i) {
            sb.append(this.getLocalizedMessage(i)).append('\n');
        }
        if (sb.length() > 0) {
            sb.setLength(sb.length() - 1);
        }
        return sb.toString();
    }

    @Override
    public String getLocalizedMessage(int index) {
        PollData responseData = this.getResponseData(index);
        int globalIndex = responseData != null ? responseData.getGlobalId() : -1;
        BNanoBaseComponent subscribedComponent = this.getRequest().getNe2DeviceExt().getComponentCache().get(globalIndex);
        String componentOrd = subscribedComponent != null && subscribedComponent.isMounted() ? subscribedComponent.getNavOrd().toString() : "unknown or unmounted component";
        String message = LEX.getText("SUBSCRIBE_LIST_ENTRY", new Object[]{globalIndex, componentOrd});
        switch (this.getResponseCode(index)) {
            case OK: {
                message = LEX.getText("SUBSCRIBE_OK", new Object[]{message});
                break;
            }
            case ERROR: {
                message = LEX.getText("SUBSCRIBE_ERROR", new Object[]{message, this.getErrorMessage(index), this.getExceptionMessage(index), this.getStackTrace(index)});
                break;
            }
            case NOT_CONNECTED: {
                message = LEX.getText("SUBSCRIBE_NOT_CONNECTED");
                break;
            }
            case NO_RESPONSE: {
                message = LEX.getText("SUBSCRIBE_NO_RESPONSE");
                break;
            }
            case INVALID_RESPONSE: {
                message = LEX.getText("SUBSCRIBE_INVALID_RESPONSE", new Object[]{message});
                break;
            }
            default: {
                message = LEX.getText("ILLEGAL_RESPONSE_CODE");
            }
        }
        return message;
    }
}

