/*
 * Decompiled with CFR 0.152.
 */
package com.miratech.nE2Link.parser.binary;

import com.miratech.nE2Link.BNanoBaseComponent;
import com.miratech.nE2Link.BNe2DeviceExt;
import com.miratech.nE2Link.parser.binary.AbstractNanoData;
import com.miratech.nE2Link.parser.binary.ObjectData;
import com.miratech.serialization.DataMarker;
import com.miratech.serialization.SerializableForm;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.baja.sys.BComplex;

public class TreeData
extends AbstractNanoData {
    private int globalIndex = -1;
    private List<ObjectData> nanoObjects = new ArrayList<ObjectData>();

    protected TreeData(SerializableForm serializableForm) {
        super(serializableForm);
    }

    public int getGlobalIndex() {
        return this.globalIndex;
    }

    public static TreeData parse(SerializableForm serializedTreeData, BNe2DeviceExt controller) {
        TreeData treeData = new TreeData(serializedTreeData);
        treeData.globalIndex = Short.toUnsignedInt((Short)serializedTreeData.data[0]);
        for (SerializableForm serializedElement : serializedTreeData.elements.toSerializableForms()) {
            if (serializedElement.marker == DataMarker.ObjectData) {
                ObjectData nanoObject = ObjectData.parse(serializedElement, controller);
                treeData.nanoObjects.add(nanoObject);
                continue;
            }
            LOGGER.severe(String.format("[TreeData.parse] Unknown marker type. Expected %s, received, %s", new Object[]{DataMarker.ObjectData, serializedElement.marker}));
            return null;
        }
        return treeData;
    }

    public void updateNiagaraTree(BNe2DeviceExt controller) {
        BNanoBaseComponent rootComponent = controller.getComponentCache().get(this.globalIndex);
        LOGGER.info(String.format("[TreeData.parse] component: %s global index %d", rootComponent.getNanoName(), rootComponent.getGlobalIndex()));
        this.nanoObjects.stream().filter(nanoObject -> controller.getComponentCache().get(nanoObject.getGlobalIndex()) == null).forEach(nanoObject -> {
            nanoObject.createNiagaraComponent(controller);
            System.out.println(String.format("[TreeData.updateNiagaraTree]: Other tool changed Niagara tree. Added component %s", nanoObject.getNanoName()));
        });
        Set existingNanoIds = this.nanoObjects.stream().mapToInt(ObjectData::getGlobalIndex).boxed().collect(Collectors.toSet());
        Arrays.stream(rootComponent.getDescendants(BNanoBaseComponent.class, false, false)).filter(niagaraChild -> !existingNanoIds.contains(niagaraChild.getGlobalIndex())).forEach(niagaraChild -> {
            BNanoBaseComponent parent = (BNanoBaseComponent)niagaraChild.getParent();
            parent.remove((BComplex)niagaraChild);
            controller.getComponentCache().remove(niagaraChild.getGlobalIndex());
            System.out.println(String.format("[TreeData.updateNiagaraTree]: Other tool changed Niagara tree. Removed component %s", niagaraChild.getNanoName()));
        });
    }
}

