/*
 * Decompiled with CFR 0.152.
 */
package com.miratech.nE2Link.parser.binary;

import com.miratech.nE2Link.BNanoBaseComponent;
import com.miratech.nE2Link.BNanoStatusNumeric;
import com.miratech.nE2Link.actions.BNanoInvocationArg;
import com.miratech.nE2Link.actions.BNanoPropertyChangedArg;
import com.miratech.nE2Link.choice.BDynamicChoice;
import com.miratech.nE2Link.choice.BStatusDynamicChoice;
import com.miratech.nE2Link.parser.binary.AbstractNanoData;
import com.miratech.serialization.DataMarker;
import com.miratech.serialization.SerializableForm;
import javax.baja.status.BStatusBoolean;
import javax.baja.status.BStatusEnum;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusString;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BDouble;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;

public class WriteData
extends AbstractNanoData {
    private WriteData(SerializableForm serializableObjectIdData) {
        super(serializableObjectIdData);
    }

    public static WriteData make(BNanoInvocationArg invocationArg) {
        Object[] writeData = new Object[3];
        writeData[0] = (short)invocationArg.getActionSourceComponent().getGlobalIndex();
        writeData[1] = String.valueOf(invocationArg.getActionName());
        if (invocationArg.getActionParameter() == null) {
            writeData[2] = null;
        } else if (invocationArg.getActionParameter().getType().is(BDouble.TYPE)) {
            writeData[2] = ((BDouble)invocationArg.getActionParameter()).getDouble();
        } else if (invocationArg.getActionParameter().getType().is(BBoolean.TYPE)) {
            writeData[2] = ((BBoolean)invocationArg.getActionParameter()).getBoolean();
        } else if (invocationArg.getActionParameter().getType().is(BString.TYPE)) {
            writeData[2] = ((BString)invocationArg.getActionParameter()).getString();
        } else if (invocationArg.getActionParameter().getType().is(BDynamicChoice.TYPE)) {
            writeData[2] = ((BDynamicChoice)invocationArg.getActionParameter()).getKeyAsNanoObject((Slot)invocationArg.getActionProperty());
        }
        SerializableForm serializableForm = new SerializableForm(DataMarker.WriteData, writeData);
        return new WriteData(serializableForm);
    }

    public static WriteData make(BNanoPropertyChangedArg changedArg) {
        BNanoBaseComponent comp = changedArg.getSourceComponent();
        Property changedProp = changedArg.getChangedProperty();
        Object[] writeData = new Object[3];
        Integer slotId = comp.getNanoSlotId(changedProp);
        writeData[0] = (short)comp.getGlobalIndex();
        writeData[1] = slotId.byteValue();
        boolean isNullStatus = false;
        BValue newValue = changedArg.getPendingValue();
        if (newValue instanceof BStatusValue) {
            isNullStatus = ((BStatusValue)newValue).getStatus().isNull();
        }
        if (changedProp.getType().is(BNanoStatusNumeric.TYPE)) {
            writeData[2] = isNullStatus ? null : Double.valueOf(((BNanoStatusNumeric)newValue).getNumeric());
        } else if (changedProp.getType().is(BStatusNumeric.TYPE)) {
            writeData[2] = isNullStatus ? null : Double.valueOf(((BStatusNumeric)newValue).getNumeric());
        } else if (changedProp.getType().is(BStatusBoolean.TYPE)) {
            writeData[2] = isNullStatus ? null : Boolean.valueOf(((BStatusBoolean)newValue).getBoolean());
        } else if (changedProp.getType().is(BStatusEnum.TYPE)) {
            writeData[2] = isNullStatus ? null : Double.valueOf(((BStatusEnum)newValue).getValue().getOrdinal());
        } else if (changedProp.getType().is(BStatusString.TYPE)) {
            writeData[2] = isNullStatus ? null : ((BStatusString)newValue).getValue();
        } else if (changedProp.getType().is(BDynamicChoice.TYPE) || changedProp.getType().is(BStatusDynamicChoice.TYPE)) {
            BDynamicChoice choice = changedProp.getType().is(BStatusDynamicChoice.TYPE) ? ((BStatusDynamicChoice)changedArg.getPendingValue()).getValue() : (BDynamicChoice)changedArg.getPendingValue();
            Object choiceValue = choice.isNull() ? null : choice.getKeyAsNanoObject((Slot)changedProp);
            writeData[2] = isNullStatus ? null : choiceValue;
        }
        SerializableForm serializableForm = new SerializableForm(DataMarker.WriteData, writeData);
        return new WriteData(serializableForm);
    }

    public static WriteData parse(SerializableForm writeData) {
        if (writeData == null) {
            LOGGER.severe("[WriteData.parse()]): Unexpected null data for serializableForm");
            return null;
        }
        if (!writeData.marker.equals((Object)DataMarker.WriteData)) {
            LOGGER.severe(String.format("[WriteData.parse()]): Unexpected Data type: Expected marker: '%s', Received marker: '%s'.\nSkipping data processing.", new Object[]{DataMarker.WriteData, writeData.marker}));
            return null;
        }
        return new WriteData(writeData);
    }
}

