/*
 * Decompiled with CFR 0.152.
 */
package com.miratech.nE2Link.parser.binary;

import com.miratech.nE2Link.actions.BNanoPropertyChangedArg;
import com.miratech.nE2Link.parser.binary.AbstractNanoData;
import com.miratech.nE2Link.parser.binary.AbstractNanoRequest;
import com.miratech.nE2Link.parser.binary.AbstractNanoResponse;
import com.miratech.nE2Link.parser.binary.PollData;
import com.miratech.nE2Link.parser.binary.ResponseCode;
import com.miratech.nE2Link.parser.binary.WriteRequest;
import com.miratech.serialization.DataMarker;
import com.miratech.serialization.SerializableForm;
import java.util.List;

public class WriteResponse
extends AbstractNanoResponse {
    private WriteResponse(AbstractNanoRequest request, ResponseCode responseCode) {
        super(request, responseCode);
    }

    private WriteResponse(AbstractNanoRequest request, List<SerializableForm> response) {
        super(request, response);
    }

    public static WriteResponse make(AbstractNanoRequest request, ResponseCode responseCode) {
        return new WriteResponse(request, responseCode);
    }

    public static WriteResponse parse(AbstractNanoRequest request, List<SerializableForm> response) {
        return new WriteResponse(request, response);
    }

    @Override
    protected boolean isMalformedResponse(SerializableForm responseContentElement) {
        return !responseContentElement.marker.equals((Object)DataMarker.PollData);
    }

    @Override
    protected AbstractNanoData doParseResponseContentElement(SerializableForm responseContentElement) {
        return PollData.parse(responseContentElement);
    }

    @Override
    public PollData getResponseData() {
        return (PollData)super.getResponseData();
    }

    @Override
    public String getLocalizedMessage(int index) {
        BNanoPropertyChangedArg requestData = ((WriteRequest)this.getRequest()).getClientRequestData();
        String sourceComponent = requestData.getSourceComponent().getNavOrd().toString();
        String changedProperty = requestData.getChangedProperty().toString();
        String oldValue = requestData.getOldValue().toString();
        String pendingValue = requestData.getPendingValue().toString();
        String message = "";
        switch (this.getResponseCode()) {
            case OK: {
                message = LEX.getText("WRITE_OK", new Object[]{sourceComponent, changedProperty, oldValue, pendingValue});
                break;
            }
            case ERROR: {
                message = LEX.getText("WRITE_ERROR", new Object[]{sourceComponent, changedProperty, oldValue, pendingValue, this.getErrorMessage(), this.getExceptionMessage(), this.getStackTrace()});
                break;
            }
            case NOT_CONNECTED: {
                message = LEX.getText("WRITE_NOT_CONNECTED", new Object[]{sourceComponent, changedProperty, oldValue, pendingValue});
                break;
            }
            case NO_RESPONSE: {
                message = LEX.getText("WRITE_NO_RESPONSE", new Object[]{sourceComponent, changedProperty, oldValue, pendingValue});
                break;
            }
            case INVALID_RESPONSE: {
                message = LEX.getText("WRITE_INVALID_RESPONSE", new Object[]{sourceComponent, changedProperty, oldValue, pendingValue});
                break;
            }
            default: {
                message = LEX.getText("ILLEGAL_RESPONSE_CODE");
            }
        }
        return message;
    }
}

