/*
 * Decompiled with CFR 0.152.
 */
package com.miratech.nE2Link.parser.xml;

import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Logger;
import javax.baja.file.types.text.BXmlFile;
import javax.baja.naming.BOrd;
import javax.baja.xml.XElem;
import javax.baja.xml.XParser;

public class XParserEx
extends XParser {
    public static final Logger LOGGER = Logger.getLogger("nE2Link");

    protected XParserEx(InputStream in) throws IOException {
        super(in);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized XElem loadXml(BOrd xmlFileOrd) {
        BXmlFile applicationFile;
        XElem xmlRoot = null;
        try {
            applicationFile = (BXmlFile)xmlFileOrd.get();
        }
        catch (Exception e) {
            LOGGER.severe("CANNOT FIND FILE '" + xmlFileOrd + "'");
            throw e;
        }
        try {
            XParser xParser = XParserEx.make((InputStream)applicationFile.getInputStream());
            xmlRoot = xParser.parse();
        }
        catch (Exception e) {
            LOGGER.severe("Failed to parse XML File\n     File Space: " + applicationFile.getFileSpace() + "\n     File Name: " + applicationFile.getFileName() + "\n     File Path: " + applicationFile.getFilePath());
        }
        finally {
            try {
                applicationFile.getInputStream().close();
            }
            catch (IOException iOException) {}
        }
        return xmlRoot;
    }

    public static Integer readIntegerFromXMLAttribute(XElem xElem, String attrName) {
        return XParserEx.readIntegerFromXMLAttribute(xElem, attrName, null);
    }

    public static Integer readIntegerFromXMLAttribute(XElem xElem, String attrName, Integer def) {
        int attrIndex = xElem.attrIndex(attrName);
        if (attrIndex != -1) {
            return new Integer(xElem.attrValue(attrIndex));
        }
        return def;
    }

    public static Long readLongFromXMLAttribute(XElem xElem, String attrName) {
        return XParserEx.readLongFromXMLAttribute(xElem, attrName, null);
    }

    public static Long readLongFromXMLAttribute(XElem xElem, String attrName, Long def) {
        int attrIndex = xElem.attrIndex(attrName);
        if (attrIndex != -1) {
            return new Long(xElem.attrValue(attrIndex));
        }
        return def;
    }

    public static Double readDoubleFromXMLAttribute(XElem xElem, String attrName) {
        return XParserEx.readDoubleFromXMLAttribute(xElem, attrName, null);
    }

    public static Double readDoubleFromXMLAttribute(XElem xElem, String attrName, Double def) {
        int attrIndex = xElem.attrIndex(attrName);
        if (attrIndex != -1) {
            return new Double(xElem.attrValue(attrIndex));
        }
        return def;
    }

    public static String readStringFromXMLAttribute(XElem xElem, String attrName) {
        return XParserEx.readStringFromXMLAttribute(xElem, attrName, null);
    }

    public static String readStringFromXMLAttribute(XElem xElem, String attrName, String def) {
        int attrIndex = xElem.attrIndex(attrName);
        if (attrIndex != -1) {
            return xElem.attrValue(attrIndex);
        }
        return def;
    }

    public static Boolean readBooleanFromXMLAttribute(XElem xElem, String attrName) {
        return XParserEx.readBooleanFromXMLAttribute(xElem, attrName, null);
    }

    public static Boolean readBooleanFromXMLAttribute(XElem xElem, String attrName, Boolean def) {
        int attrIndex = xElem.attrIndex(attrName);
        if (attrIndex != -1) {
            return new Boolean(xElem.attrValue(attrIndex));
        }
        return def;
    }
}

