/*
 * Decompiled with CFR 0.152.
 */
package com.miratech.nE2Link.schedules;

import com.miratech.ifnetclient.model.scheduleLogic.ICalendar;
import com.miratech.ifnetclient.model.scheduleLogic.ISchedule;
import com.miratech.nE2Link.choice.BDynamicChoiceRange;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.schedule.BCalendarSchedule;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Subscriber;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public class BNanoCalendar
extends BCalendarSchedule
implements ICalendar {
    public static final Type TYPE = Sys.loadType(BNanoCalendar.class);
    Subscriber subscriber = new Subscriber(){

        public void event(BComponentEvent event) {
            if (event.getId() == 0) {
                // empty if block
            }
        }
    };
    private ISchedule[] days;
    private boolean isActive;
    private boolean isEnabled;
    private boolean isOverridden;
    private List<ISchedule> specialEventsList = new ArrayList<ISchedule>();
    public Class outputType;

    public Type getType() {
        return TYPE;
    }

    public BNanoCalendar() {
    }

    public BNanoCalendar(Class withOutputType, ISchedule[] withSpecialEvents, BDynamicChoiceRange valueRestrictions) {
        this.outputType = withOutputType;
        List<Object> list = withSpecialEvents == null ? null : (this.specialEventsList = Arrays.asList(withSpecialEvents) != null ? Arrays.asList(withSpecialEvents) : new ArrayList());
        if (valueRestrictions != null && !valueRestrictions.getId().isEmpty()) {
            this.add(valueRestrictions.getId(), (BValue)valueRestrictions, valueRestrictions.getFlags(), BFacets.make((BFacets)BFacets.make((String)"nano_type", (String)"booleanRange"), (BFacets)BFacets.make((String)"rangeAsSubform", (boolean)true)), Context.decoding);
        }
    }

    public BNanoCalendar(ISchedule[] days, boolean isActive, boolean isEnabled, boolean isOverridden) {
        this.days = days;
        this.isActive = isActive;
        this.isEnabled = isEnabled;
        this.isOverridden = isOverridden;
    }

    public void started() throws Exception {
        super.started();
        BDynamicChoiceRange labels = this.getLabels();
        BFacets facets = null != labels ? labels.asFacets(BBoolean.TYPE, null) : null;
        this.setFacets(BFacets.make((BFacets)this.getFacets(), (BFacets)facets));
        this.subscriber.subscribe((BComponent)this.getParent());
    }

    public void stopped() throws Exception {
        super.stopped();
        this.subscriber.unsubscribeAll();
    }

    public void changed(Property p, Context c) {
        if (p.getName().equals("labels")) {
            BDynamicChoiceRange labels = this.getLabels();
            BFacets facets = null != labels ? labels.asFacets(BBoolean.TYPE, null) : null;
            this.setFacets(BFacets.make((BFacets)this.getFacets(), (BFacets)facets));
        }
        super.changed(p, c);
    }

    public BDynamicChoiceRange getLabels() {
        return (BDynamicChoiceRange)this.get("labels");
    }

    public void doExecute() {
    }

    public final List<ISchedule> getSpecialEventsList() {
        return this.specialEventsList;
    }

    @Override
    public ISchedule[] getDays() {
        return this.days;
    }

    @Override
    public boolean isActiveNow() {
        return this.isActive;
    }

    @Override
    public boolean isEnabled() {
        return this.isEnabled;
    }

    @Override
    public boolean isOverridden() {
        return this.isOverridden;
    }
}

