/*
 * Decompiled with CFR 0.152.
 */
package com.miratech.nE2Link.schedules;

import com.miratech.ifnetclient.model.scheduleLogic.Month;
import com.miratech.ifnetclient.model.scheduleLogic.NanoScheduleUtil;
import com.miratech.ifnetclient.model.scheduleLogic.WeekOfMonth;
import com.miratech.nE2Link.schedules.utils.ScheduleUtils;
import java.time.LocalDate;
import javax.baja.data.BIDataValue;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.schedule.BAbstractSchedule;
import javax.baja.schedule.BWeekAndDaySchedule;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.BMonth;
import javax.baja.sys.BWeekday;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;

@NiagaraType
public class BNanoWeekAndDaySchedule
extends BWeekAndDaySchedule {
    public static final Type TYPE = Sys.loadType(BNanoWeekAndDaySchedule.class);
    private static String[] weekOfMonDisplayNames = new String[]{"Any Week", "Days1-7", "Days8-14", "Days15-21", "Days22-28", "Days after 28th", "1-7 days till end", "8-14 days till end", "15-21 days till end", "22-28 days till end"};

    public Type getType() {
        return TYPE;
    }

    public BNanoWeekAndDaySchedule() {
    }

    public BNanoWeekAndDaySchedule(int dayOfWeek, WeekOfMonth weekOfMonth, Month startMonthOfYear) {
        if (dayOfWeek >= 0) {
            this.setWeekday(dayOfWeek);
        }
        if (weekOfMonth != null) {
            this.setWeek(weekOfMonth.getValue());
        }
        if (startMonthOfYear != null) {
            this.setMonth(startMonthOfYear.getValue() - 1);
        }
    }

    public void started() {
        try {
            super.started();
            if (this.getMonths().getSlotFacets(this.getMonths().getSlot("set")).getFacet("range") == null) {
                this.getMonths().setFacets(this.getMonths().getSlot("set"), BFacets.make((String)"range", (BIDataValue)BEnumRange.make((String[])NanoScheduleUtil.months)));
            }
            if (this.getWeeksOfMonth().getSlotFacets(this.getWeeksOfMonth().getSlot("set")).getFacet("range") == null) {
                this.getWeeksOfMonth().setFacets(this.getWeeksOfMonth().getSlot("set"), BFacets.make((String)"range", (BIDataValue)BEnumRange.make((String[])NanoScheduleUtil.weeksOfMonth)));
            }
            if (this.getWeekdays().getSlotFacets(this.getWeekdays().getSlot("set")).getFacet("range") == null) {
                this.getWeekdays().setFacets(this.getWeekdays().getSlot("set"), BFacets.make((String)"range", (BIDataValue)BEnumRange.make((String[])NanoScheduleUtil.weekdays)));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public BAbsTime nextEvent(BAbsTime after) {
        LocalDate localDate = ScheduleUtils.getStartDateWeekAndDay(after, this);
        return BAbsTime.make((int)localDate.getYear(), (BMonth)BMonth.make((int)(localDate.getMonthValue() - 1)), (int)localDate.getDayOfMonth());
    }

    public String toString(Context cx) {
        Lexicon l = Lexicon.make(BAbstractSchedule.class);
        boolean criteria = false;
        StringBuffer buf = new StringBuffer("");
        int i = this.getWeekday();
        if (i >= 0) {
            BWeekday w = BWeekday.make((int)i);
            buf.append(w.getDisplayTag(cx));
            criteria = true;
        }
        if ((i = this.getWeek()) >= 0) {
            if (criteria) {
                buf.append(", ");
            }
            buf.append(weekOfMonDisplayNames[i]);
            criteria = true;
        } else if (criteria) {
            buf.append(", ").append(l.get("week.everyWeek"));
        }
        i = this.getMonth();
        if (i >= 0) {
            if (criteria) {
                buf.append(", ");
            }
            if (i == 12) {
                buf.append("Odd Months");
            } else if (i == 13) {
                buf.append("Even Months");
            } else {
                BMonth m = BMonth.make((int)i);
                buf.append(m.getDisplayTag(cx));
            }
            criteria = true;
        } else if (criteria) {
            buf.append(", ").append(l.get("month.everyMonth"));
        }
        if (!criteria) {
            buf.append("Every Day");
        }
        return buf.toString();
    }
}

