/*
 * Decompiled with CFR 0.152.
 */
package com.miratech.nE2Link.utils;

import com.miratech.nE2Link.BNe2DeviceExt;
import com.miratech.nE2Link.parser.binary.DeleteFileRequest;
import com.miratech.nE2Link.parser.binary.DeleteFileResponse;
import com.miratech.nE2Link.parser.binary.FileData;
import com.miratech.nE2Link.parser.binary.FolderData;
import com.miratech.nE2Link.parser.binary.GetFileRequest;
import com.miratech.nE2Link.parser.binary.GetFileResponse;
import com.miratech.nE2Link.parser.binary.GetFolderRequest;
import com.miratech.nE2Link.parser.binary.GetFolderResponse;
import com.miratech.nE2Link.parser.binary.PutFileRequest;
import com.miratech.nE2Link.parser.binary.PutFileResponse;
import com.miratech.nE2Link.utils.BFileDataArgs;
import com.miratech.serialization.DataMarker;
import com.miratech.serialization.SerializableForm;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.Array;
import javax.baja.sys.BComponent;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public class BFileTransfer
extends BComponent {
    public static final Type TYPE = Sys.loadType(BFileTransfer.class);
    BNe2DeviceExt ne2DeviceExt;
    final int MAX_LENGTH = 65536;

    public Type getType() {
        return TYPE;
    }

    public BFileTransfer(BNe2DeviceExt ne2DeviceExt) {
        this.ne2DeviceExt = ne2DeviceExt;
    }

    public Map<String, LocalDateTime> folderGet(String folderPath) {
        HashMap<String, LocalDateTime> files = new HashMap<String, LocalDateTime>();
        GetFolderRequest request = GetFolderRequest.make(this.ne2DeviceExt, folderPath);
        GetFolderResponse response = request.postRequest(this.ne2DeviceExt.getRemoteDevice());
        String message = "";
        switch (response.getResponseCode()) {
            case OK: {
                FolderData nanoData = response.getResponseData();
                if (!(nanoData instanceof FolderData)) break;
                for (SerializableForm elem : nanoData.getSerializableForm().elements.toSerializableForms()) {
                    DataMarker folderMarker = elem.marker;
                    DataMarker folderItemMrker = (DataMarker)((Object)elem.data[0]);
                    String file = (String)elem.data[1];
                    LocalDateTime localDateTime = (LocalDateTime)elem.data[2];
                    files.put(file, localDateTime);
                }
                break;
            }
            case ERROR: {
                message = String.format("[FileTransfer.folderGet] folderGet not successful on remote device.\nError Message: %s\nRemote Device Exception: %s\nRemote Device Stacktrace: %s", response.getErrorMessage(), response.getExceptionMessage(), response.getStackTrace());
                break;
            }
            case INVALID_RESPONSE: {
                message = String.format("[FileTransfer.folderGet] Invalid response from remote device.", new Object[0]);
                break;
            }
            case NO_RESPONSE: {
                message = String.format("[FileTransfer.folderGet] No response from remote device.\nMake sure remote device is connected and reload the application. ", new Object[0]);
                break;
            }
            case NOT_CONNECTED: {
                message = String.format("[FileTransfer.folderGet] Remote device is not connected!\nPlease connect to device first before invoking this action!", new Object[0]);
            }
        }
        System.out.println(message);
        return files;
    }

    public Map<String, Map<LocalDateTime, Object[]>> fileGet(String folderPath, String filePath) {
        HashMap<LocalDateTime, Object[]> detailsSet = new HashMap<LocalDateTime, Object[]>();
        HashMap<String, Map<LocalDateTime, Object[]>> files = new HashMap<String, Map<LocalDateTime, Object[]>>();
        ArrayList<Object> fileContent = new ArrayList<Object>();
        String fileName = "";
        int partialFileContent = 65536;
        int offset = 0;
        boolean moreFragments = true;
        do {
            BFileDataArgs fileDataArgs = new BFileDataArgs(folderPath, filePath, offset, partialFileContent);
            GetFileRequest request = GetFileRequest.make(this.ne2DeviceExt, fileDataArgs);
            GetFileResponse response = request.postRequest(this.ne2DeviceExt.getRemoteDevice());
            String message = "";
            switch (response.getResponseCode()) {
                case OK: {
                    FileData nanoData = response.getResponseData();
                    if (!(nanoData instanceof FileData)) break;
                    SerializableForm elem = nanoData.getSerializableForm();
                    DataMarker marker = elem.marker;
                    fileName = (String)elem.data[0];
                    Object fragment = ((Array)elem.data[1]).array()[0];
                    fileContent.add(fragment);
                    if (((byte[])fragment).length < 65536) {
                        LocalDateTime localDateTime = (LocalDateTime)elem.data[2];
                        detailsSet.put(localDateTime, fileContent.toArray());
                        files.put(fileName, detailsSet);
                        moreFragments = false;
                    }
                    offset += ((byte[])fragment).length;
                    break;
                }
                case ERROR: {
                    message = String.format("[FileTransfer.fileGet] fileGet not successful on remote device.\nError Message: %s\nRemote Device Exception: %s\nRemote Device Stacktrace: %s", response.getErrorMessage(), response.getExceptionMessage(), response.getStackTrace());
                    moreFragments = false;
                    break;
                }
                case INVALID_RESPONSE: {
                    message = String.format("[FileTransfer.fileGet] Invalid response from remote device.", new Object[0]);
                    moreFragments = false;
                    break;
                }
                case NO_RESPONSE: {
                    message = String.format("[FileTransfer.fileGet] No response from remote device.\nMake sure remote device is connected and reload the application. ", new Object[0]);
                    moreFragments = false;
                    break;
                }
                case NOT_CONNECTED: {
                    message = String.format("[FileTransfer.fileGet] Remote device is not connected!\nPlease connect to device first before invoking this action!", new Object[0]);
                    moreFragments = false;
                }
            }
        } while (moreFragments);
        return files;
    }

    public boolean filePut(String folderPath, String filePath, byte[] fileContent) {
        boolean ok = true;
        int offset = 0;
        int fragmentLength = Math.min(fileContent.length - offset, 65536);
        do {
            BFileDataArgs fileDataArgs = new BFileDataArgs(folderPath, filePath, offset, fragmentLength, fileContent);
            PutFileRequest request = PutFileRequest.make(this.ne2DeviceExt, fileDataArgs);
            PutFileResponse response = request.postRequest(this.ne2DeviceExt.getRemoteDevice());
            String message = "";
            switch (response.getResponseCode()) {
                case OK: {
                    break;
                }
                case ERROR: {
                    message = String.format("[FileTransfer.filePut] fileGet not successful on remote device.\nError Message: %s\nRemote Device Exception: %s\nRemote Device Stacktrace: %s", response.getErrorMessage(), response.getExceptionMessage(), response.getStackTrace());
                    ok = false;
                    break;
                }
                case INVALID_RESPONSE: {
                    message = String.format("[FileTransfer.filePut] Invalid response from remote device.", new Object[0]);
                    ok = false;
                    break;
                }
                case NO_RESPONSE: {
                    message = String.format("[FileTransfer.filePut] No response from remote device.\nMake sure remote device is connected and reload the application. ", new Object[0]);
                    ok = false;
                    break;
                }
                case NOT_CONNECTED: {
                    message = String.format("[FileTransfer.filePut] Remote device is not connected!\nPlease connect to device first before invoking this action!", new Object[0]);
                    ok = false;
                }
            }
            fragmentLength = Math.min(fileContent.length - (offset += fragmentLength), 65536);
        } while (ok && fragmentLength - 1 > 0);
        return ok;
    }

    public boolean fileDelete(String folderPath, String filePath) {
        boolean ok = true;
        BFileDataArgs fileDataArgs = new BFileDataArgs(folderPath, filePath);
        DeleteFileRequest request = DeleteFileRequest.make(this.ne2DeviceExt, fileDataArgs);
        DeleteFileResponse response = request.postRequest(this.ne2DeviceExt.getRemoteDevice());
        String message = "";
        switch (response.getResponseCode()) {
            case OK: {
                break;
            }
            case ERROR: {
                message = String.format("[FileTransfer.filePut] fileGet not successful on remote device.\nError Message: %s\nRemote Device Exception: %s\nRemote Device Stacktrace: %s", response.getErrorMessage(), response.getExceptionMessage(), response.getStackTrace());
                ok = false;
                break;
            }
            case INVALID_RESPONSE: {
                message = String.format("[FileTransfer.filePut] Invalid response from remote device.", new Object[0]);
                ok = false;
                break;
            }
            case NO_RESPONSE: {
                message = String.format("[FileTransfer.filePut] No response from remote device.\nMake sure remote device is connected and reload the application. ", new Object[0]);
                ok = false;
                break;
            }
            case NOT_CONNECTED: {
                message = String.format("[FileTransfer.filePut] Remote device is not connected!\nPlease connect to device first before invoking this action!", new Object[0]);
                ok = false;
            }
        }
        return ok;
    }

    byte[] getFileContent(String folderPath, String fileName) {
        HashMap details;
        Optional localDateTime;
        byte[] fileContent = new byte[]{};
        Map<String, Map<LocalDateTime, Object[]>> file = this.fileGet(folderPath, fileName);
        Optional name = file.keySet().stream().findFirst();
        if (name.isPresent() && (localDateTime = (details = (HashMap)file.get(name.get())).keySet().stream().findFirst()).isPresent()) {
            Object[] objects = (Object[])details.get(localDateTime.get());
            int length = 0;
            for (Object obj : objects) {
                length += ((byte[])obj).length;
            }
            fileContent = new byte[length];
            int index = 0;
            for (Object obj : objects) {
                System.arraycopy((byte[])obj, 0, fileContent, index, ((byte[])obj).length);
                index += ((byte[])obj).length;
            }
        }
        return fileContent;
    }
}

