/*
 * Decompiled with CFR 0.152.
 */
package com.miratech.nE2Link.utils;

import com.miratech.nE2Link.BLibrary;
import com.miratech.nE2Link.utils.javabeans.LibraryComp;
import java.util.ArrayList;
import java.util.List;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComponent;
import javax.baja.sys.BString;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public class BListOfLibraryFiles
extends BComponent {
    public static final Type TYPE = Sys.loadType(BListOfLibraryFiles.class);
    List<LibraryComp> libraryFiles = new ArrayList<LibraryComp>();

    public Type getType() {
        return TYPE;
    }

    public void addLibraryFile(BLibrary libraryFile) {
        boolean ok = false;
        for (LibraryComp libraryComp : this.libraryFiles) {
            if (!libraryComp.getNanoName().equals(libraryFile.getNanoName())) continue;
            libraryComp.addVersion(libraryFile.getVersion());
            ok = true;
            break;
        }
        if (!ok) {
            LibraryComp libraryComp = new LibraryComp(0, libraryFile.getNanoName(), libraryFile.getVersion());
            this.libraryFiles.add(libraryComp);
        }
    }

    public void removeLibraryFile(BLibrary libraryFile) {
        this.libraryFiles.remove((Object)libraryFile);
    }

    public List<LibraryComp> getLibraryFiles() {
        return this.libraryFiles;
    }

    public BString encodeToString() {
        StringBuilder sb = new StringBuilder("");
        for (LibraryComp libraryFile : this.getLibraryFiles()) {
            sb.append(libraryFile.getId()).append(";" + libraryFile.getNanoName());
            for (String v : libraryFile.getVersions()) {
                sb.append(";" + v);
            }
            sb.append("\n");
        }
        return sb.length() > 0 ? BString.make((String)sb.substring(0, sb.length() - 1)) : BString.make((String)sb.toString());
    }

    public static List<LibraryComp> decodeFromString(BString s) {
        ArrayList<LibraryComp> libraryFiles = new ArrayList<LibraryComp>();
        if (s.getString().length() > 0) {
            String[] libraries;
            for (String library : libraries = s.getString().split("\n")) {
                String[] items = library.split(";");
                String id = items[0];
                String libraryName = items[1];
                String libraryVersion = items[2];
                LibraryComp libraryComp = new LibraryComp(0, libraryName, libraryVersion);
                for (int i = 3; i < items.length; ++i) {
                    String otherVersion = items[i];
                    libraryComp.addVersion(otherVersion);
                }
                libraryFiles.add(libraryComp);
            }
        }
        return libraryFiles;
    }
}

