/*
 * Decompiled with CFR 0.152.
 */
package com.miratech.nE2Link.utils;

import com.miratech.ifnetclient.model.RemoteDevice;
import com.miratech.nE2Link.BNanoComponent;
import com.miratech.nE2Link.BNe2DeviceExt;
import com.miratech.nE2Link.actions.BSoftwareManagerArgs;
import com.miratech.nE2Link.notifications.BMessageNotification;
import com.miratech.nE2Link.notifications.BMessageTypeEnum;
import com.miratech.nE2Link.utils.BFileTransfer;
import com.miratech.serialization.DataMarker;
import com.miratech.serialization.SerializableForm;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.file.BFileSystem;
import javax.baja.file.BIFile;
import javax.baja.file.FilePath;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdQuery;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="iFnetPort", type="int", defaultValue="80", flags=1), @NiagaraProperty(name="ipAddress", type="String", defaultValue="\"192.168.1.123\"", flags=1), @NiagaraProperty(name="lastConnected", type="String", defaultValue="", flags=1), @NiagaraProperty(name="macAddress", type="String", defaultValue="", flags=1), @NiagaraProperty(name="maximumDataPoints", type="int", defaultValue="150", flags=1), @NiagaraProperty(name="deviceName", type="String", defaultValue="", flags=1), @NiagaraProperty(name="model", type="String", defaultValue="", flags=1), @NiagaraProperty(name="oSVersion", type="String", defaultValue="", flags=1), @NiagaraProperty(name="ping", type="String", defaultValue="", flags=1), @NiagaraProperty(name="serialNumber", type="double", defaultValue="0", facets={@Facet(name="BFacets.PRECISION", value="0")}, flags=1)})
@NiagaraActions(value={@NiagaraAction(name="upgradeAll", flags=4), @NiagaraAction(name="installFile", parameterType="BSoftwareManagerArgs", defaultValue="new BSoftwareManagerArgs()", flags=4), @NiagaraAction(name="uninstallFile", parameterType="BSoftwareManagerArgs", defaultValue="new BSoftwareManagerArgs()", flags=4), @NiagaraAction(name="restartDevice", flags=4)})
public class BSoftwareManager
extends BComponent {
    public static final Property iFnetPort = BSoftwareManager.newProperty((int)1, (int)80, null);
    public static final Property ipAddress = BSoftwareManager.newProperty((int)1, (String)"192.168.1.123", null);
    public static final Property lastConnected = BSoftwareManager.newProperty((int)1, (String)"", null);
    public static final Property macAddress = BSoftwareManager.newProperty((int)1, (String)"", null);
    public static final Property maximumDataPoints = BSoftwareManager.newProperty((int)1, (int)150, null);
    public static final Property deviceName = BSoftwareManager.newProperty((int)1, (String)"", null);
    public static final Property model = BSoftwareManager.newProperty((int)1, (String)"", null);
    public static final Property oSVersion = BSoftwareManager.newProperty((int)1, (String)"", null);
    public static final Property ping = BSoftwareManager.newProperty((int)1, (String)"", null);
    public static final Property serialNumber = BSoftwareManager.newProperty((int)1, (int)0, (BFacets)BFacets.make((String)"precision", (int)0));
    public static final Action upgradeAll = BSoftwareManager.newAction((int)4, null);
    public static final Action installFile = BSoftwareManager.newAction((int)4, (BValue)new BSoftwareManagerArgs(), null);
    public static final Action uninstallFile = BSoftwareManager.newAction((int)4, (BValue)new BSoftwareManagerArgs(), null);
    public static final Action restartDevice = BSoftwareManager.newAction((int)4, null);
    public static final Type TYPE = Sys.loadType(BSoftwareManager.class);
    protected static Logger LOGGER = Logger.getLogger(TYPE.getTypeSpec().getModuleName());
    private final String systemLibraries = "/system/libraries";

    public int getIFnetPort() {
        return this.getInt(iFnetPort);
    }

    public void setIFnetPort(int v) {
        this.setInt(iFnetPort, v, null);
    }

    public String getIpAddress() {
        return this.getString(ipAddress);
    }

    public void setIpAddress(String v) {
        this.setString(ipAddress, v, null);
    }

    public String getLastConnected() {
        return this.getString(lastConnected);
    }

    public void setLastConnected(String v) {
        this.setString(lastConnected, v, null);
    }

    public String getMacAddress() {
        return this.getString(macAddress);
    }

    public void setMacAddress(String v) {
        this.setString(macAddress, v, null);
    }

    public int getMaximumDataPoints() {
        return this.getInt(maximumDataPoints);
    }

    public void setMaximumDataPoints(int v) {
        this.setInt(maximumDataPoints, v, null);
    }

    public String getDeviceName() {
        return this.getString(deviceName);
    }

    public void setDeviceName(String v) {
        this.setString(deviceName, v, null);
    }

    public String getModel() {
        return this.getString(model);
    }

    public void setModel(String v) {
        this.setString(model, v, null);
    }

    public String getOSVersion() {
        return this.getString(oSVersion);
    }

    public void setOSVersion(String v) {
        this.setString(oSVersion, v, null);
    }

    public String getPing() {
        return this.getString(ping);
    }

    public void setPing(String v) {
        this.setString(ping, v, null);
    }

    public double getSerialNumber() {
        return this.getDouble(serialNumber);
    }

    public void setSerialNumber(double v) {
        this.setDouble(serialNumber, v, null);
    }

    public void upgradeAll() {
        this.invoke(upgradeAll, null, null);
    }

    public void installFile(BSoftwareManagerArgs parameter) {
        this.invoke(installFile, (BValue)parameter, null);
    }

    public void uninstallFile(BSoftwareManagerArgs parameter) {
        this.invoke(uninstallFile, (BValue)parameter, null);
    }

    public void restartDevice() {
        this.invoke(restartDevice, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void doUpgradeAll() {
    }

    public void doInstallFile(BSoftwareManagerArgs softwareManagerArgs) {
        BNe2DeviceExt ne2DeviceExt = (BNe2DeviceExt)this.getParent();
        RemoteDevice remoteDevice = ne2DeviceExt.getRemoteDevice();
        if (remoteDevice != null && remoteDevice.Remote.isConnected()) {
            boolean isOs = softwareManagerArgs.getLibraryName().contains("os-");
            try {
                BOrd originPath = isOs ? BNe2DeviceExt.OS_FILE_ORD.normalize() : BNe2DeviceExt.LIBRARIES_FILE_ORD.normalize();
                OrdQuery[] queries = BOrd.make((BOrd)originPath, (String)("file:" + softwareManagerArgs.getLibraryName())).normalize().parse();
                FilePath filePath = (FilePath)queries[queries.length - 1];
                BFileSystem fileSystem = BFileSystem.INSTANCE;
                BIFile file = fileSystem.findFile(filePath);
                if (file != null) {
                    BFileTransfer fileTransfer = new BFileTransfer((BNe2DeviceExt)this.getParent());
                    String fileName = isOs ? "update.bin" : file.getFileName().split("-")[0] + ".pe";
                    String systemUpdate = "/system/update";
                    fileTransfer.filePut(isOs ? systemUpdate : "/system/libraries", fileName, file.read());
                }
            }
            catch (Exception e) {
                LOGGER.severe("[doInstallFile] failed to install library " + softwareManagerArgs.getLibraryName());
            }
        } else {
            LOGGER.severe("Remote device is not connected! Please connect to device first before invoking this action!");
            BMessageNotification notification = BMessageNotification.make(BMessageTypeEnum.error, "Install File Error", "Remote device is not connected! Please connect to device first before invoking this action!");
            notification.raise((Context)softwareManagerArgs.getCallContext());
        }
    }

    public void doUninstallFile(BSoftwareManagerArgs softwareManagerArgs) {
        BNe2DeviceExt ne2DeviceExt = (BNe2DeviceExt)this.getParent();
        RemoteDevice remoteDevice = ne2DeviceExt.getRemoteDevice();
        if (remoteDevice != null && remoteDevice.Remote.isConnected()) {
            try {
                BFileTransfer fileTransfer = new BFileTransfer((BNe2DeviceExt)this.getParent());
                fileTransfer.fileDelete("/system/libraries", softwareManagerArgs.getLibraryName());
            }
            catch (Exception e) {
                LOGGER.severe("[doUninstallFile] failed to uninstall library " + softwareManagerArgs.getLibraryName());
            }
        } else {
            LOGGER.severe("Remote device is not connected! Please connect to device first before invoking this action!");
            BMessageNotification notification = BMessageNotification.make(BMessageTypeEnum.deviceDisconnected);
            notification.raise((Context)softwareManagerArgs.getCallContext());
        }
    }

    public void doRestartDevice(Context context) {
        BNe2DeviceExt ne2DeviceExt = (BNe2DeviceExt)this.getParent();
        RemoteDevice remoteDevice = ne2DeviceExt.getRemoteDevice();
        if (remoteDevice != null && remoteDevice.Remote.isConnected()) {
            BNanoComponent iFnetService = (BNanoComponent)ne2DeviceExt.doGetNanoComponentByName(BString.make((String)"iFnet"));
            Object[] writeData = new Object[]{(short)iFnetService.getGlobalIndex(), "RestartDevice", null};
            SerializableForm actionData = new SerializableForm(DataMarker.WriteData, writeData);
            ArrayList<SerializableForm> response = remoteDevice.Remote.Invoke(actionData);
            if (response != null) {
                for (SerializableForm responseElem : response) {
                    for (SerializableForm elem : responseElem.elements.toSerializableForms()) {
                        if (LOGGER.isLoggable(Level.INFO)) {
                            LOGGER.info(String.format("[doRestartDevice]: elem.marker: '%s'.\n", new Object[]{elem.marker}));
                        }
                        if (elem.marker != DataMarker.ErrorData) continue;
                        LOGGER.severe("restart device has failed.");
                    }
                }
            }
        } else {
            LOGGER.severe("Remote device is not connected! Please connect to device first before invoking this action!");
            BMessageNotification notification = BMessageNotification.make(BMessageTypeEnum.deviceDisconnected);
            notification.raise((Context)context.getFacets());
        }
    }

    public boolean isChildLegal(BComponent child) {
        return false;
    }
}

