/*
 * Decompiled with CFR 0.152.
 */
package com.miratech.nE2Link.utils;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.logging.Logger;
import javax.baja.file.BDirectory;
import javax.baja.file.BIFile;
import javax.baja.naming.BOrd;
import javax.baja.sys.BObject;
import javax.baja.sys.Sys;

public class FileUtil {
    public static final Logger LOGGER = Logger.getLogger(Sys.getModuleForClass(FileUtil.class).getModuleName());

    public static void copyOrdTargetToFile(BOrd sourceOrd, File targetDir, boolean copyChildren, boolean replaceExisting) {
        BIFile sourceFile;
        BObject source = sourceOrd.get((BObject)Sys.getStation());
        if (!(source instanceof BIFile)) {
            return;
        }
        if (targetDir.exists() && !targetDir.isDirectory()) {
            targetDir.delete();
        }
        if (!targetDir.exists()) {
            targetDir.mkdirs();
        }
        if ((sourceFile = (BIFile)source).isDirectory()) {
            File newTargetDir = new File(targetDir, sourceFile.getFileName());
            if (!newTargetDir.exists()) {
                newTargetDir.mkdir();
            }
            if (copyChildren) {
                BIFile[] sourceFiles;
                for (BIFile fileToCopy : sourceFiles = ((BDirectory)sourceFile).listFiles()) {
                    FileUtil.copyOrdTargetToFile(fileToCopy.getOrdInSpace(), newTargetDir, copyChildren, replaceExisting);
                }
            }
        } else {
            File newTargetFile = new File(targetDir, sourceFile.getFileName());
            if (newTargetFile.exists() && replaceExisting) {
                newTargetFile.delete();
            }
            if (!newTargetFile.exists()) {
                try (FileOutputStream targetFileStream = new FileOutputStream(newTargetFile);){
                    targetFileStream.write(sourceFile.read());
                }
                catch (IOException e) {
                    LOGGER.severe("Failed to create file '" + newTargetFile.getPath() + "'\n" + e.getMessage());
                }
            }
        }
    }
}

