/*
 * Decompiled with CFR 0.152.
 */
package com.miratech.serialization.internal;

import java.util.HashMap;
import javax.baja.nre.util.Array;

public final class DataType {
    public static final byte shortLength = -2;
    public static final byte unknownLength = -1;

    public static Type SerializableType(Array self) {
        try {
            if (self.ofClass().equals(Float.class)) {
                return Type.Float;
            }
            if (self.ofClass().equals(String.class)) {
                return Type.String;
            }
            if (self.ofClass().equals(Byte.class)) {
                return Type.Byte;
            }
            return Type.Object;
        }
        catch (Exception e) {
            return Type.Object;
        }
    }

    public static enum Type {
        Undefined(0),
        Boolean(17),
        UInt16(18),
        UInt32(19),
        Int16(20),
        Int32(21),
        String(22),
        Time(23),
        Float(24),
        ShortObject(25),
        Type(26),
        Void(30),
        Null(31),
        Object(32),
        Array(33),
        Byte(34),
        UInt64(36),
        Int64(37),
        Double(38),
        Form(44),
        Collection(45),
        NoOp(63),
        End(69),
        Marker(-86);

        public static final int SIZE = 8;
        private byte byteValue;
        private static HashMap<Byte, Type> mappings;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private static HashMap<Byte, Type> getMappings() {
            if (mappings != null) return mappings;
            Class<Type> clazz = Type.class;
            synchronized (Type.class) {
                if (mappings != null) return mappings;
                mappings = new HashMap();
                // ** MonitorExit[var0] (shouldn't be in output)
                return mappings;
            }
        }

        private Type(byte value) {
            this.byteValue = value;
            com.miratech.serialization.internal.DataType$Type.getMappings().put(value, this);
        }

        public byte getValue() {
            return this.byteValue;
        }

        public static Type forValue(byte value) {
            return com.miratech.serialization.internal.DataType$Type.getMappings().get(value);
        }
    }
}

