/*
 * Decompiled with CFR 0.152.
 */
package com.miratech.serialization.internal;

import com.miratech.serialization.DataMarker;
import com.miratech.serialization.SerializableCollection;
import com.miratech.serialization.SerializableForm;
import com.miratech.serialization.internal.DataType;
import com.miratech.serialization.internal.Deserializer;
import com.miratech.serialization.internal.TypeCoder;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.ByteOrder;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.List;
import javax.baja.nre.util.Array;
import javax.baja.nre.util.ByteBuffer;

public class Serializer {
    private final ByteBuffer stream;
    private final byte[] microBuffer = new byte[16];

    public Serializer(ByteBuffer stream) {
        this.stream = stream;
        this.stream.setBigEndian(false);
    }

    public final byte[] Serialize() throws IOException {
        byte[] result = new byte[this.stream.getLength()];
        if (null != this.stream) {
            this.stream.readFully(result);
        }
        return result;
    }

    public final void WriteArrayHeader(int length, DataType.Type objectsType) throws IOException {
        this.stream.writeByte((int)DataType.Type.Array.getValue());
        this.stream.writeByte((int)objectsType.getValue());
        this.stream.write(this.getBytes(length), 0, 4);
    }

    private int Prepare(int intValue) {
        this.microBuffer[0] = (byte)intValue;
        this.microBuffer[1] = (byte)(intValue >> 8);
        this.microBuffer[2] = (byte)(intValue >> 16);
        this.microBuffer[3] = (byte)(intValue >> 24);
        return 4;
    }

    private int Prepare(boolean boolValue) {
        this.microBuffer[0] = boolValue ? (byte)1 : 0;
        return 1;
    }

    private int Prepare(short shortValue) {
        this.microBuffer[0] = (byte)shortValue;
        this.microBuffer[1] = (byte)(shortValue >> 8);
        return 2;
    }

    private int Prepare(long longValue) {
        this.microBuffer[0] = (byte)longValue;
        this.microBuffer[1] = (byte)(longValue >> 8);
        this.microBuffer[2] = (byte)(longValue >> 16);
        this.microBuffer[3] = (byte)(longValue >> 24);
        this.microBuffer[4] = (byte)(longValue >> 32);
        this.microBuffer[5] = (byte)(longValue >> 40);
        this.microBuffer[6] = (byte)(longValue >> 48);
        this.microBuffer[7] = (byte)(longValue >> 56);
        return 8;
    }

    private void WriteSingleByte(DataType.Type what, byte value) {
        this.stream.writeByte((int)what.getValue());
        this.stream.writeByte((int)value);
    }

    private void WriteFromBuffer(DataType.Type what, int size) {
        this.stream.writeByte((int)what.getValue());
        this.stream.write(this.microBuffer, 0, size);
    }

    private void WriteString(String value) {
        byte[] data = value.getBytes();
        short size = (short)data.length;
        this.stream.writeByte((int)DataType.Type.String.getValue());
        this.stream.write(this.getBytes(size), 0, 2);
        this.stream.write(data, 0, data.length);
    }

    private void WriteMarker(DataMarker value) {
        this.stream.writeByte((int)DataType.Type.Marker.getValue());
        this.stream.writeByte((int)value.getValue());
    }

    private void WriteForm(SerializableForm serializableForm) throws Exception {
        this.stream.writeByte((int)DataType.Type.Form.getValue());
        this.WriteArrayHeader(3, DataType.Type.Object);
        this.WriteMarker(serializableForm.marker);
        this.Write(new Array(serializableForm.data), DataType.Type.Array);
        this.WriteCollection(serializableForm.elements);
    }

    private void WriteCollection(SerializableCollection serializableCollection) throws Exception {
        this.stream.writeByte((int)DataType.Type.Collection.getValue());
        List<SerializableForm> serializableForms = serializableCollection.toSerializableForms();
        this.WriteArrayHeader(this.CountNotNulls(serializableCollection), DataType.Type.Form);
        for (SerializableForm element : serializableForms) {
            if (element == null) continue;
            this.WriteForm(element);
        }
    }

    private int CountNotNulls(SerializableCollection serializableCollection) {
        int amount = 0;
        List<SerializableForm> serializableForms = serializableCollection.toSerializableForms();
        for (SerializableForm suspect : serializableForms) {
            if (suspect == null) continue;
            ++amount;
        }
        return amount;
    }

    private void WriteTime(LocalDateTime value) {
        this.stream.writeByte((int)DataType.Type.Time.getValue());
        this.stream.write(this.getBytes(value), 0, 8);
    }

    private void WriteType(Class value) {
        this.stream.writeByte((int)DataType.Type.Type.getValue());
        this.stream.writeByte((int)TypeCoder.GetCode(value).getValue());
    }

    private void WriteFloat(float value) throws IOException {
        this.stream.writeByte((int)DataType.Type.Float.getValue());
        this.stream.write(this.getBytes(value), 0, 4);
    }

    private void WriteDouble(double value) throws IOException {
        this.stream.writeByte((int)DataType.Type.Double.getValue());
        this.stream.write(this.getBytes(value), 0, 8);
    }

    public void Write(Object value) throws Exception {
        if (value == null) {
            this.WriteFromBuffer(DataType.Type.Null, 0);
        } else {
            String className = value.getClass().getTypeName();
            if (value instanceof Array) {
                this.Write((Array)value, DataType.SerializableType((Array)value));
            } else if (value instanceof SerializableForm) {
                this.WriteForm((SerializableForm)value);
            } else if (value instanceof SerializableCollection) {
                this.WriteCollection((SerializableCollection)value);
            } else if (value instanceof DataMarker) {
                this.WriteMarker((DataMarker)((Object)value));
            } else if (value instanceof LocalDateTime) {
                this.WriteTime((LocalDateTime)value);
            } else if (((Object)((Object)DataType.Type.Type)).getClass().getTypeName().equals(className)) {
                this.WriteType((Class)value);
            } else if (value instanceof String) {
                this.WriteString((String)value);
            } else if (value instanceof Float) {
                this.WriteFloat(((Float)value).floatValue());
            } else if (value instanceof Integer) {
                this.WriteFromBuffer(DataType.Type.Int32, this.Prepare((Integer)value));
            } else if (value instanceof Boolean) {
                this.WriteFromBuffer(DataType.Type.Boolean, this.Prepare((Boolean)value));
            } else if (value instanceof Byte) {
                this.WriteSingleByte(DataType.Type.Byte, (Byte)value);
            } else if (value instanceof Short) {
                this.WriteFromBuffer(DataType.Type.UInt16, this.Prepare((Short)value));
            } else if (value instanceof Long) {
                this.WriteFromBuffer(DataType.Type.UInt32, this.Prepare((int)((Long)value & 0xFFFFFFFFL)));
            } else if (value instanceof BigInteger) {
                long longVal = ((BigInteger)value).longValue();
                this.WriteFromBuffer(DataType.Type.UInt64, this.Prepare(longVal));
            } else if (value instanceof Double) {
                this.WriteDouble((Double)value);
            } else {
                throw new Exception("Unknown type of data: ({value.GetType()})" + value.getClass());
            }
        }
    }

    private void Write(Array value, DataType.Type ofType) throws Exception {
        this.WriteArrayHeader(value.size(), ofType);
        if (ofType == DataType.Type.Byte) {
            byte[] data = new byte[value.size()];
            for (int i = 0; i < value.size(); ++i) {
                try {
                    data[i] = (Byte)value.get(i);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    break;
                }
            }
            this.stream.write(data, 0, data.length);
        } else {
            for (Object item : value) {
                this.Write(item);
            }
        }
    }

    private byte[] getBytes(short value) {
        byte[] bytes = new byte[]{(byte)(value & 0xFF), (byte)((value & 0xFF00) >> 8)};
        return bytes;
    }

    private byte[] getBytes(int value) {
        byte[] bytes = new byte[]{(byte)(value & 0xFF), (byte)(value >> 8 & 0xFF), (byte)(value >> 16 & 0xFF), (byte)(value >>> 24)};
        return bytes;
    }

    private byte[] getBytes(long values) {
        byte[] buffer = new byte[8];
        for (int i = 0; i < 8; ++i) {
            int offset = 64 - (i + 1) * 8;
            buffer[i] = (byte)(values >> offset & 0xFFL);
        }
        return buffer;
    }

    private byte[] getBytes(float value) {
        return this.getBytes(Float.floatToIntBits(value));
    }

    private byte[] getBytes(double val) {
        long value = Double.doubleToLongBits(val);
        byte[] data = this.getBytes(value);
        double d = java.nio.ByteBuffer.wrap(data).order(ByteOrder.LITTLE_ENDIAN).getDouble();
        java.nio.ByteBuffer bb = java.nio.ByteBuffer.allocate(8);
        bb.putDouble(d);
        return bb.array();
    }

    private byte[] getBytes(LocalDateTime value) {
        long netTicks = Deserializer.netTicksFromUnixTime(value, ZoneId.of("UTC"));
        return this.getBytes(netTicks);
    }

    public void BeginSerialize() {
    }

    public void EndSerialize() {
    }

    public void Close() {
    }
}

