/*
 * Decompiled with CFR 0.152.
 */
package com.miratech.nE2Link.ui;

import com.miratech.nE2Link.BNanoConfig;
import com.miratech.nE2Link.BNanoConfigComms;
import com.miratech.nE2Link.BNe2DeviceExt;
import com.miratech.nE2Link.ui.BAbout;
import com.miratech.nE2Link.ui.BInfo;
import com.miratech.nE2Link.utils.BConnectionStatus;
import java.util.Arrays;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.ViewQuery;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;
import javax.baja.workbench.BWbShell;
import javax.baja.workbench.view.BWbComponentView;

@NiagaraType
public abstract class BSwitchableView
extends BWbComponentView {
    public static final Type TYPE = Sys.loadType(BSwitchableView.class);
    protected static final Lexicon LEX = Lexicon.make(BSwitchableView.class);

    public Type getType() {
        return TYPE;
    }

    public void doLoadValue(BObject value, Context context) throws Exception {
        super.doLoadValue(value, context);
        BNe2DeviceExt ne2DeviceExt = (BNe2DeviceExt)value;
        ne2DeviceExt.lease();
        BNanoConfig config = ne2DeviceExt.getConfig();
        config.lease();
        BNanoConfigComms commSettings = config.getCommunicationSettings();
        commSettings.lease();
        this.registerForComponentEvents((BComponent)commSettings);
    }

    public void handleComponentEvent(BComponentEvent event) {
        Type targetViewType = this.getTargetView(event);
        if (targetViewType != null) {
            this.changeActiveView(targetViewType);
        }
    }

    protected Type getTargetView(BComponentEvent event) {
        BComponent sourceComponent = event.getSourceComponent();
        Slot sourceSlot = event.getSlot();
        if (!sourceComponent.getType().equals(BNanoConfigComms.TYPE)) {
            return null;
        }
        if (event.getId() != 0 || !sourceSlot.asProperty().equals(BNanoConfigComms.status)) {
            return null;
        }
        BConnectionStatus connectionStatus = (BConnectionStatus)event.getValue();
        switch (connectionStatus.getOrdinal()) {
            case 0: 
            case 1: 
            case 3: {
                return BInfo.TYPE;
            }
            case 2: 
            case 4: {
                return BAbout.TYPE;
            }
        }
        return null;
    }

    private void changeActiveView(Type targetViewType) {
        if (targetViewType == null || !targetViewType.is(BWbComponentView.TYPE)) {
            return;
        }
        BWbShell wbShell = this.getWbShell();
        if (wbShell.getActiveView().getType().equals(targetViewType)) {
            return;
        }
        String newViewTypeInfo = targetViewType.getTypeInfo().toString();
        BOrd ord = wbShell.getActiveOrd();
        OrdQuery[] ordQueries = ord.parse();
        ViewQuery viewQuery = ordQueries.length > 0 && ordQueries[ordQueries.length - 1] instanceof ViewQuery ? (ViewQuery)ordQueries[ordQueries.length - 1] : null;
        ViewQuery newViewQuery = new ViewQuery(newViewTypeInfo);
        if (viewQuery != null) {
            ordQueries[ordQueries.length - 1] = newViewQuery;
        } else {
            ordQueries = Arrays.copyOf(ordQueries, ordQueries.length + 1);
            ordQueries[ordQueries.length - 1] = newViewQuery;
        }
        ord = BOrd.make((OrdQuery[])ordQueries);
        wbShell.hyperlink(ord);
    }

    public void deactivated() {
        super.deactivated();
        this.unregisterForAllComponentEvents();
    }
}

