/*
 * Decompiled with CFR 0.152.
 */
package com.miratech.nE2Link.ui.fieldEditors;

import com.miratech.nE2Link.security.BNanoPassword;
import com.miratech.nE2Link.security.BNanoPasswordStrength;
import com.miratech.nE2Link.security.BNanoUser;
import com.miratech.nE2Link.ui.fieldEditors.BNanoPasswordFE;
import com.tridium.ui.util.LabelUtil;
import com.tridium.workbench.fieldeditors.BStringFE;
import javax.baja.gx.BImage;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BLabel;
import javax.baja.ui.BNullWidget;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BAlign;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BPane;
import javax.baja.util.Lexicon;
import javax.baja.workbench.CannotSaveException;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;

@NiagaraType
@NiagaraAction(name="modified")
public class BChangeNanoPasswordFE
extends BWbFieldEditor {
    public static final Action modified = BChangeNanoPasswordFE.newAction((int)0, null);
    public static final Type TYPE = Sys.loadType(BChangeNanoPasswordFE.class);
    private BNanoPasswordStrength passwordStrength;
    private String actualCurrentPassword = null;
    private BStringFE userNameFE = new BStringFE();
    private BNanoPasswordFE newPasswordFE = new BNanoPasswordFE();
    private BNanoPasswordFE confirmNewPasswordFE = new BNanoPasswordFE();
    BLabel lblHeadline = new BLabel();
    BLabel lblMinLength = new BLabel();
    BLabel lblMinUpperCase = new BLabel();
    BLabel lblMinLowerCase = new BLabel();
    BLabel lblMinDigits = new BLabel();
    BLabel lblMinSpecialChars = new BLabel();
    BLabel lblValidChars = new BLabel();
    private BLabel newPasswordIndicator = new BLabel(IMAGE_ERROR);
    private BLabel confirmNewPasswordIndicator = new BLabel(IMAGE_ERROR);
    private static final BIcon ICON_OK = BIcon.std((String)"ok.png");
    private static final BIcon ICON_WARNING = BIcon.std((String)"warning.png");
    private static final BIcon ICON_ERROR = BIcon.std((String)"error.png");
    private static final BImage IMAGE_OK = BImage.make((BIcon)ICON_OK);
    private static final BImage IMAGE_WARNING = BImage.make((BIcon)ICON_WARNING);
    private static final BImage IMAGE_ERROR = BImage.make((BIcon)ICON_ERROR);
    private static final String BLANK_PASSWORD = "";
    private final Lexicon lex = Lexicon.make(BChangeNanoPasswordFE.class);

    public void modified() {
        this.invoke(modified, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BChangeNanoPasswordFE() {
        this(BNanoPasswordStrength.NANO_DEFAULT);
    }

    public BChangeNanoPasswordFE(BNanoPasswordStrength passwordStrength) {
        this.passwordStrength = passwordStrength;
        BGridPane masterPane = new BGridPane(1);
        BGridPane passwordPane = new BGridPane(3);
        this.userNameFE.setReadonly(true);
        LabelUtil.addLabelWidgetPair((BPane)passwordPane, (String)this.lex.getText("ChangeNanoPasswordFE.user.label"), (BWidget)this.userNameFE);
        passwordPane.add(null, (BValue)new BNullWidget());
        LabelUtil.addLabelWidgetPair((BPane)passwordPane, (String)this.lex.getText("ChangeNanoPasswordFE.new.label"), (BWidget)this.newPasswordFE);
        passwordPane.add(null, (BValue)this.newPasswordIndicator);
        LabelUtil.addLabelWidgetPair((BPane)passwordPane, (String)this.lex.getText("ChangeNanoPasswordFE.confirm.label"), (BWidget)this.confirmNewPasswordFE);
        passwordPane.add(null, (BValue)this.confirmNewPasswordIndicator);
        BGridPane checkResultsPane = new BGridPane(1);
        String lblText = this.lex.getText("ChangeNanoPasswordFE.checkResult.headline");
        this.lblHeadline.setText(lblText);
        checkResultsPane.add(null, (BValue)this.lblHeadline);
        if (passwordStrength.getMinUpperCase() > 0) {
            lblText = this.lex.getText("ChangeNanoPasswordFE.checkResult.minUpperCase", new Object[]{passwordStrength.getMinUpperCase()});
            this.lblMinUpperCase.setText(lblText);
            this.lblMinUpperCase.setImage(IMAGE_WARNING);
            this.lblMinUpperCase.setTextToIconAlign(BAlign.left);
            checkResultsPane.add(null, (BValue)this.lblMinUpperCase);
        }
        if (passwordStrength.getMinLowerCase() > 0) {
            lblText = this.lex.getText("ChangeNanoPasswordFE.checkResult.minLowerCase", new Object[]{passwordStrength.getMinLowerCase()});
            this.lblMinLowerCase.setText(lblText);
            this.lblMinLowerCase.setImage(IMAGE_WARNING);
            this.lblMinLowerCase.setTextToIconAlign(BAlign.left);
            checkResultsPane.add(null, (BValue)this.lblMinLowerCase);
        }
        if (passwordStrength.getMinDigits() > 0) {
            lblText = this.lex.getText("ChangeNanoPasswordFE.checkResult.minDigits", new Object[]{passwordStrength.getMinDigits()});
            this.lblMinDigits.setText(lblText);
            this.lblMinDigits.setImage(IMAGE_WARNING);
            this.lblMinDigits.setTextToIconAlign(BAlign.left);
            checkResultsPane.add(null, (BValue)this.lblMinDigits);
        }
        if (passwordStrength.getMinSpecialChars() > 0) {
            lblText = this.lex.getText("ChangeNanoPasswordFE.checkResult.minSpecialChars", new Object[]{passwordStrength.getMinSpecialChars()});
            this.lblMinSpecialChars.setText(lblText);
            this.lblMinSpecialChars.setImage(IMAGE_WARNING);
            this.lblMinSpecialChars.setTextToIconAlign(BAlign.left);
            checkResultsPane.add(null, (BValue)this.lblMinSpecialChars);
        }
        if (passwordStrength.getMinLength() > 0) {
            lblText = this.lex.getText("ChangeNanoPasswordFE.checkResult.minLength", new Object[]{passwordStrength.getMinLength()});
            this.lblMinLength.setText(lblText);
            this.lblMinLength.setImage(IMAGE_WARNING);
            this.lblMinLength.setTextToIconAlign(BAlign.left);
            checkResultsPane.add(null, (BValue)this.lblMinLength);
        }
        lblText = !passwordStrength.getSpacesAllowed() && passwordStrength.getAllowedSpecialChars().length == 0 ? this.lex.getText("ChangeNanoPasswordFE.checkResult.validCharsLettersDigits") : (!passwordStrength.getSpacesAllowed() && passwordStrength.getAllowedSpecialChars().length > 0 ? this.lex.getText("ChangeNanoPasswordFE.checkResult.validCharsLettersDigitsSpecialCharacters", new Object[]{String.valueOf(passwordStrength.getAllowedSpecialChars())}) : (passwordStrength.getSpacesAllowed() && passwordStrength.getAllowedSpecialChars().length > 0 ? this.lex.getText("ChangeNanoPasswordFE.checkResult.validCharsLettersDigitsSpacesSpecialCharacters", new Object[]{String.valueOf(passwordStrength.getAllowedSpecialChars())}) : this.lex.getText("ChangeNanoPasswordFE.checkResult.validCharsLettersDigitsSpaces", new Object[]{String.valueOf(passwordStrength.getAllowedSpecialChars())})));
        this.lblValidChars.setText(lblText);
        this.lblValidChars.setImage(IMAGE_WARNING);
        this.lblValidChars.setTextToIconAlign(BAlign.left);
        checkResultsPane.add(null, (BValue)this.lblValidChars);
        masterPane.add(null, (BValue)passwordPane);
        masterPane.add(null, (BValue)checkResultsPane);
        this.linkTo((BComponent)this.newPasswordFE, (Slot)BNanoPasswordFE.modified, (Slot)modified);
        this.linkTo((BComponent)this.confirmNewPasswordFE, (Slot)BNanoPasswordFE.modified, (Slot)modified);
        this.setContent((BWidget)masterPane);
    }

    public void doModified() {
        this.setModified();
        try {
            BNanoPassword savedNewPassword = (BNanoPassword)this.newPasswordFE.saveValue();
            String newPassword = savedNewPassword != null ? savedNewPassword.getDecryptedPassword() : BLANK_PASSWORD;
            BNanoPassword savedConfirmNewPassword = (BNanoPassword)this.confirmNewPasswordFE.saveValue();
            String confirmNewPassword = savedConfirmNewPassword != null ? savedConfirmNewPassword.getDecryptedPassword() : BLANK_PASSWORD;
            this.checkPassword(newPassword, confirmNewPassword);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private boolean checkPassword(String newPassword, String confirmNewPassword) {
        try {
            BNanoPasswordStrength.PasswordCheckResults checkResults;
            if (newPassword == null) {
                newPassword = BLANK_PASSWORD;
            }
            if (confirmNewPassword == null) {
                confirmNewPassword = BLANK_PASSWORD;
            }
            this.lblValidChars.setImage((checkResults = this.passwordStrength.checkPassword(newPassword)).allCharactersValid() ? IMAGE_OK : IMAGE_WARNING);
            this.lblMinLength.setImage(checkResults.isMinLengthOK() ? IMAGE_OK : IMAGE_WARNING);
            this.lblMinLowerCase.setImage(checkResults.isMinLowerCaseOK() ? IMAGE_OK : IMAGE_WARNING);
            this.lblMinUpperCase.setImage(checkResults.isMinUpperCaseOK() ? IMAGE_OK : IMAGE_WARNING);
            this.lblMinDigits.setImage(checkResults.isMinDigitsOK() ? IMAGE_OK : IMAGE_WARNING);
            this.lblMinSpecialChars.setImage(checkResults.isMinSpecialCharsOK() ? IMAGE_OK : IMAGE_WARNING);
            this.newPasswordIndicator.setImage(checkResults.isAllOk() ? IMAGE_OK : IMAGE_ERROR);
            boolean result = checkResults.isAllOk() && newPassword.equals(confirmNewPassword);
            this.confirmNewPasswordIndicator.setImage(result ? IMAGE_OK : IMAGE_ERROR);
            return result;
        }
        catch (Exception ignore) {
            return false;
        }
    }

    protected BObject doSaveValue(BObject value, Context cx) throws CannotSaveException {
        BNanoPasswordStrength.PasswordCheckResults checkResults = null;
        boolean allOkAndConfirmed = false;
        boolean confirmed = false;
        try {
            BNanoUser user = (BNanoUser)value.as(BNanoUser.class);
            BNanoPassword password = (BNanoPassword)this.newPasswordFE.saveValue(cx);
            String decryptedPassword = password != null ? password.getDecryptedPassword() : BLANK_PASSWORD;
            BNanoPassword confirmedPassword = (BNanoPassword)this.confirmNewPasswordFE.saveValue(cx);
            String decryptedConfirmedPassword = confirmedPassword != null ? confirmedPassword.getDecryptedPassword() : BLANK_PASSWORD;
            checkResults = this.passwordStrength.checkPassword(decryptedPassword);
            confirmed = BNanoPassword.equals((BNanoPassword)password, (BNanoPassword)confirmedPassword);
            allOkAndConfirmed = checkResults.isAllOk() & confirmed;
            if (allOkAndConfirmed) {
                user.setPassword(password);
                return user;
            }
            throw new CannotSaveException();
        }
        catch (Exception e) {
            if (checkResults != null) {
                StringBuilder sb = new StringBuilder("\n" + this.getLexicon().getText("ChangeNanoPasswordFE.save.checkFailedHeadline"));
                if (!checkResults.isMinLowerCaseOK()) {
                    sb.append("\n").append(this.lex.getText("ChangeNanoPasswordFE.checkResult.minLowerCase", new Object[]{this.passwordStrength.getMinLowerCase()}));
                }
                if (!checkResults.isMinUpperCaseOK()) {
                    sb.append("\n").append(this.lex.getText("ChangeNanoPasswordFE.checkResult.minUpperCase", new Object[]{this.passwordStrength.getMinUpperCase()}));
                }
                if (!checkResults.isMinDigitsOK()) {
                    sb.append("\n").append(this.lex.getText("ChangeNanoPasswordFE.checkResult.minDigits", new Object[]{this.passwordStrength.getMinDigits()}));
                }
                if (!checkResults.isMinSpecialCharsOK()) {
                    sb.append("\n").append(this.lex.getText("ChangeNanoPasswordFE.checkResult.minSpecialChars", new Object[]{this.passwordStrength.getMinSpecialChars()}));
                }
                if (!checkResults.isMinLengthOK()) {
                    sb.append("\n").append(this.lex.getText("ChangeNanoPasswordFE.checkResult.minLength", new Object[]{this.passwordStrength.getMinLength()}));
                }
                if (!checkResults.allCharactersValid()) {
                    if (!this.passwordStrength.getSpacesAllowed() && this.passwordStrength.getAllowedSpecialChars().length == 0) {
                        sb.append("\n").append(this.lex.getText("ChangeNanoPasswordFE.checkResult.validCharsLettersDigits"));
                    } else if (!this.passwordStrength.getSpacesAllowed() && this.passwordStrength.getAllowedSpecialChars().length > 0) {
                        sb.append("\n").append(this.lex.getText("ChangeNanoPasswordFE.checkResult.validCharsLettersDigitsSpecialCharacters", new Object[]{String.valueOf(this.passwordStrength.getAllowedSpecialChars())}));
                    } else if (this.passwordStrength.getSpacesAllowed() && this.passwordStrength.getAllowedSpecialChars().length > 0) {
                        sb.append("\n").append(this.lex.getText("ChangeNanoPasswordFE.checkResult.validCharsLettersDigitsSpacesSpecialCharacters", new Object[]{String.valueOf(this.passwordStrength.getAllowedSpecialChars())}));
                    } else {
                        sb.append("\n").append(this.lex.getText("ChangeNanoPasswordFE.checkResult.validCharsLettersDigitsSpaces", new Object[]{String.valueOf(this.passwordStrength.getAllowedSpecialChars())}));
                    }
                }
                try {
                    if (!confirmed) {
                        sb.append("\n").append(this.lex.getText("ChangeNanoPasswordFE.checkResult.unequalPasswords"));
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw new CannotSaveException(this.lex.getText("ChangeNanoPasswordFE.save.failed", new Object[]{sb.toString()}));
            }
            throw new CannotSaveException(this.lex.getText("ChangeNanoPasswordFE.save.failed", new Object[]{e.getMessage()}));
        }
    }

    protected void doLoadValue(BObject value, Context context) throws Exception {
        if (!(value instanceof BNanoUser)) {
            throw new LocalizableRuntimeException(TYPE.getModule().getModuleName(), "ChangeNanoPasswordFE.load.failed", new Object[]{BNanoPassword.TYPE.getTypeSpec().getTypeName(), this.asObject().getType().getTypeInfo().getTypeName()});
        }
        BNanoUser user = (BNanoUser)value;
        this.userNameFE.loadValue((BObject)BString.make((String)user.getNanoName()), context);
        this.newPasswordFE.loadValue((BObject)user.getPassword());
        this.confirmNewPasswordFE.loadValue((BObject)user.getPassword());
        BNanoPassword nanoPassword = user.getPassword();
        String password = nanoPassword != null ? nanoPassword.getDecryptedPassword() : BLANK_PASSWORD;
    }
}

