/*
 * Decompiled with CFR 0.152.
 */
package com.miratech.nE2Link.ui.fieldEditors;

import com.miratech.nE2Link.BNanoBaseComponent;
import com.miratech.nE2Link.BNe2DeviceExt;
import com.miratech.nE2Link.actions.BNanoPropertyChangedArg;
import com.miratech.nE2Link.choice.BDynamicChoice;
import com.miratech.nE2Link.choice.BDynamicChoiceRange;
import com.miratech.nE2Link.parser.binary.SlotSchema;
import com.tridium.workbench.propsheet.BPropertyEntry;
import com.tridium.workbench.util.FloatingPointHelper;
import com.tridium.workbench.util.WbUtil;
import javax.baja.gx.BBrush;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDouble;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BTextDropDown;
import javax.baja.ui.BWidget;
import javax.baja.ui.text.Segment;
import javax.baja.ui.text.TextRenderer;
import javax.baja.util.Lexicon;
import javax.baja.workbench.CannotSaveException;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;

@NiagaraType(agent={@AgentOn(types={"nE2Link:DynamicChoice"})})
public class BDynamicChoiceFE
extends BWbFieldEditor {
    public static final Type TYPE = Sys.loadType(BDynamicChoiceFE.class);
    protected static Lexicon LEX = Lexicon.make(BDynamicChoiceFE.class);
    protected static String LEX_KEY_CANNOT_SAVE_NO_PARENT = "DynamicChoiceFE.cannotSaveNoParent";
    protected static String LEX_KEY_CANNOT_SAVE_NO_SLOT = "DynamicChoiceFE.cannotSaveNoSlot";
    protected static String LEX_KEY_CANNOT_SAVE_INVALID_VALUE = "DynamicChoiceFE.cannotSaveInvalidValue";
    private BTextDropDown comboBox = new BTextDropDown("", 15, false);
    private BDynamicChoice val;
    private BDynamicChoiceRange range;
    BBrush fg = BBrush.NULL;
    BBrush bg = BBrush.NULL;

    public Type getType() {
        return TYPE;
    }

    public BDynamicChoiceFE() {
        this.comboBox.getEditor().setRenderer((TextRenderer)new Renderer());
        this.setContent((BWidget)this.comboBox);
        this.linkTo("lk0", (BComponent)this.comboBox, (Slot)BTextDropDown.valueModified, (Slot)setModified);
        this.linkTo("lk1", (BComponent)this.comboBox, (Slot)BTextDropDown.actionPerformed, (Slot)actionPerformed);
    }

    public BTextDropDown getFEWidget() {
        return this.comboBox;
    }

    protected void doSetReadonly(boolean readonly) {
        this.comboBox.getEditor().setEditable(false);
        this.comboBox.setDropDownEnabled(!readonly);
    }

    protected void doLoadValue(BObject raw, Context cx) throws Exception {
        this.val = (BDynamicChoice)raw;
        this.range = this.val.getRange();
        int maxLen = 7;
        this.comboBox.getList().removeAllItems();
        BSimple[] keys = this.range.getKeys();
        for (int i = 0; i < keys.length; ++i) {
            BSimple key = keys[i];
            String displayTag = this.range.getDisplayTag(key, cx);
            this.comboBox.getList().addItem((Object)displayTag);
            maxLen = Math.max(maxLen, displayTag.length());
        }
        this.comboBox.getEditor().setVisibleColumns(maxLen);
        this.comboBox.setText(this.range.getDisplayTag(this.val.getKey(), cx));
        if (this.comboBox.getList().getItemCount() == 0) {
            this.comboBox.setDropDownEnabled(false);
            this.comboBox.getEditor().setEditable(true);
        }
    }

    protected BObject doSaveValue(BObject raw, Context cx) throws Exception {
        BDynamicChoice newValue;
        Context callContext = this.getCurrentContext();
        BDynamicChoice oldValue = (BDynamicChoice)raw;
        try {
            BSimple key = this.comboBoxEntryToKey(callContext);
            newValue = BDynamicChoice.make((Object)key, (BDynamicChoiceRange)this.range);
        }
        catch (CannotSaveException e) {
            throw e;
        }
        catch (Exception e) {
            throw new LocalizableRuntimeException(BDynamicChoiceFE.LEX.module.getModuleName(), LEX_KEY_CANNOT_SAVE_INVALID_VALUE, (Throwable)e);
        }
        if (!newValue.equals((Object)raw) && this.getParent() instanceof BPropertyEntry) {
            Integer slotId;
            Property changedProperty;
            boolean isProxyComponent;
            BComponent parent = this.getValueParentComponent(raw);
            if (!(parent instanceof BNanoBaseComponent)) {
                throw new LocalizableRuntimeException(BDynamicChoiceFE.LEX.module.getModuleName(), LEX_KEY_CANNOT_SAVE_NO_PARENT);
            }
            BNanoBaseComponent sourceComponent = (BNanoBaseComponent)parent;
            boolean bl = isProxyComponent = sourceComponent.getComponentSpace() != null && sourceComponent.getComponentSpace().isProxyComponentSpace();
            if (isProxyComponent) {
                sourceComponent.lease(1);
            }
            if ((changedProperty = sourceComponent.getNanoSlot(slotId = BNanoBaseComponent.getNanoSlotId((BFacets)callContext.getFacets()))) == null) {
                throw new LocalizableRuntimeException(BDynamicChoiceFE.LEX.module.getModuleName(), LEX_KEY_CANNOT_SAVE_NO_SLOT, new Object[]{slotId});
            }
            BNe2DeviceExt ne2DeviceExt = sourceComponent.getNe2DeviceExt();
            ne2DeviceExt.handleNanoPropertyValueChange(new BNanoPropertyChangedArg(sourceComponent, changedProperty, (BValue)oldValue, (BValue)newValue, this.getCurrentContext()));
        }
        return newValue;
    }

    public BComponent getValueParentComponent(BObject currentValue) {
        BComplex parent;
        BComplex bComplex = parent = currentValue instanceof BComplex ? ((BComplex)currentValue).getParent() : null;
        if (parent != null) {
            return parent.asComponent();
        }
        return (BNanoBaseComponent)WbUtil.findAncenstorViaWidgetTree((BWidget)this, (Type)BNanoBaseComponent.TYPE, (boolean)true);
    }

    BSimple comboBoxEntryToKey(Property targetProperty, Context cx) {
        String selectedEntry = this.comboBox.getText();
        BSimple[] keys = this.range.getKeys();
        for (int i = 0; i < keys.length; ++i) {
            BSimple key = keys[i];
            String displayTag = this.range.getDisplayTag(key, cx);
            if (!displayTag.equals(selectedEntry)) continue;
            return key;
        }
        String nanoTargetValueType = SlotSchema.getNanoValueType((Slot)targetProperty);
        if (SlotSchema.isNiagaraNumeric((Slot)targetProperty)) {
            return BDouble.make((String)selectedEntry);
        }
        if (SlotSchema.isNiagaraBoolean((Slot)targetProperty)) {
            return BBoolean.make((String)selectedEntry);
        }
        if (SlotSchema.isNiagaraString((Slot)targetProperty)) {
            return BString.make((String)selectedEntry);
        }
        throw new IllegalArgumentException(String.format("Cannot convert %s to %s", selectedEntry, nanoTargetValueType));
    }

    BSimple comboBoxEntryToKey(Context cx) throws CannotSaveException {
        String selectedEntry = this.comboBox.getText();
        BSimple[] keys = this.range.getKeys();
        for (int i = 0; i < keys.length; ++i) {
            BSimple key = keys[i];
            String displayTag = this.range.getDisplayTag(key, cx);
            if (!displayTag.equals(selectedEntry)) continue;
            return key;
        }
        if (this.range.getDisplayNameForInvalidKey().equals(selectedEntry)) {
            return null;
        }
        BFacets targetSlotFacets = cx.getFacets();
        String targetValueType = SlotSchema.getNanoValueType((BFacets)targetSlotFacets);
        if (SlotSchema.isNiagaraNumeric((String)targetValueType, (BFacets)targetSlotFacets)) {
            FloatingPointHelper fpe = FloatingPointHelper.makeDouble((Context)cx);
            return BDouble.make((double)fpe.parseAndValidate(selectedEntry));
        }
        if (SlotSchema.isNiagaraBoolean((String)targetValueType)) {
            return BBoolean.make((String)selectedEntry);
        }
        if (SlotSchema.isNiagaraString((String)targetValueType)) {
            return BString.make((String)selectedEntry);
        }
        throw new IllegalArgumentException(String.format("Cannot convert %s to %s", selectedEntry, targetValueType));
    }

    public Object fw(int x, Object a, Object b, Object c, Object d) {
        switch (x) {
            case 306: {
                this.fg = (BBrush)a;
                this.bg = (BBrush)b;
                this.repaint();
                return null;
            }
        }
        return super.fw(x, a, b, c, d);
    }

    class Renderer
    extends TextRenderer {
        Renderer() {
        }

        public BBrush getBackground() {
            if (BDynamicChoiceFE.this.bg.isNull()) {
                return super.getBackground();
            }
            return BDynamicChoiceFE.this.bg;
        }

        public BBrush getForeground(Segment seg) {
            if (BDynamicChoiceFE.this.fg.isNull()) {
                return super.getForeground(seg);
            }
            return BDynamicChoiceFE.this.fg;
        }
    }
}

