/*
 * Decompiled with CFR 0.152.
 */
package com.miratech.nE2Link.ui.fieldEditors;

import com.miratech.nE2Link.BNanoBaseComponent;
import com.miratech.nE2Link.BNe2DeviceExt;
import com.miratech.nE2Link.actions.BDynamicChoiceRangeChangedArg;
import com.miratech.nE2Link.choice.BDynamicChoice;
import com.miratech.nE2Link.choice.BDynamicChoiceRange;
import com.miratech.nE2Link.parser.binary.SlotSchema;
import com.tridium.json.JSONArray;
import com.tridium.json.JSONException;
import com.tridium.json.JSONObject;
import com.tridium.json.JSONTokener;
import com.tridium.workbench.util.WbUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.file.types.text.BJsonFile;
import javax.baja.gx.BBrush;
import javax.baja.gx.BColor;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.naming.UnresolvedException;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.ModuleNotFoundException;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BSeparator;
import javax.baja.ui.BTextDropDown;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BOrientation;
import javax.baja.ui.event.BWindowEvent;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.table.BTable;
import javax.baja.ui.table.TableCellRenderer;
import javax.baja.ui.table.TableModel;
import javax.baja.util.Lexicon;

@NiagaraType
@NiagaraActions(value={@NiagaraAction(name="templateChanged", flags=4), @NiagaraAction(name="selectionChanged", flags=4), @NiagaraAction(name="okPressed", flags=4), @NiagaraAction(name="cancelPressed", flags=4), @NiagaraAction(name="addPressed", flags=4), @NiagaraAction(name="modifyPressed", flags=4), @NiagaraAction(name="removePressed", flags=4), @NiagaraAction(name="entryModified", flags=4), @NiagaraAction(name="entryEditConfirmed", flags=4), @NiagaraAction(name="entryEditCancelled", flags=4)})
public class BDynamicChoiceRangeDialog
extends BDialog {
    public static final Action templateChanged = BDynamicChoiceRangeDialog.newAction((int)4, null);
    public static final Action selectionChanged = BDynamicChoiceRangeDialog.newAction((int)4, null);
    public static final Action okPressed = BDynamicChoiceRangeDialog.newAction((int)4, null);
    public static final Action cancelPressed = BDynamicChoiceRangeDialog.newAction((int)4, null);
    public static final Action addPressed = BDynamicChoiceRangeDialog.newAction((int)4, null);
    public static final Action modifyPressed = BDynamicChoiceRangeDialog.newAction((int)4, null);
    public static final Action removePressed = BDynamicChoiceRangeDialog.newAction((int)4, null);
    public static final Action entryModified = BDynamicChoiceRangeDialog.newAction((int)4, null);
    public static final Action entryEditConfirmed = BDynamicChoiceRangeDialog.newAction((int)4, null);
    public static final Action entryEditCancelled = BDynamicChoiceRangeDialog.newAction((int)4, null);
    public static final Type TYPE = Sys.loadType(BDynamicChoiceRangeDialog.class);
    protected static final String LEX_KEY_BASE = "DynamicChoiceRangeDialog.";
    protected static final String LEX_KEY_OK = "DynamicChoiceRangeDialog.ok";
    protected static final String LEX_KEY_CANCEL = "DynamicChoiceRangeDialog.cancel";
    protected static final String LEX_KEY_ADD = "DynamicChoiceRangeDialog.add";
    protected static final String LEX_KEY_MODIFY = "DynamicChoiceRangeDialog.modify";
    protected static final String LEX_KEY_REMOVE = "DynamicChoiceRangeDialog.remove";
    protected static final String LEX_KEY_DIALOG_TITLE = "DynamicChoiceRangeDialog.title";
    protected static final String LEX_KEY_DISPLAY_NAME_LABEL = "DynamicChoiceRangeDialog.displayNameLabel";
    protected static final String LEX_KEY_LEXICON_LABEL = "DynamicChoiceRangeDialog.lexiconLabel";
    protected static final String LEX_KEY_TEMPLATES_LABEL = "DynamicChoiceRangeDialog.templatesLabel";
    protected static final String LEX_KEY_TABLE_COL_KEY = "DynamicChoiceRangeDialog.tableColKey";
    protected static final String LEX_KEY_TABLE_COL_TAG = "DynamicChoiceRangeDialog.tableColTag";
    protected static final String LEX_KEY_TABLE_COL_DISPLAY_NAME = "DynamicChoiceRangeDialog.tableColDisplayName";
    protected static final int SPACE = 4;
    static Logger LOGGER = Logger.getLogger(TYPE.getModule().getModuleName());
    BDynamicChoiceRange orig;
    BDynamicChoiceRange pending;
    BDynamicChoiceRangeChangedArg result;
    BNanoBaseComponent valueParent;
    boolean enabled;
    Context callContext;
    boolean isBooleanData;
    boolean isMultistateData;
    int ERR = -1;
    ArrayList<Entry> entries = new ArrayList();
    Lexicon lex = this.getLexicon();
    BButton btnOk = new BButton(this.lex.getText("DynamicChoiceRangeDialog.ok"));
    BButton btnCancel = new BButton(this.lex.getText("DynamicChoiceRangeDialog.cancel"));
    BButton btnAdd = new BButton(this.lex.getText("DynamicChoiceRangeDialog.add"));
    BButton btnModify = new BButton(this.lex.getText("DynamicChoiceRangeDialog.modify"));
    BButton btnRemove = new BButton(this.lex.getText("DynamicChoiceRangeDialog.remove"));
    BGridPane gridOptions = new BGridPane(2);
    BTextField tboxInvalidDisplayName = new BTextField("", 20);
    BTextField tboxLexicon = new BTextField("", 20);
    BSeparator sep1 = new BSeparator(BOrientation.horizontal);
    BSeparator sep2 = new BSeparator(BOrientation.horizontal);
    BTextField tboxKey = new BTextField("", 5);
    BTextField tboxDisplayName = new BTextField("", 20);
    BLabel lblTemplates = new BLabel(this.getLexicon().getText("DynamicChoiceRangeDialog.templatesLabel"));
    BTextDropDown cboxTemplates = new BTextDropDown("", 15, true);
    BTable table;
    LinkedHashMap<String, ArrayList<String>> binaryTemplates;
    LinkedHashMap<String, ArrayList<String>> multistateTemplates;

    public void templateChanged() {
        this.invoke(templateChanged, null, null);
    }

    public void selectionChanged() {
        this.invoke(selectionChanged, null, null);
    }

    public void okPressed() {
        this.invoke(okPressed, null, null);
    }

    public void cancelPressed() {
        this.invoke(cancelPressed, null, null);
    }

    public void addPressed() {
        this.invoke(addPressed, null, null);
    }

    public void modifyPressed() {
        this.invoke(modifyPressed, null, null);
    }

    public void removePressed() {
        this.invoke(removePressed, null, null);
    }

    public void entryModified() {
        this.invoke(entryModified, null, null);
    }

    public void entryEditConfirmed() {
        this.invoke(entryEditConfirmed, null, null);
    }

    public void entryEditCancelled() {
        this.invoke(entryEditCancelled, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public static BDynamicChoiceRangeChangedArg open(BWidget owner, BDynamicChoiceRange value, boolean enabled, Context cx) {
        BDynamicChoiceRangeDialog dialog = new BDynamicChoiceRangeDialog(owner, value, enabled, cx);
        dialog.setBoundsCenteredOnOwner();
        dialog.open();
        return dialog.result;
    }

    private BDynamicChoiceRangeDialog(BWidget owner, BDynamicChoiceRange value, boolean enabled, Context cx) {
        super(owner, "", true);
        this.orig = value;
        this.callContext = cx;
        this.setTitle(this.getLexicon().getText(LEX_KEY_DIALOG_TITLE));
        this.initTemplatesDropdown();
        boolean tableInitSuccess = this.initTable();
        this.enabled = enabled && !this.orig.isReadOnly() && tableInitSuccess;
        this.cboxTemplates.setText("");
        this.cboxTemplates.setEnabled(this.cboxTemplates.getList().getItemCount() > 0 && this.enabled);
        this.cboxTemplates.getEditor().setEditable(false);
        this.gridOptions.add(null, (BValue)new BLabel(this.getLexicon().getText(LEX_KEY_DISPLAY_NAME_LABEL)));
        this.gridOptions.add(null, (BValue)this.tboxInvalidDisplayName);
        this.tboxInvalidDisplayName.setText(this.orig.getDisplayNameForInvalidKey());
        this.gridOptions.add(null, (BValue)new BLabel(this.getLexicon().getText(LEX_KEY_LEXICON_LABEL)));
        this.gridOptions.add(null, (BValue)this.tboxLexicon);
        this.tboxLexicon.setText(this.orig.getLexiconModuleName().equals("nE2Link") ? "" : this.orig.getLexiconModuleName());
        this.btnAdd.setEnabled(((Model)this.table.getModel()).allowInsertAfter() && enabled);
        this.btnModify.setEnabled(false);
        this.btnRemove.setEnabled(false);
        this.tboxKey.setEnabled(false);
        this.tboxDisplayName.setEnabled(false);
        this.tboxDisplayName.setConsumeActionKeyEvent(true);
        this.tboxLexicon.setEnabled(this.enabled);
        this.tboxInvalidDisplayName.setEnabled(this.enabled);
        this.btnOk.setEnabled(enabled);
        this.add("templatesLabel", (BValue)this.lblTemplates);
        this.add("templatesDropdown", (BValue)this.cboxTemplates);
        this.add("table", (BValue)this.table);
        this.add("key", (BValue)this.tboxKey);
        this.add("displayName", (BValue)this.tboxDisplayName);
        this.add("add", (BValue)this.btnAdd);
        this.add("modify", (BValue)this.btnModify);
        this.add("remove", (BValue)this.btnRemove);
        this.add("sep1", (BValue)this.sep1);
        this.add("options", (BValue)this.gridOptions);
        this.add("sep2", (BValue)this.sep2);
        this.add("ok", (BValue)this.btnOk);
        this.add("cancel", (BValue)this.btnCancel);
        this.linkTo("lkTemplateModified", (BComponent)this.cboxTemplates, (Slot)BTextDropDown.valueModified, (Slot)templateChanged);
        this.linkTo("lkTable", (BComponent)this.table, (Slot)BTable.selectionModified, (Slot)selectionChanged);
        this.linkTo("lkAdd", (BComponent)this.btnAdd, (Slot)BButton.actionPerformed, (Slot)addPressed);
        this.linkTo("lkModify", (BComponent)this.btnModify, (Slot)BButton.actionPerformed, (Slot)modifyPressed);
        this.linkTo("lkRemove", (BComponent)this.btnRemove, (Slot)BButton.actionPerformed, (Slot)removePressed);
        this.linkTo("lkOk", (BComponent)this.btnOk, (Slot)BButton.actionPerformed, (Slot)okPressed);
        this.linkTo("lkCancel", (BComponent)this.btnCancel, (Slot)BButton.actionPerformed, (Slot)cancelPressed);
        this.linkTo("lkEntryModified", (BComponent)this.tboxDisplayName, (Slot)BTextField.textModified, (Slot)entryModified);
        this.linkTo("lkEntryEditConfirmed", (BComponent)this.tboxDisplayName, (Slot)BTextField.actionPerformed, (Slot)entryEditConfirmed);
        this.linkTo("lkEntryEditCancelled", (BComponent)this.tboxDisplayName, (Slot)BTextField.cancelled, (Slot)entryEditCancelled);
    }

    private boolean initTable() {
        boolean success = true;
        for (BSimple key : this.orig.getKeys()) {
            try {
                String tag = this.orig.getTag(key);
                String displayName = this.orig.getDisplayTag(key, this.callContext);
                Number numKey = BDynamicChoice.keyToNumber((BSimple)key);
                this.entries.add(new Entry(numKey, tag, displayName));
            }
            catch (Exception e) {
                success = false;
            }
        }
        Model model = new Model();
        this.table = new BTable((TableModel)model);
        this.table.setMultipleSelection(false);
        this.table.setCellRenderer((TableCellRenderer)new CellRenderer());
        model.sort();
        return success;
    }

    private void initTemplatesDropdown() {
        BFacets slotFacets = this.callContext.getFacets();
        String nanoValueType = SlotSchema.getNanoValueType((BFacets)slotFacets);
        if (nanoValueType != null && (SlotSchema.isNiagaraBoolean((String)nanoValueType) || "booleanRange".equalsIgnoreCase(nanoValueType))) {
            this.isBooleanData = true;
            if (this.binaryTemplates == null) {
                this.binaryTemplates = this.parseTemplates(BOrd.make((BOrd)BNe2DeviceExt.LABELS_FILE_ORD, (String)"file:predefinedBinaryLabels_Isma.json"));
            }
            this.updateTemplatesDropdown(this.binaryTemplates);
        } else if (nanoValueType != null && (SlotSchema.isNiagaraNumeric((String)nanoValueType, (BFacets)slotFacets) || SlotSchema.isNiagaraEnum((BFacets)slotFacets) || "multistateRange".equalsIgnoreCase(nanoValueType))) {
            this.isMultistateData = true;
            if (this.multistateTemplates == null) {
                this.multistateTemplates = this.parseTemplates(BOrd.make((BOrd)BNe2DeviceExt.LABELS_FILE_ORD, (String)"file:predefinedMultistateLabels_Isma.json"));
            }
            this.updateTemplatesDropdown(this.multistateTemplates);
        }
    }

    private void updateTemplatesDropdown(LinkedHashMap<String, ArrayList<String>> templates) {
        for (String templateName : templates.keySet()) {
            this.cboxTemplates.addItem(templateName);
        }
    }

    public void computePreferredSize() {
        this.setPreferredSize(350.0, 400.0);
    }

    public void doLayout(BWidget[] kids) {
        double w = this.getWidth();
        double h = this.getHeight();
        this.lblTemplates.computePreferredSize();
        double lblTemplates_w = this.lblTemplates.getPreferredWidth();
        double lblTemplates_h = this.lblTemplates.getPreferredHeight();
        this.cboxTemplates.computePreferredSize();
        double cboxTemplates_h = this.cboxTemplates.getPreferredHeight();
        double templates_h = Math.max(lblTemplates_h, cboxTemplates_h);
        double lblTemplates_y = 8.0;
        this.lblTemplates.setBounds(4.0, lblTemplates_y, lblTemplates_w, templates_h);
        this.cboxTemplates.setBounds(4.0 + lblTemplates_w + 4.0, lblTemplates_y, w - lblTemplates_w - 12.0, templates_h);
        this.btnOk.computePreferredSize();
        this.btnCancel.computePreferredSize();
        double ok_cancel_w = Math.max(this.btnOk.getPreferredWidth(), this.btnCancel.getPreferredWidth());
        double ok_cancel_h = this.btnOk.getPreferredHeight();
        double ok_cancel_y = h - 4.0 - ok_cancel_h;
        double ok_cancel_x = (w - (ok_cancel_w + 4.0 + ok_cancel_w)) / 2.0;
        this.btnOk.setBounds(ok_cancel_x, ok_cancel_y, ok_cancel_w, ok_cancel_h);
        this.btnCancel.setBounds(ok_cancel_x + ok_cancel_w + 4.0, ok_cancel_y, ok_cancel_w, ok_cancel_h);
        this.sep2.setBounds(4.0, ok_cancel_y - 12.0, w - 8.0, 4.0);
        this.gridOptions.computePreferredSize();
        double options_w = this.gridOptions.getPreferredWidth();
        double options_h = this.gridOptions.getPreferredHeight();
        this.gridOptions.setBounds(4.0, this.sep2.getY() - 8.0 - options_h, options_w, options_h);
        this.sep1.setBounds(4.0, this.gridOptions.getY() - 8.0, w - 8.0, 4.0);
        this.btnAdd.computePreferredSize();
        double btn_h = this.btnAdd.getPreferredHeight();
        double btn_w = (w - 16.0) / 3.0;
        double btn_y = this.gridOptions.getY() - btn_h - 8.0;
        this.btnAdd.setBounds(4.0, btn_y, btn_w, btn_h);
        this.btnModify.setBounds(4.0 + (btn_w + 4.0), btn_y, btn_w, btn_h);
        this.btnRemove.setBounds(4.0 + 2.0 * (btn_w + 4.0), btn_y, btn_w, btn_h);
        this.tboxKey.computePreferredSize();
        double key_h = this.tboxKey.getPreferredHeight();
        double key_y = this.btnAdd.getY() - 4.0 - key_h;
        double key_w = w / 5.0;
        double displayName_w = w - key_w - 12.0;
        this.tboxKey.setBounds(4.0, key_y, key_w, key_h);
        this.tboxDisplayName.setBounds(4.0 + key_w + 4.0, key_y, displayName_w, key_h);
        double table_x = 4.0;
        double table_w = w - 8.0;
        double table_top = lblTemplates_y + lblTemplates_h + 8.0;
        double table_bottom = this.tboxKey.getY() - 8.0;
        double table_h = table_bottom - table_top;
        this.table.setBounds(table_x, table_top, table_w, table_h);
    }

    public BDynamicChoiceRange save() {
        String ownerPersistentId = this.orig.getOwnerPersistentId();
        int ownerSlotId = this.orig.getOwnerSlotId();
        String id = this.orig.getId();
        Object[] keys = new Object[this.entries.size()];
        String[] tags = new String[this.entries.size()];
        String nameForInvalidKey = this.tboxInvalidDisplayName.getText();
        int flags = this.orig.getFlags();
        String lexiconModuleName = this.tboxLexicon.getText().isEmpty() ? null : this.tboxLexicon.getText();
        for (int i = 0; i < this.entries.size(); ++i) {
            keys[i] = this.entries.get((int)i).key;
            tags[i] = this.entries.get((int)i).displayName;
        }
        BDynamicChoiceRange newRange = BDynamicChoiceRange.make((String)ownerPersistentId, (int)ownerSlotId, (String)id, (Object[])keys, (String[])tags, (String)nameForInvalidKey, (int)flags, (String)lexiconModuleName);
        return newRange;
    }

    public void doTemplateChanged() {
        if (!this.enabled) {
            return;
        }
        Model model = (Model)this.table.getModel();
        String templateName = this.cboxTemplates.getText();
        if (templateName.isEmpty()) {
            return;
        }
        ArrayList<String> displayNames = null;
        if (this.isBooleanData) {
            displayNames = this.binaryTemplates.get(templateName);
        } else if (this.isMultistateData) {
            displayNames = this.multistateTemplates.get(templateName);
        }
        if (displayNames != null) {
            Entry currentEntry = new Entry(0.0, "");
            for (int i = 0; i < displayNames.size(); ++i) {
                String displayName = displayNames.get(i);
                String tag = SlotPath.escape((String)displayName);
                if (i < this.entries.size()) {
                    currentEntry = this.entries.get(i);
                    currentEntry.displayName = displayName;
                    currentEntry.tag = tag;
                    continue;
                }
                if (!this.isMultistateData) continue;
                currentEntry = new Entry(currentEntry.getNextKey(), displayName);
                this.entries.add(currentEntry);
            }
            model.getSelection().deselectAll();
            model.checkErrors();
            this.checkButtonUpdates();
        }
        LOGGER.finer("[BDynamicChoiceRangeDialog]: Template changed");
    }

    private LinkedHashMap<String, ArrayList<String>> parseTemplates(BOrd templateFileOrd) {
        LinkedHashMap<String, ArrayList<String>> templates = new LinkedHashMap<String, ArrayList<String>>();
        JSONObject rootObject = null;
        try {
            BJsonFile jsonFile = (BJsonFile)templateFileOrd.resolve((BObject)this.getValueParentComponent()).get();
            InputStream inputStream = jsonFile.getInputStream();
            InputStreamReader reader = new InputStreamReader(inputStream);
            JSONTokener tokener = new JSONTokener((Reader)reader);
            while (tokener.more() && rootObject == null) {
                Object o = tokener.nextValue();
                if (!(o instanceof JSONObject)) continue;
                rootObject = (JSONObject)o;
            }
            if (rootObject == null) {
                return templates;
            }
            JSONArray templateNames = rootObject.names();
            for (int i = templateNames.length() - 1; i >= 0; --i) {
                String templateName = templateNames.getString(i);
                Object jsonValue = rootObject.get(rootObject.names().getString(i));
                if (!(jsonValue instanceof JSONArray)) continue;
                JSONArray jsonDisplayNames = (JSONArray)jsonValue;
                ArrayList<String> displayNames = new ArrayList<String>(jsonDisplayNames.length());
                for (int j = 0; j < jsonDisplayNames.length(); ++j) {
                    displayNames.add(jsonDisplayNames.getString(j));
                }
                if (displayNames.size() == 0) continue;
                templates.put(templateName, displayNames);
            }
        }
        catch (IOException | UnresolvedException | ModuleNotFoundException e) {
            LOGGER.log(Level.SEVERE, "[BDynamicChoiceDialog]: Cannot resolve of load file from " + templateFileOrd.toString(), e);
        }
        catch (JSONException e) {
            LOGGER.log(Level.SEVERE, "[BDynamicChoiceDialog]: Cannot parse JSON file. ", e);
        }
        return templates;
    }

    public void windowClosing(BWindowEvent event) {
        this.doCancelPressed();
    }

    public void handleEscape() {
        if (!this.tboxDisplayName.hasFocus()) {
            super.handleEscape();
        }
    }

    public void doCancelPressed() {
        this.result = null;
        this.close();
    }

    public void doOkPressed() {
        if (this.btnModify.isEnabled()) {
            this.doModifyPressed();
        }
        this.pending = this.save();
        this.valueParent = this.getValueParentComponent();
        this.result = new BDynamicChoiceRangeChangedArg(this.valueParent, this.orig, this.pending);
        this.close();
    }

    public void doAddPressed() {
        LOGGER.finer("[BDynamicChoiceRangeDialog]: Insert/Add pressed");
        Model model = (Model)this.table.getModel();
        int lastIndex = model.getRowCount() - 1;
        if (!this.enabled) {
            return;
        }
        this.cboxTemplates.setText("");
        int indexAfterWhichToAdd = -1;
        if (model.isEntrySelected()) {
            indexAfterWhichToAdd = model.getSelection().getRow();
        } else if (model.getRowCount() > 0) {
            indexAfterWhichToAdd = lastIndex;
        }
        for (int i = indexAfterWhichToAdd + 1; i <= lastIndex; ++i) {
            this.entries.get(i).incrementKey();
        }
        Entry elementAfterWhichToAdd = indexAfterWhichToAdd > -1 ? this.entries.get(indexAfterWhichToAdd) : new Entry(0.0, "");
        Number newKey = elementAfterWhichToAdd.getNextKey();
        String displayName = this.tboxDisplayName.getText();
        String tag = SlotPath.escape((String)displayName);
        this.entries.add(indexAfterWhichToAdd + 1, new Entry(newKey, displayName));
        model.checkErrors();
        model.getSelection().deselectAll();
        model.getSelection().select(indexAfterWhichToAdd + 1);
    }

    public void doModifyPressed() {
        LOGGER.finer("[BDynamicChoiceRangeDialog]: Modify pressed");
        if (!this.enabled) {
            return;
        }
        this.doEntryEditConfirmed();
    }

    public void doRemovePressed() {
        LOGGER.finer("[BDynamicChoiceRangeDialog]: Remove pressed");
        Model model = (Model)this.table.getModel();
        int lastIndex = model.getRowCount() - 1;
        if (!this.enabled || lastIndex < 0) {
            return;
        }
        this.cboxTemplates.setText("");
        if (model.isEntrySelected()) {
            int indexToRemove = model.getSelection().getRow();
            Entry entryToRemove = this.entries.get(indexToRemove);
            Number keyOfEntryToRemove = entryToRemove.key;
            if (String.valueOf(entryToRemove.key).equals(this.tboxKey.getText())) {
                for (int i = indexToRemove + 1; i <= lastIndex; ++i) {
                    this.entries.get(i).decrementKey();
                }
                this.entries.remove(indexToRemove);
                model.getSelection().deselectAll();
                if (indexToRemove < model.getRowCount()) {
                    model.getSelection().select(indexToRemove);
                }
                model.checkErrors();
                this.checkButtonUpdates();
            } else {
                this.doSelectionChanged();
            }
        }
    }

    public void doEntryModified() {
        LOGGER.finer("[BDynamicChoiceRangeDialog]: Display Name Modified: " + this.tboxDisplayName.getText());
        this.checkButtonUpdates();
    }

    public void doEntryEditConfirmed() {
        LOGGER.finer("[BDynamicChoiceRangeDialog]: Element Edit Confirmed: " + this.tboxDisplayName.getText());
        if (!this.enabled) {
            return;
        }
        this.cboxTemplates.setText("");
        String displayName = this.tboxDisplayName.getText();
        String tag = SlotPath.escape((String)displayName);
        Model model = (Model)this.table.getModel();
        if (model.isEntrySelected()) {
            Entry entry = this.entries.get(model.getSelection().getRow());
            if (String.valueOf(entry.key).equals(this.tboxKey.getText())) {
                entry.displayName = displayName;
                entry.tag = tag;
                model.checkErrors();
                this.checkButtonUpdates();
            } else {
                this.doSelectionChanged();
            }
        }
    }

    public void doEntryEditCancelled() {
        LOGGER.finer("[BDynamicChoiceRangeDialog]: Element Edit Cancelled: " + this.tboxDisplayName.getText());
        this.selectionChanged();
    }

    public void doSelectionChanged() {
        if (!this.enabled) {
            return;
        }
        Model model = (Model)this.table.getModel();
        if (model.isEntrySelected()) {
            int index = model.getSelection().getRow();
            LOGGER.finer("[BDynamicChoiceRangeDialog]: SelectionChanged to row: " + index);
            Entry entry = this.entries.get(index);
            this.tboxKey.setText(String.valueOf(entry.key));
            this.tboxDisplayName.setText(entry.displayName);
        } else {
            this.tboxDisplayName.setText("");
            this.tboxKey.setText("");
        }
        this.checkButtonUpdates();
    }

    private void checkButtonUpdates() {
        if (!this.enabled) {
            return;
        }
        Model model = (Model)this.table.getModel();
        this.btnAdd.setEnabled(model.allowInsertAfter() && this.isMultistateData);
        if (model.isEntrySelected()) {
            this.tboxDisplayName.setEnabled(true);
            int idx = model.getSelection().getRow();
            this.btnModify.setEnabled(idx != this.ERR && !this.entries.get((int)idx).displayName.equals(this.tboxDisplayName.getText()));
            this.btnRemove.setEnabled(idx != this.ERR && this.isMultistateData && model.getRowCount() > 0);
        } else {
            this.tboxDisplayName.setEnabled(false);
            this.btnModify.setEnabled(false);
            this.btnRemove.setEnabled(false);
        }
        this.btnOk.setEnabled(!model.hasErrors());
    }

    public BNanoBaseComponent getValueParentComponent() {
        return (BNanoBaseComponent)WbUtil.findAncenstorViaWidgetTree((BWidget)this.getOwner(), (Type)BNanoBaseComponent.TYPE, (boolean)true);
    }

    static class Entry
    implements Comparable<Entry> {
        Number key;
        String tag;
        String displayName;
        int status = 0;
        static int INVALID_DISPLAY_NAME = 1;
        static int INVALID_KEY = 2;
        static int DUPLICATE_DISPLAY_NAME = 4;
        static int DUPLICATE_KEY = 8;

        Entry(Number key, String displayName) {
            this(key, SlotPath.escape((String)displayName), displayName);
        }

        Entry(Number key, String tag, String displayName) {
            this.key = key;
            this.tag = tag;
            this.displayName = displayName;
            this.status = 0;
        }

        public Number getNextKey() {
            if (this.key == null) {
                return 1;
            }
            if (this.key instanceof Double) {
                return (Double)this.key + 1.0;
            }
            if (this.key instanceof Long) {
                return (Long)this.key + 1L;
            }
            if (this.key instanceof Integer) {
                return (Integer)this.key + 1;
            }
            if (this.key instanceof Short) {
                return (Short)this.key + 1;
            }
            if (this.key instanceof Byte) {
                return (Byte)this.key + 1;
            }
            if (this.key instanceof Float) {
                return Float.valueOf(((Float)this.key).floatValue() + 1.0f);
            }
            throw new IllegalStateException("Invalid key type");
        }

        public Number incrementKey() {
            if (this.key == null) {
                throw new IllegalStateException("null key cannot be incremented");
            }
            if (this.key instanceof Double) {
                this.key = (Double)this.key + 1.0;
            } else if (this.key instanceof Long) {
                this.key = (Long)this.key + 1L;
            } else if (this.key instanceof Integer) {
                this.key = (Integer)this.key + 1;
            } else if (this.key instanceof Short) {
                this.key = (Short)this.key + 1;
            } else if (this.key instanceof Byte) {
                this.key = (Byte)this.key + 1;
            } else if (this.key instanceof Float) {
                this.key = Float.valueOf(((Float)this.key).floatValue() + 1.0f);
            } else {
                throw new IllegalStateException("Invalid key type");
            }
            return this.key;
        }

        public Number decrementKey() {
            if (this.key == null) {
                throw new IllegalStateException("null key cannot be decremented");
            }
            if (this.key instanceof Double) {
                this.key = (Double)this.key - 1.0;
            } else if (this.key instanceof Long) {
                this.key = (Long)this.key - 1L;
            } else if (this.key instanceof Integer) {
                this.key = (Integer)this.key - 1;
            } else if (this.key instanceof Short) {
                this.key = (Short)this.key - 1;
            } else if (this.key instanceof Byte) {
                this.key = (Byte)this.key - 1;
            } else if (this.key instanceof Float) {
                this.key = Float.valueOf(((Float)this.key).floatValue() - 1.0f);
            } else {
                throw new IllegalStateException("Invalid key type");
            }
            return this.key;
        }

        @Override
        public int compareTo(Entry other) {
            Number otherKey = other.key;
            if (this.key == otherKey) {
                return 0;
            }
            if (this.key == null && otherKey != null) {
                return -1;
            }
            if (this.key != null && otherKey == null) {
                return 1;
            }
            if (this.key instanceof Double) {
                return ((Double)this.key).compareTo(otherKey.doubleValue());
            }
            if (this.key instanceof Long) {
                return ((Long)this.key).compareTo(otherKey.longValue());
            }
            if (this.key instanceof Integer) {
                return ((Integer)this.key).compareTo(otherKey.intValue());
            }
            if (this.key instanceof Short) {
                return ((Short)this.key).compareTo(otherKey.shortValue());
            }
            if (this.key instanceof Byte) {
                return ((Byte)this.key).compareTo(otherKey.byteValue());
            }
            if (this.key instanceof Float) {
                return ((Float)this.key).compareTo(Float.valueOf(otherKey.floatValue()));
            }
            return 0;
        }

        public boolean isKeyInvalid() {
            return (this.status & INVALID_KEY) != 0;
        }

        public boolean isKeyDuplicate() {
            return (this.status & DUPLICATE_KEY) != 0;
        }

        public boolean isDisplayNameInvalid() {
            return (this.status & INVALID_DISPLAY_NAME) != 0;
        }

        public boolean isDisplayNameDuplicate() {
            return (this.status & DUPLICATE_DISPLAY_NAME) != 0;
        }

        public boolean isInvalid() {
            return this.status != 0;
        }

        public int hashCode() {
            return System.identityHashCode(this);
        }

        public boolean equals(Entry other) {
            return this.key == other.key;
        }
    }

    class CellRenderer
    extends TableCellRenderer {
        CellRenderer() {
        }

        public BBrush getForeground(TableCellRenderer.Cell cell) {
            Entry entry = BDynamicChoiceRangeDialog.this.entries.get(cell.row);
            return entry.isInvalid() ? BColor.red.toBrush() : super.getForeground(cell);
        }

        public BBrush getSelectionForeground(TableCellRenderer.Cell cell) {
            Entry entry = BDynamicChoiceRangeDialog.this.entries.get(cell.row);
            return entry.isInvalid() ? BColor.red.toBrush() : super.getSelectionForeground(cell);
        }
    }

    class Model
    extends TableModel {
        private boolean hasErrors;

        Model() {
        }

        public int getColumnCount() {
            return 3;
        }

        public int getRowCount() {
            return BDynamicChoiceRangeDialog.this.entries.size();
        }

        public String getColumnName(int col) {
            switch (col) {
                case 0: {
                    return BDynamicChoiceRangeDialog.this.getLexicon().get(BDynamicChoiceRangeDialog.LEX_KEY_TABLE_COL_KEY, "Value");
                }
                case 1: {
                    return BDynamicChoiceRangeDialog.this.getLexicon().get(BDynamicChoiceRangeDialog.LEX_KEY_TABLE_COL_TAG, "Tag");
                }
                case 2: {
                    return BDynamicChoiceRangeDialog.this.getLexicon().get(BDynamicChoiceRangeDialog.LEX_KEY_TABLE_COL_DISPLAY_NAME, "Display Name");
                }
            }
            throw new IllegalStateException();
        }

        public Object getValueAt(int row, int col) {
            Entry entry = BDynamicChoiceRangeDialog.this.entries.get(row);
            switch (col) {
                case 0: {
                    return String.valueOf(entry.key);
                }
                case 1: {
                    return entry.tag;
                }
                case 2: {
                    return entry.displayName;
                }
            }
            throw new IllegalStateException();
        }

        public boolean isEntrySelected() {
            int i = this.getSelection().getRow();
            return i >= 0 && i < BDynamicChoiceRangeDialog.this.entries.size();
        }

        public boolean allowInsertAfter() {
            return this.isEntrySelected() || !this.isEntrySelected() && BDynamicChoiceRangeDialog.this.entries.size() == 0;
        }

        public boolean checkErrors() {
            boolean hasErrors = false;
            for (Entry entry : BDynamicChoiceRangeDialog.this.entries) {
                String displayName = entry.displayName;
                Number key = entry.key;
                boolean invalidDisplayName = displayName.isEmpty();
                boolean invalidKey = key == null;
                boolean duplicateDisplayName = BDynamicChoiceRangeDialog.this.entries.stream().anyMatch(e -> e.displayName.equals(displayName) && e != entry);
                boolean duplicateKey = BDynamicChoiceRangeDialog.this.entries.stream().anyMatch(e -> e.key.toString().equals(key.toString()) && e != entry);
                entry.status = (invalidDisplayName ? Entry.INVALID_DISPLAY_NAME : 0) + (invalidKey ? Entry.INVALID_KEY : 0) + (duplicateDisplayName ? Entry.DUPLICATE_DISPLAY_NAME : 0) + (duplicateKey ? Entry.DUPLICATE_KEY : 0);
                if (entry.status == 0) continue;
                hasErrors = true;
            }
            this.updateTable();
            this.hasErrors = hasErrors;
            return hasErrors;
        }

        public boolean hasErrors() {
            return this.hasErrors;
        }

        boolean containsDisplayName(String displayName) {
            boolean exists = BDynamicChoiceRangeDialog.this.entries.stream().anyMatch(e -> e.displayName.equals(displayName));
            return exists;
        }

        void sort() {
            Collections.sort(BDynamicChoiceRangeDialog.this.entries);
        }
    }
}

