/*
 * Decompiled with CFR 0.152.
 */
package com.miratech.nE2Link.ui.fieldEditors;

import com.miratech.nE2Link.BNanoBaseComponent;
import com.miratech.nE2Link.BNe2DeviceExt;
import com.miratech.nE2Link.actions.BNanoPropertyChangedArg;
import com.miratech.nE2Link.ui.fieldEditors.BNanoStatusValueFE;
import com.tridium.workbench.util.WbUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.baja.gx.BBrush;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusValue;
import javax.baja.sys.Action;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDouble;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BCheckBox;
import javax.baja.ui.BTextDropDown;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.ToggleCommand;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.list.BList;
import javax.baja.ui.pane.BExpandablePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.text.Segment;
import javax.baja.ui.text.TextRenderer;
import javax.baja.util.Lexicon;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;
import org.jetbrains.annotations.NotNull;

@NiagaraType
@NiagaraActions(value={@NiagaraAction(name="filterChanged", flags=4), @NiagaraAction(name="filterModel", flags=20)})
public abstract class BNumericListAbstractFE
extends BWbFieldEditor {
    public static final Action filterChanged = BNumericListAbstractFE.newAction((int)4, null);
    public static final Action filterModel = BNumericListAbstractFE.newAction((int)20, null);
    public static final Type TYPE = Sys.loadType(BNumericListAbstractFE.class);
    protected static Lexicon LEX = Lexicon.make(BNumericListAbstractFE.class);
    protected static String LEX_KEY_CANNOT_LOAD = "NumericListFE.cannotLoad";
    protected static Logger LOGGER = Logger.getLogger(TYPE.getModule().getModuleName());
    protected static BRelTime FILTER_DELAY = BRelTime.make((long)750L);
    Clock.Ticket filterTicket;
    protected BExpandablePane expander;
    protected BTextField summary;
    protected BGridPane editPane;
    protected BCheckBox checkBoxNull = new BCheckBox("null");
    protected NullToggleCommand nullToggleCommand;
    protected BTextDropDown comboBox = new BTextDropDown("", 15, true);
    BBrush fg = BBrush.NULL;
    BBrush bg = BBrush.NULL;
    private Property valueProperty;
    private BComponent valueParentComponent;
    private Model model;
    protected static final String FORMAT_STRING = "%s (%s)";

    public void filterChanged() {
        this.invoke(filterChanged, null, null);
    }

    public void filterModel() {
        this.invoke(filterModel, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BNumericListAbstractFE() {
        this.nullToggleCommand = new NullToggleCommand((BWidget)this);
        this.checkBoxNull.setCommand((Command)this.nullToggleCommand, false, false);
        this.summary = new BTextField("", 40, false);
        this.editPane = new BGridPane(2);
        this.editPane.setHalign(BHalign.left);
        this.editPane.add("null", (BValue)this.checkBoxNull);
        this.editPane.add("editor", (BValue)this.comboBox);
        this.expander = new BExpandablePane((BWidget)this.summary, (BWidget)this.editPane);
        this.comboBox.getEditor().setRenderer((TextRenderer)new Renderer());
        this.setContent((BWidget)this.expander);
        this.linkTo("lk0", (BComponent)this.comboBox, (Slot)BTextDropDown.valueModified, (Slot)setModified);
        this.linkTo("lk1", (BComponent)this.comboBox, (Slot)BTextDropDown.actionPerformed, (Slot)actionPerformed);
        this.linkTo("lk2", (BComponent)this.comboBox.getEditor(), (Slot)BTextField.textModified, (Slot)filterChanged);
    }

    protected void doSetReadonly(boolean readonly) {
        this.expander.setExpanderVisible(!readonly);
    }

    protected void doLoadValue(BObject raw, Context cx) throws Exception {
        if (!raw.getType().is(BStatusNumeric.TYPE)) {
            Object[] args = new Object[]{raw instanceof BComplex ? ((BComplex)raw).getPropertyInParent() : "simple", BStatusNumeric.TYPE, raw.getType()};
            throw new LocalizableRuntimeException(BNumericListAbstractFE.LEX.module.getModuleName(), LEX_KEY_CANNOT_LOAD, args);
        }
        BStatusNumeric value = (BStatusNumeric)raw;
        this.valueProperty = value.getPropertyInParent();
        this.valueParentComponent = (BComponent)value.getParent();
        boolean allowNull = true;
        if (cx != null) {
            allowNull = cx.getFacets().getb("allowNull", true);
        }
        if (!allowNull) {
            this.checkBoxNull.setEnabled(false);
            this.checkBoxNull.setSelected(false);
        }
        this.model = this.createModel(cx);
        this.model.sortByDisplayName(false);
        Model.Element elementForValue = this.model.getElement(value.getValue());
        String displayText = elementForValue != null ? elementForValue.toString(cx) : value.valueToString(this.getCurrentContext());
        this.comboBox.setText(displayText);
        this.summary.setText(displayText);
    }

    protected BObject doSaveValue(BObject raw, Context cx) throws Exception {
        Double foundValue;
        Integer slotId;
        Property changedProperty;
        boolean isProxyComponent;
        BComponent parent = this.getValueParentComponent(raw);
        if (parent == null || !(parent instanceof BNanoBaseComponent)) {
            throw new LocalizableRuntimeException(BNumericListAbstractFE.LEX.module.getModuleName(), BNanoStatusValueFE.LEX_KEY_CANNOT_SAVE_NO_PARENT);
        }
        BNanoBaseComponent sourceComponent = (BNanoBaseComponent)parent;
        Context callContext = this.getCurrentContext();
        boolean bl = isProxyComponent = sourceComponent.getComponentSpace() != null && sourceComponent.getComponentSpace().isProxyComponentSpace();
        if (isProxyComponent) {
            sourceComponent.lease(1);
        }
        if ((changedProperty = sourceComponent.getNanoSlot(slotId = BNanoBaseComponent.getNanoSlotId((BFacets)callContext.getFacets()))) == null) {
            throw new LocalizableRuntimeException(BNumericListAbstractFE.LEX.module.getModuleName(), BNanoStatusValueFE.LEX_KEY_CANNOT_SAVE_NO_SLOT, new Object[]{slotId});
        }
        BStatusNumeric statusValue = (BStatusNumeric)raw;
        BStatusNumeric oldValue = (BStatusNumeric)statusValue.newCopy();
        BStatus status = this.checkBoxNull.isSelected() ? BStatus.nullStatus : BStatus.ok;
        String searchString = this.comboBox.getEditor().getText();
        Model.Element foundElement = this.model.findElementByToStringExact(searchString, this.getCurrentContext());
        if (foundElement == null) {
            foundElement = this.model.findElementByToString(searchString, this.getCurrentContext());
        }
        if (foundElement != null) {
            foundValue = foundElement.getKey();
        } else {
            foundValue = 0.0;
            status = BStatus.nullStatus;
        }
        statusValue.set(statusValue.getValueProperty(), (BValue)BDouble.make((double)foundValue), cx);
        statusValue.set(BStatusValue.status, (BValue)status, cx);
        BStatusNumeric pendingValue = (BStatusNumeric)statusValue.newCopy();
        pendingValue.setValue(foundValue.doubleValue());
        pendingValue.setStatus(status);
        if (!pendingValue.equivalent((Object)oldValue)) {
            BNe2DeviceExt ne2DeviceExt = sourceComponent.getNe2DeviceExt();
            BNanoPropertyChangedArg changedArg = new BNanoPropertyChangedArg(sourceComponent, changedProperty, (BValue)oldValue, (BValue)pendingValue, this.getCurrentContext());
            ne2DeviceExt.handleNanoPropertyValueChange(changedArg);
        }
        return statusValue;
    }

    public BComponent getValueParentComponent(BObject currentValue) {
        BComplex parent;
        BComplex bComplex = parent = currentValue instanceof BComplex ? ((BComplex)currentValue).getParent() : null;
        if (parent != null) {
            return parent.asComponent();
        }
        return (BNanoBaseComponent)WbUtil.findAncenstorViaWidgetTree((BWidget)this, (Type)BNanoBaseComponent.TYPE, (boolean)true);
    }

    public void doFilterChanged() {
        if (this.filterTicket != null && !this.filterTicket.isExpired()) {
            this.filterTicket.cancel();
        }
        this.filterTicket = Clock.schedule((BComponent)this, (BRelTime)FILTER_DELAY, (Action)filterModel, null);
    }

    public void doFilterModel() {
        this.model.filter(this.comboBox.getText(), this.getCurrentContext(), true);
    }

    public Model getModel() {
        return this.model;
    }

    protected Property getValueProperty() {
        return this.valueProperty;
    }

    protected BComponent getValueParentComponent() {
        return this.valueParentComponent;
    }

    protected abstract Model createModel(Context var1);

    class Renderer
    extends TextRenderer {
        Renderer() {
        }

        public BBrush getBackground() {
            if (BNumericListAbstractFE.this.bg.isNull()) {
                return super.getBackground();
            }
            return BNumericListAbstractFE.this.bg;
        }

        public BBrush getForeground(Segment seg) {
            if (BNumericListAbstractFE.this.fg.isNull()) {
                return super.getForeground(seg);
            }
            return BNumericListAbstractFE.this.fg;
        }
    }

    class NullToggleCommand
    extends ToggleCommand {
        NullToggleCommand(BWidget owner) {
            super(owner, "null");
        }

        public void setSelected(boolean s) {
            super.setSelected(s);
            if (BNumericListAbstractFE.this.comboBox != null) {
                BNumericListAbstractFE.this.comboBox.setEnabled(!s);
                BNumericListAbstractFE.this.comboBox.setText("");
            }
        }
    }

    class Model {
        private LinkedHashMap<Double, Element> model = new LinkedHashMap();
        private LinkedHashMap<Double, Element> originModel = new LinkedHashMap();
        private String currentFilter;
        private String modelName;
        private BTextDropDown uiElement;
        private int longestEntry = 0;

        public Model() {
            this.uiElement = BNumericListAbstractFE.this.comboBox;
        }

        public Model(String modelName) {
            this();
            this.modelName = modelName;
        }

        public void updateUi() {
            BList list = this.uiElement.getList();
            list.removeAllItems();
            for (Element element : this.model.values()) {
                list.addItem((Object)element);
            }
            this.uiElement.getEditor().setVisibleColumns(this.longestEntry);
        }

        public String getModelName() {
            return this.modelName;
        }

        public List<Element> getAllElements() {
            return Collections.unmodifiableList(new ArrayList<Element>(this.originModel.values()));
        }

        public Element addElement(Element element, Context context) {
            this.longestEntry = Math.max(this.longestEntry, element.toString(context).length());
            this.model.put(element.getKey(), element);
            return this.originModel.put(element.getKey(), element);
        }

        public Element getElement(double key) {
            return this.originModel.get(key);
        }

        public void filter(String filter, Context context) {
            this.filter(filter, context, true);
        }

        public void filter(String filter, Context context, boolean updateUI) {
            if (filter == null) {
                filter = "";
            }
            if (filter.equals(this.currentFilter)) {
                return;
            }
            this.currentFilter = filter;
            if (filter.isEmpty() || this.findElementByToStringExact(filter, context) != null) {
                this.model = (LinkedHashMap)this.originModel.clone();
                if (updateUI) {
                    this.updateUi();
                }
            } else {
                String finalFilter = filter;
                this.model = this.originModel.entrySet().stream().filter(entry -> ((Element)entry.getValue()).toString(context).toLowerCase(Locale.ROOT).contains(finalFilter.toLowerCase(Locale.ROOT))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (e1, e2) -> e1, LinkedHashMap::new));
            }
            if (updateUI) {
                this.updateUi();
            }
        }

        public Element findElementByToStringExact(String searchString, Context context) {
            Map.Entry foundEntry = this.originModel.entrySet().stream().filter(entry -> ((Element)entry.getValue()).toString(context).equals(searchString)).findFirst().orElse(null);
            return foundEntry == null ? null : (Element)foundEntry.getValue();
        }

        public Element findElementByToString(String searchString, Context context) {
            Map.Entry foundEntry = this.originModel.entrySet().stream().filter(entry -> ((Element)entry.getValue()).toString(context).toLowerCase(Locale.ROOT).contains(searchString.toLowerCase(Locale.ROOT))).findFirst().orElse(null);
            return foundEntry == null ? null : (Element)foundEntry.getValue();
        }

        public void sortByDisplayName() {
            this.sortByDisplayName(true);
        }

        public void sortByDisplayName(boolean updateUI) {
            this.originModel = this.originModel.entrySet().stream().sorted(Map.Entry.comparingByValue()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (e1, e2) -> e1, LinkedHashMap::new));
        }

        class Element
        implements Comparable<Element> {
            private final double key;
            private final String name;
            private final String defaultDisplayName;
            private final String displayName;

            public Element(double key, String name, String defaultDisplayName) {
                this.key = key;
                this.name = name;
                this.defaultDisplayName = defaultDisplayName;
                this.displayName = LEX.get(this.getLexiconKey(), defaultDisplayName);
            }

            public double getKey() {
                return this.key;
            }

            public String getName() {
                return this.name;
            }

            public String getLexiconKey() {
                return "BACnetCustomPoints." + Model.this.modelName + "." + this.name;
            }

            public String getDefaultDisplayName() {
                return this.defaultDisplayName;
            }

            public String getDisplayName(Context context) {
                return this.toString(context);
            }

            public String toString() {
                return this.toString(null);
            }

            public String toString(Context context) {
                return context == null ? String.format(BNumericListAbstractFE.FORMAT_STRING, this.displayName, (int)this.key) : String.format(BNumericListAbstractFE.FORMAT_STRING, this.displayName, BDouble.toString((double)this.key, (Context)context));
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                Element element = (Element)o;
                return Double.compare(element.key, this.key) == 0 && this.name.equals(element.name) && Objects.equals(this.defaultDisplayName, element.defaultDisplayName) && Objects.equals(this.displayName, element.displayName);
            }

            public int hashCode() {
                return Objects.hash(this.key, this.name, this.defaultDisplayName, this.displayName);
            }

            @Override
            public int compareTo(@NotNull Element other) {
                if (this.displayName != null && other != null && other.displayName != null) {
                    return this.displayName.compareTo(other.displayName);
                }
                throw new NullPointerException("[Element.compareTo()]: Cannot compare null objects");
            }
        }
    }
}

