/*
 * Decompiled with CFR 0.152.
 */
package com.miratech.nE2Link.ui.notifications;

import com.miratech.nE2Link.notifications.BMessageTypeEnum;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BModule;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BNotification;
import javax.baja.util.Lexicon;
import javax.baja.workbench.BWbShell;
import javax.baja.workbench.util.BNotificationHandler;
import org.jetbrains.annotations.NotNull;

@NiagaraType(agent={@AgentOn(types={"nE2Link:MessageNotification"}, requiredPermissions="ri")})
public class BMessageNotificationHandler
extends BNotificationHandler {
    public static final Type TYPE = Sys.loadType(BMessageNotificationHandler.class);

    public Type getType() {
        return TYPE;
    }

    public void handle(BWbShell shell, @NotNull BNotification notification, Context context) {
        if (shell == null) {
            return;
        }
        BMessageTypeEnum messageType = (BMessageTypeEnum)notification.get("messageType");
        if (messageType == null) {
            return;
        }
        if (this.ensureProperties(notification, context)) {
            super.handle(shell, notification, context);
        }
    }

    private boolean ensureProperties(@NotNull BNotification notification, Context cx) {
        BMessageTypeEnum messageType = (BMessageTypeEnum)notification.get("messageType");
        if (messageType == null) {
            return false;
        }
        boolean ok = true;
        Lexicon lex = Lexicon.make((BModule)TYPE.getModule(), (Context)cx);
        if (notification.get("title") == null) {
            if (messageType.equals((Object)BMessageTypeEnum.invalidLinkNanoNiagara)) {
                notification.add("title", (BValue)BString.make((String)lex.get("NanoMessageNotificationHandler.titleInvalidLinkNanoNiagara", "Invalid Link From nE\u00b2 To Niagara Component")));
            } else if (messageType.equals((Object)BMessageTypeEnum.deviceDisconnected)) {
                notification.add("title", (BValue)BString.make((String)lex.get("NanoMessageNotificationHandler.titleDisconnected", "Disconnected")));
            } else if (messageType.equals((Object)BMessageTypeEnum.error)) {
                notification.add("title", (BValue)BString.make((String)lex.get("NanoMessageNotificationHandler.titleError", "Error")));
            } else {
                notification.add("title", (BValue)BString.make((String)lex.get("NanoMessageNotificationHandler.titleUnknown", "Notification")));
            }
        }
        if (notification.get("message") == null) {
            BString defaultValue;
            switch (messageType.getOrdinal()) {
                case 1: {
                    defaultValue = BString.make((String)lex.get("NanoMessageNotificationHandler.messageInvalidLinkNanoNiagara", "Not allowed to link nE\u00b2 components to Niagara components. \nLink will be deleted. \nTo read data from nE\u00b2 components, expose it using Nano datapoints on BACnet or Modbus IP\nthrough a properly licensed Tridium BACnet or ModbusTCP driver."));
                    break;
                }
                case 2: {
                    defaultValue = BString.make((String)lex.get("NanoMessageNotificationHandler.messageError", "Generic Error"));
                    break;
                }
                case 3: {
                    defaultValue = BString.make((String)lex.get("NanoMessageNotificationHandler.messageDeviceDisconnected", "Device disconnected unexpectedly- \nPlease refer to the console for details."));
                    break;
                }
                default: {
                    ok = false;
                    defaultValue = BString.make((String)lex.get("NanoMessageNotificationHandler.messageUnknown", "Unknown"));
                }
            }
            notification.add("message", (BValue)defaultValue);
        }
        return ok;
    }
}

