/*
 * Decompiled with CFR 0.152.
 */
package com.miratech.nE2Link.ui.schedules;

import com.miratech.nE2Link.BNanoComponent;
import com.miratech.nE2Link.BNanoConfig;
import com.miratech.nE2Link.BNe2DeviceExt;
import com.miratech.nE2Link.actions.BNanoScheduleChangedArg;
import com.miratech.nE2Link.ui.schedules.BNanoAbstractScheduleView;
import com.miratech.nE2Link.ui.schedules.BNanoCompositeEd;
import com.tridium.schedule.ui.BCompositeEd;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.schedule.BAbstractSchedule;
import javax.baja.schedule.BCompositeSchedule;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BValign;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.util.Lexicon;
import javax.baja.workbench.BWbShell;

@NiagaraType(agent={@AgentOn(types={"nE2Link:NanoComponent"}, defaultAgent=AgentOn.Preference.PREFERRED)})
@NiagaraAction(name="scheduleModified")
public class BNanoCalendarView
extends BNanoAbstractScheduleView {
    public static final Action scheduleModified = BNanoCalendarView.newAction((int)0, null);
    public static final Type TYPE = Sys.loadType(BNanoCalendarView.class);
    BNanoCompositeEd compositeEd;
    BNanoComponent currentValue;
    BEdgePane contentPane;
    BGridPane headerPane;
    private static Object syncObject = new Object();
    private final Lexicon lex = this.getLexicon();

    public void scheduleModified() {
        this.invoke(scheduleModified, null, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    public BNanoCalendarView() {
        this.contentPane = new BEdgePane();
        this.compositeEd = new BNanoCompositeEd(this, false, true);
        this.contentPane.setCenter((BWidget)this.compositeEd);
        BGridPane gp = new BGridPane(2);
        gp.setRowAlign(BValign.fill);
        gp.setColumnAlign(BHalign.fill);
        gp.setUniformColumnWidth(true);
        gp.setUniformRowHeight(true);
        this.contentPane.setBottom((BWidget)new BBorderPane((BWidget)gp));
        this.setContent((BWidget)this.contentPane);
        this.linkTo((BComponent)this.compositeEd, (Slot)BCompositeEd.modified, (Slot)scheduleModified);
    }

    @Override
    protected void doLoadValue(BObject value, Context cx) throws Exception {
        super.doLoadValue(value, cx);
        this.currentValue = (BNanoComponent)this.getCurrentValue();
        this.currentValue.lease(3);
        this.currentValue.requestNanoSubscription();
        if (null != this.nanoSchedule) {
            this.compositeEd.setSchedule((BCompositeSchedule)this.nanoSchedule);
            this.compositeEd.setReadonly(this.readonly());
            this.compositeEd.selected();
        }
        BNe2DeviceExt ne2DeviceExt = this.currentValue.getNe2DeviceExt();
        StringBuilder titleLabel = new StringBuilder("").append(ne2DeviceExt.getSoftwareManager().getIpAddress()).append(":").append(ne2DeviceExt.getSoftwareManager().getIFnetPort()).append(" - ").append(this.currentValue.getNanoName());
        this.headerPane = new BGridPane(1);
        this.headerPane.setRowAlign(BValign.center);
        this.headerPane.setColumnAlign(BHalign.center);
        this.headerPane.add(null, (BValue)new BLabel(titleLabel.toString()));
        this.contentPane.setTop((BWidget)this.headerPane);
        this.registerForComponentEvents((BComponent)this.currentValue);
    }

    public void doScheduleModified() {
        BNanoConfig config;
        this.validateSchedule(this.nanoSchedule, null);
        String persistentId = this.currentValue.getPersistentId();
        BNanoScheduleChangedArg scheduleChangedArg = new BNanoScheduleChangedArg(persistentId, (BAbstractSchedule)this.nanoSchedule.newCopy());
        BNe2DeviceExt ne2DeviceExt = this.currentValue.getNe2DeviceExt();
        if (!ne2DeviceExt.isSubscribed()) {
            this.lease();
        }
        if (!(config = ne2DeviceExt.getConfig()).isSubscribed()) {
            config.lease(1);
        }
        if (config.getCommunicationSettings().getStatus().getOrdinal() == 0) {
            ne2DeviceExt.handleNanoScheduleChanged(scheduleChangedArg);
        } else {
            BDialog.error((BWidget)this, (Object)this.lex.get("deviceStatus.warning.notconnected"));
            ((BWbShell)this.getShell()).getRefreshCommand().invoke();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleComponentEvent(BComponentEvent event) {
        Object object = syncObject;
        synchronized (object) {
            if (event.getSlotName().equals("NanoCalendar")) {
                try {
                    super.doLoadValue((BObject)this.currentValue, this.getCurrentContext());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (null != (BCompositeSchedule)this.nanoSchedule) {
                    this.compositeEd.setSchedule((BCompositeSchedule)this.nanoSchedule);
                }
                this.compositeEd.setReadonly(this.readonly());
                this.compositeEd.filterActionPerformed();
            }
        }
    }
}

