/*
 * Decompiled with CFR 0.152.
 */
package com.miratech.nE2Link.ui.schedules;

import com.miratech.nE2Link.schedules.BNanoDateSchedule;
import com.miratech.nE2Link.ui.schedules.BNanoDayOfMonthEd;
import com.miratech.nE2Link.ui.schedules.BNanoMonthEd;
import com.miratech.nE2Link.ui.schedules.BNanoWeekdayEd;
import com.miratech.nE2Link.ui.schedules.BNanoYearEd;
import com.tridium.schedule.ui.BDateEd;
import com.tridium.schedule.ui.BYearEd;
import com.tridium.workbench.util.BDatePickerCalendar;
import javax.baja.gx.BImage;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.schedule.BAbstractSchedule;
import javax.baja.schedule.BEnumSetSchedule;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BMonth;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BButton;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BButtonStyle;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BValign;
import javax.baja.ui.pane.BGridPane;

@NiagaraType
public class BNanoDateEd
extends BDateEd {
    public static final Type TYPE = Sys.loadType(BNanoDateEd.class);
    boolean isRange;
    boolean isSimpleDate;
    BNanoDayOfMonthEd dayOfMonthEd;
    BNanoMonthEd monthEd;
    BYearEd yearEd;
    BNanoDateEd dateEd;
    BNanoWeekdayEd weekDayEd;
    BNanoDateSchedule dateSchedule;
    BAbstractSchedule absSchedule;
    BButton calendarBtn;
    BDatePickerCalendar pickerCalendarEd;

    public Type getType() {
        return TYPE;
    }

    public BNanoDateEd() {
        this(false, false);
    }

    public BNanoDateEd(boolean range, boolean simpleDate) {
        this.isRange = range;
        this.isSimpleDate = simpleDate;
        BGridPane gp = new BGridPane(1);
        gp.setValign(BValign.center);
        gp.setHalign(BHalign.left);
        if (!range) {
            this.weekDayEd = new BNanoWeekdayEd();
            BGridPane gp1 = new BGridPane(1);
            gp1.setValign(BValign.center);
            gp1.setHalign(BHalign.left);
            gp1.add("weekDay", (BValue)this.weekDayEd);
            gp.add("gp1", (BValue)gp1);
        }
        this.dayOfMonthEd = new BNanoDayOfMonthEd(simpleDate);
        this.monthEd = new BNanoMonthEd(simpleDate);
        this.yearEd = new BNanoYearEd(simpleDate);
        this.calendarBtn = new BButton(BImage.make((String)"module://nE2Link/rc/icons/x16/calendar.svg"));
        this.calendarBtn.setButtonStyle(BButtonStyle.toolBar);
        BGridPane gp2 = new BGridPane(4);
        gp2.setValign(BValign.center);
        gp2.setHalign(BHalign.left);
        gp2.add("dayOfMonth", (BValue)this.dayOfMonthEd);
        gp2.add("month", (BValue)this.monthEd);
        gp2.add("year", (BValue)this.yearEd);
        gp2.add("calendar", (BValue)this.calendarBtn);
        gp.add("gp2", (BValue)gp2);
        this.linkTo((BComponent)this.dayOfMonthEd, (Slot)BNanoDayOfMonthEd.modified, (Slot)dayModified);
        this.linkTo((BComponent)this.monthEd, (Slot)BNanoMonthEd.modified, (Slot)monthModified);
        if (!range) {
            this.linkTo((BComponent)this.weekDayEd, (Slot)BNanoWeekdayEd.modified, (Slot)weekdayModified);
        }
        this.linkTo((BComponent)this.yearEd, (Slot)BYearEd.modified, (Slot)yearModified);
        this.linkTo((BComponent)this.calendarBtn, (Slot)BButton.actionPerformed, (Slot)showCalendar);
        this.setContent((BWidget)gp);
    }

    public void load(BAbstractSchedule schedule, BNanoDateSchedule dateSchedule) {
        this.absSchedule = schedule;
        this.dateSchedule = dateSchedule;
        this.calendarBtn.setEnabled(!this.isReadonly());
        this.yearEd.setReadonly(this.isReadonly());
        this.yearEd.load(dateSchedule.getYearSchedule());
        this.dayOfMonthEd.setReadonly(this.isReadonly());
        this.dayOfMonthEd.load(schedule, (BEnumSetSchedule)dateSchedule.getDaySchedule());
        this.monthEd.setReadonly(this.isReadonly());
        this.monthEd.load(schedule, (BEnumSetSchedule)dateSchedule.getMonthSchedule());
        if (!this.isRange) {
            this.weekDayEd.setReadonly(this.isReadonly());
            this.weekDayEd.load(schedule, (BEnumSetSchedule)dateSchedule.getWeekdaySchedule());
        }
    }

    public void doShowCalendar() {
        BAbsTime t = Clock.time();
        int yr = t.getYear();
        BMonth mo = t.getMonth();
        if (this.dateEd != null) {
            if (this.dateEd.dateSchedule.getYear() >= 0) {
                yr = this.dateEd.dateSchedule.getYear();
            }
            if (this.dateEd.dateSchedule.getMonth() >= 0) {
                mo = BMonth.make((int)this.dateEd.dateSchedule.getMonth());
            }
        }
        this.pickerCalendarEd = BDatePickerCalendar.dialog((BWidget)this, (int)yr, (BMonth)mo);
        if (this.pickerCalendarEd != null) {
            if (!this.isRange) {
                this.weekDayEd.select(this.weekDayEd.getWildcard());
            }
            this.dayOfMonthEd.select(this.pickerCalendarEd.day);
            this.monthEd.select(this.pickerCalendarEd.month.getOrdinal());
            this.yearEd.select(this.pickerCalendarEd.year);
            this.repaint();
            this.fireModified(null);
        }
    }

    public void setReadonly(boolean ro) {
        super.setReadonly(ro);
        this.yearEd.setReadonly(ro);
        this.calendarBtn.setEnabled(!ro);
        this.dayOfMonthEd.setReadonly(ro);
        this.monthEd.setReadonly(ro);
        if (!this.isRange) {
            this.weekDayEd.setReadonly(ro);
        }
    }

    public BNanoMonthEd getMonthEd() {
        return this.monthEd;
    }

    public BNanoDayOfMonthEd getDayOfMonthEd() {
        return this.dayOfMonthEd;
    }

    public BYearEd getYearEd() {
        return this.yearEd;
    }

    public BDatePickerCalendar getPickerCalendarEd() {
        return this.pickerCalendarEd;
    }

    public BButton getCalendarBtn() {
        return this.calendarBtn;
    }
}

