/*
 * Decompiled with CFR 0.152.
 */
package com.miratech.nE2Link.ui.schedules;

import com.miratech.nE2Link.choice.BDynamicChoice;
import com.miratech.nE2Link.choice.BDynamicChoiceRange;
import com.miratech.nE2Link.choice.BStatusDynamicChoice;
import com.miratech.nE2Link.schedules.BNanoSchedule;
import com.miratech.nE2Link.schedules.BNanoWeekSchedule;
import com.miratech.nE2Link.ui.schedules.BNanoAbstractScheduleView;
import com.miratech.nE2Link.ui.schedules.BNanoDaySlider;
import com.miratech.nE2Link.ui.schedules.BNanoSliderLabels;
import com.tridium.schedule.ui.BAbstractScheduleWidget;
import com.tridium.schedule.ui.BDaySlider;
import com.tridium.schedule.ui.BLatticePane;
import java.time.DayOfWeek;
import javax.baja.gx.BInsets;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.schedule.BAbstractSchedule;
import javax.baja.schedule.BDailySchedule;
import javax.baja.schedule.BDaySchedule;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusValue;
import javax.baja.sys.Action;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BNumber;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBorder;
import javax.baja.ui.BLabel;
import javax.baja.ui.BWidget;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;

@NiagaraType
@NiagaraActions(value={@NiagaraAction(name="clearWholeWeek"), @NiagaraAction(name="applyToWeekDays", parameterType="BDaySchedule", defaultValue="new BDaySchedule()"), @NiagaraAction(name="applyToWholeWeek", parameterType="BDaySchedule", defaultValue="new BDaySchedule()"), @NiagaraAction(name="sliderModified"), @NiagaraAction(name="sliderSelected", parameterType="BNanoDaySlider", defaultValue="new BNanoDaySlider()")})
public class BNanoDayEd
extends BAbstractScheduleWidget
implements BDaySlider.Clipboard {
    public static final Action clearWholeWeek = BNanoDayEd.newAction((int)0, null);
    public static final Action applyToWeekDays = BNanoDayEd.newAction((int)0, (BValue)new BDaySchedule(), null);
    public static final Action applyToWholeWeek = BNanoDayEd.newAction((int)0, (BValue)new BDaySchedule(), null);
    public static final Action sliderModified = BNanoDayEd.newAction((int)0, null);
    public static final Action sliderSelected = BNanoDayEd.newAction((int)0, (BValue)new BNanoDaySlider(), null);
    public static final Type TYPE = Sys.loadType(BNanoDayEd.class);
    BAbstractSchedule root;
    BFacets facets;
    BDaySchedule clipboard;
    BDaySchedule[] schedules;
    BNanoDaySlider current;
    BNanoDaySlider[] sliders;
    BStatusValue defaultValue;
    BStatusValue lastEffectiveValue;
    String[] scheduleLabels;
    BLabel[] sliderHeaders;
    BLatticePane sliderContainer = new BLatticePane();

    public void clearWholeWeek() {
        this.invoke(clearWholeWeek, null, null);
    }

    public void applyToWeekDays(BDaySchedule parameter) {
        this.invoke(applyToWeekDays, (BValue)parameter, null);
    }

    public void applyToWholeWeek(BDaySchedule parameter) {
        this.invoke(applyToWholeWeek, (BValue)parameter, null);
    }

    public void sliderModified() {
        this.invoke(sliderModified, null, null);
    }

    public void sliderSelected(BNanoDaySlider parameter) {
        this.invoke(sliderSelected, (BValue)parameter, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BNanoDayEd(boolean daily) {
        if (daily) {
            this.sliders = new BNanoDaySlider[1];
            this.sliders[0] = new BNanoDaySlider(this, false);
            this.addSlider(this.sliders[0], null, 0);
        } else {
            this.sliderContainer.cols = 7;
            this.sliderContainer.rows = 1;
            this.sliders = new BNanoDaySlider[7];
            this.sliderHeaders = new BLabel[7];
            for (int i = 0; i < this.sliders.length; ++i) {
                this.sliders[i] = new BNanoDaySlider(this, true);
                this.sliderHeaders[i] = new BLabel();
                this.addSlider(this.sliders[i], this.sliderHeaders[i], i == 0 ? 0 : 5);
            }
        }
        BEdgePane content = new BEdgePane();
        content.setCenter((BWidget)this.sliderContainer);
        BEdgePane sep = new BEdgePane();
        sep.setTop((BWidget)new BLabel(" "));
        sep.setCenter((BWidget)new BNanoSliderLabels(this.sliders[0], 10.0, 5.0));
        content.setLeft((BWidget)new BBorderPane((BWidget)sep, 0.0, 0.0, 0.0, 0.0));
        this.setContent((BWidget)content);
    }

    public void doClearWholeWeek() {
        int i = this.schedules.length;
        while (--i >= 0) {
            this.sliders[i].clearDay();
        }
        this.sliderContainer.repaint();
        this.fireModified(null);
    }

    public void doApplyToWeekDays(BDaySchedule sch) {
        String sat = DayOfWeek.SATURDAY.toString();
        String sun = DayOfWeek.SUNDAY.toString();
        int i = this.schedules.length;
        while (--i >= 0) {
            if (this.schedules[i] == sch || this.scheduleLabels[i].equals(sat) || this.scheduleLabels[i].equals(sun)) continue;
            this.sliders[i].clearDay();
            this.sliders[i].copy(sch);
        }
        this.sliderContainer.repaint();
        this.fireModified(null);
    }

    public void doApplyToWholeWeek(BDaySchedule sch) {
        int i = this.schedules.length;
        while (--i >= 0) {
            if (this.schedules[i] == sch) continue;
            this.sliders[i].clearDay();
            this.sliders[i].copy(sch);
        }
        this.sliderContainer.repaint();
        this.fireModified(null);
    }

    public void doSliderModified() {
        this.fireModified(null);
    }

    public void doSliderSelected(BNanoDaySlider slider) {
        if (this.current != null && this.current != slider) {
            this.current.deselect();
        }
        this.current = slider;
    }

    public BDaySchedule get() {
        return this.clipboard;
    }

    public void set(BDaySchedule sch) {
        this.clipboard = sch;
    }

    public BStatusValue newEffectiveValue() {
        if (this.lastEffectiveValue != null) {
            return (BStatusValue)this.lastEffectiveValue.newCopy(true);
        }
        try {
            BStatus s;
            BStatusValue sv = (BStatusValue)this.defaultValue.newCopy(true);
            if (this.root != null) {
                switch (((BNanoSchedule)this.root).getScheduleType().getOrdinal()) {
                    case 1: {
                        BBoolean b = ((BStatusDynamicChoice)sv).getValue().getKeyAsBoolean();
                        sv = new BStatusDynamicChoice(BDynamicChoice.make((!b.getBoolean() ? 1 : 0) != 0, (BDynamicChoiceRange)((BDynamicChoiceRange)this.root.get("labels"))));
                        break;
                    }
                    case 2: {
                        BNumber n = ((BStatusDynamicChoice)sv).getValue().getKeyAsNumber();
                        sv = new BStatusDynamicChoice(BDynamicChoice.make((Object)n, (BDynamicChoiceRange)((BDynamicChoiceRange)this.root.get("labels"))));
                        break;
                    }
                }
            }
            if ((s = sv.getStatus()).isNull()) {
                sv.setStatus(BStatus.makeNull((BStatus)s, (boolean)false));
            }
            return sv;
        }
        catch (Exception e) {
            return new BStatusNumeric();
        }
    }

    public void setDaySchedule(BAbstractSchedule absSched, BDaySchedule sch) {
        this.defaultValue = (BStatusValue)absSched.get("defaultOutput");
        this.schedules = new BDaySchedule[]{sch};
        this.scheduleLabels = new String[]{""};
        this.sliders[0].load(this.schedules[0], this.defaultValue);
        this.sliders[0].relayout();
        this.root = absSched.getRootSchedule();
        this.facets = (BFacets)this.root.get("facets");
    }

    public void setReadonly(boolean ro) {
        super.setReadonly(ro);
        for (int i = 0; i < this.sliders.length; ++i) {
            this.sliders[i].setReadonly(ro);
        }
    }

    public void setWeekSchedule(BAbstractSchedule absSched, BNanoWeekSchedule ws) {
        try {
            this.defaultValue = (BStatusValue)absSched.get("defaultOutput");
            BDailySchedule[] schedulesInOrder = ws.schedulesInOrder((Context)null);
            DayOfWeek[] daysInOrder = BNanoWeekSchedule.getDaysInOrder((Context)null);
            this.schedules = new BDaySchedule[7];
            this.scheduleLabels = new String[7];
            for (int i = 0; i < 7; ++i) {
                this.schedules[i] = schedulesInOrder[i].getDay();
                this.scheduleLabels[i] = daysInOrder[i].toString();
                this.sliders[i].load(this.schedules[i], this.defaultValue);
                this.sliders[i].relayout();
                this.sliderHeaders[i].setText(this.scheduleLabels[i]);
                this.sliderHeaders[i].relayout();
            }
            this.root = absSched.getRootSchedule();
            this.facets = (BFacets)this.root.get("facets");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void addSlider(BNanoDaySlider slider, BLabel sliderLabel, int borderWidth) {
        BBorderPane bp = new BBorderPane((BWidget)slider);
        bp.setPadding(BInsets.DEFAULT);
        bp.setBorder(BBorder.DEFAULT);
        this.sliderContainer.add(this.makeColumn(sliderLabel, (BWidget)bp, borderWidth));
        this.linkTo((BComponent)slider, (Slot)BNanoDaySlider.clearWholeWeek, (Slot)clearWholeWeek);
        this.linkTo((BComponent)slider, (Slot)BNanoDaySlider.applyToWeekDays, (Slot)applyToWeekDays);
        this.linkTo((BComponent)slider, (Slot)BNanoDaySlider.applyToWholeWeek, (Slot)applyToWholeWeek);
        this.linkTo((BComponent)slider, (Slot)BNanoDaySlider.modified, (Slot)sliderModified);
        this.linkTo((BComponent)slider, (Slot)BNanoDaySlider.schRemoved, (Slot)sliderModified);
        this.linkTo((BComponent)slider, (Slot)BNanoDaySlider.schSelected, (Slot)sliderSelected);
    }

    private BWidget makeColumn(BLabel label, BWidget body, int borderWidth) {
        BEdgePane ep = new BEdgePane();
        if (label != null) {
            ep.setTop((BWidget)label);
        }
        ep.setCenter(body);
        return new BBorderPane((BWidget)ep, 0.0, 0.0, 0.0, (double)borderWidth);
    }

    public BNanoAbstractScheduleView getNanoView() {
        try {
            BComplex parent = this.getParent();
            while (!(parent instanceof BNanoAbstractScheduleView)) {
                parent = parent.getParent();
            }
            return (BNanoAbstractScheduleView)parent;
        }
        catch (Exception e) {
            return null;
        }
    }
}

