/*
 * Decompiled with CFR 0.152.
 */
package sedona;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import sedona.Buf;
import sedona.Kit;
import sedona.KitPart;
import sedona.Type;
import sedona.manifest.KitManifest;
import sedona.manifest.ManifestDb;
import sedona.util.Log;
import sedona.util.TextUtil;
import sedona.xml.XElem;
import sedona.xml.XException;
import sedona.xml.XWriter;

public class Schema {
    public static final Log log = new Log("schema");
    private static HashMap cache = new HashMap();
    public final String key;
    public final Kit[] kits;
    final HashMap kitsByName;

    public static Schema load(KitPart[] kitPartArray) throws Exception {
        Schema.sortKits(kitPartArray);
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < kitPartArray.length) {
            stringBuffer.append(kitPartArray[n]).append(';');
            ++n;
        }
        String string = stringBuffer.substring(0, stringBuffer.length() - 1);
        Schema schema = (Schema)cache.get(string);
        if (schema != null) {
            return schema;
        }
        log.debug("Loading... [" + string + ']');
        schema = new Schema(string, new Kit[kitPartArray.length]);
        ArrayList<KitPart> arrayList = new ArrayList<KitPart>();
        int n2 = 0;
        while (n2 < kitPartArray.length) {
            KitPart kitPart = kitPartArray[n2];
            KitManifest kitManifest = ManifestDb.load(kitPart);
            if (kitManifest == null) {
                arrayList.add(kitPart);
            } else {
                Kit kit;
                if (schema.kitsByName.get(kitManifest.name) != null) {
                    throw new Exception("Duplicate kit name: " + kitManifest.name);
                }
                schema.kits[n2] = kit = new Kit(schema, n2, kitManifest);
                schema.kitsByName.put(kit.name, kit);
            }
            ++n2;
        }
        if (arrayList.size() > 0) {
            throw new MissingKitManifestException(arrayList.toArray(new KitPart[arrayList.size()]));
        }
        schema.resolve();
        cache.put(string, schema);
        return schema;
    }

    public static void sortKits(Object[] objectArray) {
        try {
            final Field field = objectArray[0].getClass().getField("name");
            Arrays.sort(objectArray, new Comparator(){

                public final int compare(Object object, Object object2) {
                    try {
                        String string = (String)field.get(object);
                        String string2 = (String)field.get(object2);
                        if (string.equals("sys")) {
                            return -1;
                        }
                        if (string2.equals("sys")) {
                            return 1;
                        }
                        return string.compareTo(string2);
                    }
                    catch (Exception exception) {
                        throw new RuntimeException(exception.toString());
                    }
                }
            });
            if (!field.get(objectArray[0]).equals("sys")) {
                throw new IllegalStateException("sys kit must be in every schema");
            }
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.toString());
        }
    }

    public Kit kit(int n) {
        boolean bl = false;
        if (n >= 0) {
            bl = true;
        }
        boolean bl2 = false;
        if (n < this.kits.length) {
            bl2 = true;
        }
        if (bl & bl2) {
            return this.kits[n];
        }
        return null;
    }

    public Kit kit(String string) {
        return (Kit)this.kitsByName.get(string);
    }

    public Type type(String string) {
        int n = string.indexOf(58);
        if (n < 0 || string.charAt(n + 1) != ':') {
            Type type = this.type("sys::" + string);
            if (type != null) {
                return type;
            }
            throw new IllegalStateException("Invalid type signature: " + string);
        }
        String string2 = string.substring(0, n);
        String string3 = string.substring(n + 2);
        Kit kit = this.kit(string2);
        if (kit == null) {
            return null;
        }
        return kit.type(string3);
    }

    public Type[] allConcreteTypes(Type type) {
        ArrayList<Type> arrayList = new ArrayList<Type>();
        int n = 0;
        while (n < this.kits.length) {
            Type[] typeArray = this.kits[n].types;
            int n2 = 0;
            while (n2 < typeArray.length) {
                if (!typeArray[n2].isAbstract() && typeArray[n2].is(type)) {
                    arrayList.add(typeArray[n2]);
                }
                ++n2;
            }
            ++n;
        }
        Object[] objectArray = arrayList.toArray(new Type[arrayList.size()]);
        Arrays.sort(objectArray);
        return objectArray;
    }

    public boolean equivalent(Schema schema) {
        return this.key.equals(schema.key);
    }

    public String toString() {
        return this.key;
    }

    void resolve() throws Exception {
        int n;
        Kit kit;
        int n2 = 0;
        while (n2 < this.kits.length) {
            kit = this.kits[n2];
            n = 0;
            while (n < kit.types.length) {
                kit.types[n].resolveBase();
                ++n;
            }
            ++n2;
        }
        n2 = 0;
        while (n2 < this.kits.length) {
            kit = this.kits[n2];
            n = 0;
            while (n < kit.types.length) {
                kit.types[n].resolveSlots();
                ++n;
            }
            ++n2;
        }
    }

    public void encodeXml(XWriter xWriter) {
        this.encodeXml(xWriter, false);
    }

    public void encodeXml(XWriter xWriter, boolean bl) {
        xWriter.write("<schema>\n");
        int n = 0;
        while (n < this.kits.length) {
            Kit kit = this.kits[n];
            xWriter.w("  <kit ").attr("name", kit.name).w(" ");
            if (!bl) {
                xWriter.attr("checksum", TextUtil.intToHexString(kit.checksum));
            }
            xWriter.w(" />").nl();
            ++n;
        }
        xWriter.write("</schema>\n");
    }

    public static Schema decodeXml(XElem xElem) throws Exception {
        XElem[] xElemArray = xElem.elems("kit");
        KitPart[] kitPartArray = new KitPart[xElemArray.length];
        int n = 0;
        while (n < kitPartArray.length) {
            KitPart kitPart;
            String string = xElemArray[n].get("name");
            int n2 = (int)Long.parseLong(xElemArray[n].get("checksum", "0"), 16);
            if (n2 == 0) {
                kitPart = KitPart.forLocalKit(string);
                if (kitPart == null) {
                    throw new XException("Local kit '" + string + "' not found, must use explicit checksum", xElemArray[n]);
                }
            } else {
                kitPart = new KitPart(string, n2);
            }
            kitPartArray[n] = kitPart;
            ++n;
        }
        return Schema.load(kitPartArray);
    }

    public void encodeBinary(Buf buf) {
        buf.u1(this.kits.length);
        int n = 0;
        while (n < this.kits.length) {
            Kit kit = this.kits[n];
            buf.str(kit.name);
            buf.i4(kit.checksum);
            ++n;
        }
    }

    public static Schema decodeBinary(Buf buf) throws Exception {
        KitPart[] kitPartArray = new KitPart[buf.u1()];
        int n = 0;
        while (n < kitPartArray.length) {
            kitPartArray[n] = new KitPart(buf.str(), buf.i4());
            ++n;
        }
        return Schema.load(kitPartArray);
    }

    private Schema(String string, Kit[] kitArray) {
        this.key = string;
        this.kits = kitArray;
        this.kitsByName = new HashMap(kitArray.length * 3);
    }

    public static class MissingKitManifestException
    extends Exception {
        public KitPart[] parts;

        public String getMessage() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Missing kit manifest(s): ");
            int n = 0;
            while (n < this.parts.length) {
                if (n > 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(this.parts[n]);
                ++n;
            }
            return stringBuffer.append('.').toString();
        }

        public MissingKitManifestException(KitPart kitPart) {
            this(new KitPart[]{kitPart});
        }

        public MissingKitManifestException(KitPart[] kitPartArray) {
            this.parts = kitPartArray;
        }
    }
}

