/*
 * Decompiled with CFR 0.152.
 */
package sedona.dasp;

import java.util.Properties;
import sedona.dasp.DaspMsg;
import sedona.dasp.DaspSession;
import sedona.dasp.DaspSocket;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
final class ReceiveWindow {
    private static int verifies;
    static final int max = 31;
    private final DaspSession session;
    private int seqNum;
    private int seqMore;
    private boolean acked;

    final synchronized boolean unacked() {
        return this.acked ^ true;
    }

    final synchronized void setAckHeaders(DaspMsg daspMsg) {
        int n = daspMsg.payload.length;
        if (n + 8 <= this.session.idealMax) {
            daspMsg.ack = this.seqNum;
            this.acked = true;
            if (this.seqMore > 1 && n + 11 <= this.session.idealMax) {
                daspMsg.ackMore = ReceiveWindow.toAckMore(this.seqMore, this.session.idealMax - n - 10);
            }
        }
    }

    static final byte[] toAckMore(int n, int n2) {
        if (n <= 255 || n2 <= 1) {
            return new byte[]{(byte)n};
        }
        if (n <= (char)-1 || n2 <= 2) {
            return new byte[]{(byte)(n >>> 8), (byte)n};
        }
        if (n <= 0xFFFFFF || n2 <= 3) {
            return new byte[]{(byte)(n >>> 16), (byte)(n >>> 8), (byte)n};
        }
        return new byte[]{(byte)(n >>> 24), (byte)(n >>> 16), (byte)(n >>> 8), (byte)n};
    }

    final synchronized void init(int n) {
        if (this.seqNum >= 0) {
            throw new IllegalStateException();
        }
        this.seqNum = n - 1 & (char)-1;
        this.seqMore = 1;
        this.acked = false;
    }

    final synchronized boolean receive(int n) {
        if (n < 0 || n > (char)-1) {
            throw new IllegalStateException("" + n);
        }
        if (this.seqNum < 0) {
            throw new IllegalStateException();
        }
        int n2 = this.seqNum;
        int n3 = n2 + 31;
        if (n3 <= (char)-1) {
            if (n <= n2 || n > n3) {
                this.acked = false;
                return false;
            }
        } else if (n <= n2 && n > (n3 -= (char)-1)) {
            this.acked = false;
            return false;
        }
        if (n == this.seqNum + 1 || n == 0 && this.seqNum == (char)-1) {
            do {
                ++this.seqNum;
                this.seqMore = this.seqMore >> 1 & Integer.MAX_VALUE;
            } while ((this.seqMore & 2) != 0);
            this.seqNum &= (char)-1;
            this.seqMore |= 1;
        } else {
            int n4 = 1 << (n - n2 & (char)-1);
            if ((this.seqMore & n4) != 0) {
                return false;
            }
            this.seqMore |= n4;
        }
        this.acked = false;
        return true;
    }

    public static final void main(String[] stringArray) throws Exception {
        long l = System.currentTimeMillis();
        DaspSocket daspSocket = DaspSocket.open(-1, null, 14);
        DaspSession daspSession = new DaspSession(daspSocket.interfaces[0], 0, null, 0, true, new Properties());
        ReceiveWindow receiveWindow = new ReceiveWindow(daspSession);
        receiveWindow.test();
        long l2 = System.currentTimeMillis();
        System.out.println("  ReceiveWindow Success: " + verifies + " verifies [" + (l2 - l) + "ms]");
        daspSocket.close();
    }

    private final void test() {
        int n;
        int n2;
        this.verify(-1, -1);
        this.seqNum = -1;
        this.init(1);
        int n3 = 0;
        int n4 = 1;
        while (n4 <= 70000) {
            n2 = n4 - 1 & (char)-1;
            n3 = n4 & (char)-1;
            n = n4 + 32 & (char)-1;
            this.verify(this.receive(n3), "num=" + n3);
            this.verify(this.receive(n2) ^ true, "prev=" + n2);
            this.verify(this.receive(n) ^ true, "big=" + n);
            this.verify(n3, 1);
            ++n4;
        }
        n4 = 1;
        while (n4 <= 70000) {
            n3 = n4 & (char)-1;
            n2 = n3 + 2 & (char)-1;
            n = n3 + 4 & (char)-1;
            this.seqNum = n3;
            this.seqMore = 1;
            this.verify(this.receive(n2));
            this.verify(n3, 5);
            this.verify(this.receive(n));
            this.verify(n3, 21);
            n3 = n3 + 1 & (char)-1;
            this.verify(this.receive(n3));
            this.verify(n2, 5);
            this.verify(this.receive(n2) ^ true);
            this.verify(this.receive(n) ^ true);
            n3 = n3 + 2 & (char)-1;
            this.verify(this.receive(n3));
            this.verify(n, 1);
            this.verify(this.receive(n2) ^ true);
            this.verify(this.receive(n) ^ true);
            this.verify(this.receive(n3) ^ true);
            ++n4;
        }
        n4 = 1;
        while (n4 <= 70000) {
            this.seqNum = n3 = n4 & (char)-1;
            this.seqMore = 1;
            this.verify(n3, 1);
            n2 = 0;
            n = 31;
            while (n > 1) {
                int n5 = n3 + n & (char)-1;
                this.verify(this.receive(n5));
                this.verify(n3, (n2 |= 1 << n) | 1);
                --n;
            }
            this.verify(this.receive(n3 + 1 & (char)-1));
            this.verify(n3 + 31 & (char)-1, 1);
            ++n4;
        }
    }

    private final void verify(int n, int n2) {
        if (this.seqNum != n) {
            throw new RuntimeException(this.seqNum + " != " + n);
        }
        if (this.seqMore != n2) {
            throw new RuntimeException("0x" + Integer.toHexString(this.seqMore) + " != 0x" + Integer.toHexString(n2));
        }
        ++verifies;
    }

    private final void verify(boolean bl) {
        this.verify(bl, "");
    }

    private final void verify(boolean bl, String string) {
        if (!bl) {
            throw new RuntimeException(string);
        }
        ++verifies;
    }

    private final /* synthetic */ void this() {
        this.seqNum = -1;
        this.seqMore = -1;
    }

    ReceiveWindow(DaspSession daspSession) {
        this.this();
        this.session = daspSession;
    }
}

