/*
 * Decompiled with CFR 0.152.
 */
package sedona.util;

import java.util.Arrays;
import java.util.StringTokenizer;

public class Version
implements Comparable {
    public static Version NULL = new Version("0");
    private int[] versions;

    public static Version parse(String string) {
        if (string == null) {
            return null;
        }
        return new Version(string);
    }

    public int major() {
        if (this.versions.length < 1) {
            return -1;
        }
        return this.versions[0];
    }

    public int minor() {
        if (this.versions.length < 2) {
            return -1;
        }
        return this.versions[1];
    }

    public int build() {
        if (this.versions.length < 3) {
            return -1;
        }
        return this.versions[2];
    }

    public int patch() {
        if (this.versions.length < 4) {
            return -1;
        }
        return this.versions[3];
    }

    public int get(int n) {
        return this.versions[n];
    }

    public int size() {
        return this.versions.length;
    }

    public boolean isNull() {
        if (this.versions.length == 1) {
            boolean bl = false;
            if (this.versions[0] == 0) {
                bl = true;
            }
            return bl;
        }
        return false;
    }

    public int compareTo(Object object) {
        Version version = (Version)object;
        int n = this.versions.length;
        int n2 = version.versions.length;
        int n3 = 0;
        while (n3 < n && n3 < n2) {
            if (this.versions[n3] > version.versions[n3]) {
                return 1;
            }
            if (this.versions[n3] < version.versions[n3]) {
                return -1;
            }
            ++n3;
        }
        if (n == n2) {
            return 0;
        }
        if (n > n2) {
            return 1;
        }
        return -1;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + this.toString().hashCode();
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Version version = (Version)object;
        return Arrays.equals(this.versions, version.versions);
    }

    public String toString() {
        return this.toString(this.versions.length);
    }

    public String toString(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        while (n2 < n && n2 < this.versions.length) {
            if (n2 > 0) {
                stringBuffer.append('.');
            }
            stringBuffer.append(this.versions[n2]);
            ++n2;
        }
        return stringBuffer.toString();
    }

    public Version(String string) {
        try {
            if (string.length() == 0) {
                throw new IllegalArgumentException();
            }
            int[] nArray = new int[16];
            int n = 0;
            StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
            while (stringTokenizer.hasMoreTokens()) {
                int n2 = Integer.parseInt(stringTokenizer.nextToken());
                if (n2 < 0) {
                    throw new IllegalArgumentException();
                }
                nArray[n++] = n2;
            }
            this.versions = new int[n];
            System.arraycopy(nArray, 0, this.versions, 0, n);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Invalid version string \"" + string + '\"');
        }
    }

    public Version(int[] nArray, int n) {
        if (n == 0) {
            throw new IllegalArgumentException("Cannot create empty version: n = " + n);
        }
        this.versions = new int[n];
        System.arraycopy(nArray, 0, this.versions, 0, n);
    }
}

