/*
 * Decompiled with CFR 0.152.
 */
package com.gc5.ui.history;

import com.gc5.ui.history.FileItem;
import com.gc5.ui.history.FileItemModel;
import com.tridium.nsedona.sys.BSedonaComponent;
import com.tridium.workbench.transfer.TransferUtil;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.space.Mark;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.HyperlinkInfo;
import javax.baja.ui.commands.ReflectCommand;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BValign;
import javax.baja.ui.event.BInputEvent;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.list.BList;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BConstrainedPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.table.BTable;
import javax.baja.ui.table.TableController;
import javax.baja.ui.table.TableModel;
import javax.baja.ui.table.TableSelection;
import javax.baja.ui.util.BTitlePane;
import javax.baja.util.TextUtil;
import javax.baja.workbench.view.BWbComponentView;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BHistoryManager
extends BWbComponentView {
    public static final Type TYPE;
    BSedonaComponent service;
    FileItemModel model;
    BTable table;
    Command layout;
    Command interval;
    Command deadband;
    Command rename;
    Command clear;
    boolean editConfirmed;
    static /* synthetic */ Class class$com$gc5$ui$history$BHistoryManager;

    public Type getType() {
        return TYPE;
    }

    protected void doLoadValue(BObject bObject, Context context) throws Exception {
        this.service = (BSedonaComponent)bObject;
        this.model = new FileItemModel().load(this.service);
        this.table.setModel((TableModel)this.model);
        this.model.selection = new TableSelection(){

            public final void updateTable() {
                super.updateTable();
            }
        };
        this.table.setSelection(this.model.selection);
        this.table.setController(new TableController(){

            protected final void cellDoubleClicked(BMouseEvent bMouseEvent, int n, int n2) {
                BHistoryManager.this.tableDoubleClicked(bMouseEvent, n, n2);
            }
        });
        this.table.relayout();
        this.registerForComponentEvents((BComponent)this.service, 1);
        this.loadHistoryManager();
    }

    public void handleComponentEvent(BComponentEvent bComponentEvent) {
        if (bComponentEvent.getSourceComponent() instanceof BComponent) {
            BComponent bComponent = (BComponent)this.getCurrentValue();
            this.service = (BSedonaComponent)bComponent;
            this.model.load(this.service);
            this.loadHistoryManager();
        }
    }

    protected void loadHistoryManager() {
        this.model.updateTable(true);
    }

    public void tableDoubleClicked(BMouseEvent bMouseEvent, int n, int n2) {
        FileItem fileItem = this.model.get(n);
        if (fileItem != null) {
            this.getWbShell().hyperlink(new HyperlinkInfo(fileItem.c.getNavOrd(), (BInputEvent)bMouseEvent));
        }
    }

    public void select(FileItem fileItem) {
        this.table.getSelection().deselectAll();
        this.table.getSelection().select(this.model.toRow(fileItem));
    }

    public CommandArtifact cmdRename() throws Exception {
        if (!this.confirmEdit()) {
            return null;
        }
        BSedonaComponent[] bSedonaComponentArray = this.model.selectedComponents();
        if (bSedonaComponentArray.length == 0) {
            return null;
        }
        return TransferUtil.rename((BWidget)this, (Mark)new Mark((BObject[])bSedonaComponentArray));
    }

    public void cmdInterval() throws Exception {
        if (!this.confirmEdit()) {
            return;
        }
        FileItem[] fileItemArray = this.model.selected();
        if (fileItemArray.length == 0) {
            BDialog.message((BWidget)this, (Object)"Please first select the Interval based Histories you wish to edit.");
            return;
        }
        BGridPane bGridPane = new BGridPane();
        bGridPane.setValign(BValign.top);
        bGridPane.setColumnCount(2);
        bGridPane.add(null, (BValue)new BLabel("Interval"));
        BTextField bTextField = new BTextField(Integer.toString(15));
        bGridPane.add(null, (BValue)bTextField);
        BList bList = new BList();
        int n = 0;
        while (n < fileItemArray.length) {
            bList.addItem(fileItemArray[n].icon, (Object)fileItemArray[n].name);
            ++n;
        }
        BConstrainedPane bConstrainedPane = new BConstrainedPane((BWidget)bList);
        bConstrainedPane.setMinWidth(100.0);
        bConstrainedPane.setMaxHeight(400.0);
        BEdgePane bEdgePane = new BEdgePane();
        bEdgePane.setLeft((BWidget)new BBorderPane((BWidget)bGridPane));
        bEdgePane.setCenter((BWidget)bConstrainedPane);
        int n2 = BDialog.open((BWidget)this, (String)this.layout.getLabel(), (Object)bEdgePane, (int)3);
        if (n2 != 1) {
            return;
        }
        int n3 = BHistoryManager.parseBytes(bTextField.getText());
        int n4 = 0;
        while (n4 < fileItemArray.length) {
            BSedonaComponent bSedonaComponent = fileItemArray[n4].c;
            bSedonaComponent.setInt(bSedonaComponent.getProperty("interval"), n3);
            ++n4;
        }
        this.service.invoke(this.service.getAction("validateAll"), null);
    }

    public void cmdDeadband() throws Exception {
        if (!this.confirmEdit()) {
            return;
        }
        FileItem[] fileItemArray = this.model.selected();
        if (fileItemArray.length == 0) {
            BDialog.message((BWidget)this, (Object)"Please first select the Deadband based Histories you wish to edit.");
            return;
        }
        BGridPane bGridPane = new BGridPane();
        bGridPane.setValign(BValign.top);
        bGridPane.setColumnCount(2);
        bGridPane.add(null, (BValue)new BLabel("Deadband"));
        BTextField bTextField = new BTextField(Float.toString(1.0f));
        bGridPane.add(null, (BValue)bTextField);
        BList bList = new BList();
        int n = 0;
        while (n < fileItemArray.length) {
            bList.addItem(fileItemArray[n].icon, (Object)fileItemArray[n].name);
            ++n;
        }
        BConstrainedPane bConstrainedPane = new BConstrainedPane((BWidget)bList);
        bConstrainedPane.setMinWidth(100.0);
        bConstrainedPane.setMaxHeight(400.0);
        BEdgePane bEdgePane = new BEdgePane();
        bEdgePane.setLeft((BWidget)new BBorderPane((BWidget)bGridPane));
        bEdgePane.setCenter((BWidget)bConstrainedPane);
        int n2 = BDialog.open((BWidget)this, (String)this.layout.getLabel(), (Object)bEdgePane, (int)3);
        if (n2 != 1) {
            return;
        }
        int n3 = 0;
        while (n3 < fileItemArray.length) {
            BSedonaComponent bSedonaComponent = fileItemArray[n3].c;
            if (bSedonaComponent.s().type.qname.equals("iSMA_controlApi::IntegerCov") || bSedonaComponent.s().type.qname.equals("iSMA_controlApi::IntegerCovInterval")) {
                bSedonaComponent.setInt(bSedonaComponent.getProperty("deadband"), (int)Float.parseFloat(bTextField.getText()));
            } else if (bSedonaComponent.s().type.qname.equals("iSMA_controlApi::NumericCov") || bSedonaComponent.s().type.qname.equals("iSMA_controlApi::NumericCovInterval")) {
                bSedonaComponent.setFloat(bSedonaComponent.getProperty("deadband"), Float.parseFloat(bTextField.getText()));
            } else {
                bSedonaComponent.setFloat(bSedonaComponent.getProperty("deadband"), 0.0f);
            }
            ++n3;
        }
        this.service.invoke(this.service.getAction("validateAll"), null);
    }

    public void cmdLayout() {
        if (!this.confirmEdit()) {
            return;
        }
        FileItem[] fileItemArray = this.model.selected();
        if (fileItemArray.length == 0) {
            BDialog.message((BWidget)this, (Object)"Please first select the Histories you wish to edit the layout.");
            return;
        }
        int n = 0;
        int n2 = 0;
        while (n2 < this.model.size()) {
            n = Math.max(n, this.model.get(n2).end());
            ++n2;
        }
        BGridPane bGridPane = new BGridPane();
        bGridPane.setValign(BValign.top);
        bGridPane.setColumnCount(2);
        bGridPane.add(null, (BValue)new BLabel("Starting Offset"));
        BTextField bTextField = new BTextField(Integer.toHexString(n), 16);
        bGridPane.add(null, (BValue)bTextField);
        bGridPane.add(null, (BValue)new BLabel("Size for Histories"));
        BTextField bTextField2 = new BTextField("1KB", 16);
        bGridPane.add(null, (BValue)bTextField2);
        BList bList = new BList();
        int n3 = 0;
        while (n3 < fileItemArray.length) {
            bList.addItem(fileItemArray[n3].icon, (Object)fileItemArray[n3].name);
            ++n3;
        }
        BConstrainedPane bConstrainedPane = new BConstrainedPane((BWidget)bList);
        bConstrainedPane.setMinWidth(100.0);
        bConstrainedPane.setMaxHeight(400.0);
        BEdgePane bEdgePane = new BEdgePane();
        bEdgePane.setLeft((BWidget)new BBorderPane((BWidget)bGridPane));
        bEdgePane.setCenter((BWidget)bConstrainedPane);
        int n4 = BDialog.open((BWidget)this, (String)this.layout.getLabel(), (Object)bEdgePane, (int)3);
        if (n4 != 1) {
            return;
        }
        int n5 = BHistoryManager.parseBytes(bTextField.getText());
        int n6 = BHistoryManager.parseBytes(bTextField2.getText());
        int n7 = 0;
        while (n7 < fileItemArray.length) {
            BSedonaComponent bSedonaComponent = fileItemArray[n7].c;
            bSedonaComponent.setInt(bSedonaComponent.getProperty("resvOffset"), n5);
            bSedonaComponent.setInt(bSedonaComponent.getProperty("resvSize"), n6);
            n5 += n6;
            ++n7;
        }
        this.service.invoke(this.service.getAction("validateAll"), null);
    }

    public void cmdClear() {
        FileItem[] fileItemArray = this.model.selected();
        if (fileItemArray.length == 0) {
            BDialog.message((BWidget)this, (Object)"Please first select the Histories you wish to clear.");
            return;
        }
        int n = BDialog.confirm((BWidget)this, (Object)"Clear the records of these Histories?");
        if (n != 4) {
            return;
        }
        int n2 = 0;
        while (n2 < fileItemArray.length) {
            BSedonaComponent bSedonaComponent = fileItemArray[n2].c;
            Action action = bSedonaComponent.getAction("clear");
            if (action != null) {
                bSedonaComponent.invoke(action, null);
            }
            ++n2;
        }
    }

    boolean confirmEdit() {
        if (this.editConfirmed) {
            return true;
        }
        String string = "Are you sure you wish to enter edit mode?\nChanges to histories will overwrite existing data!";
        int n = BDialog.confirm((BWidget)this, (String)BDialog.TITLE_CONFIRM, (Object)string, (int)3);
        boolean bl = false;
        if (n == 1) {
            bl = true;
        }
        this.editConfirmed = bl;
        return bl;
    }

    static int parseBytes(String string) {
        string = TextUtil.toLowerCase((String)string.trim());
        int n = 1;
        if (string.endsWith("kb")) {
            string = string.substring(0, string.length() - 2).trim();
            n = 1024;
        }
        if (string.endsWith("mb")) {
            string = string.substring(0, string.length() - 2).trim();
            n = 0x100000;
        }
        if (string.endsWith("gb")) {
            string = string.substring(0, string.length() - 2).trim();
            n = 0x40000000;
        }
        return Integer.parseInt(string) * n;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.layout = new ReflectCommand((BWidget)this, "Layout", BImage.make((String)"module://icons/x16/fitHeight.png"), "cmdLayout");
        this.interval = new ReflectCommand((BWidget)this, "Interval", BImage.make((String)"module://icons/x16/hourGlass.png"), "cmdInterval");
        this.deadband = new ReflectCommand((BWidget)this, "Deadband", BImage.make((String)"module://icons/x16/r2/ratchet.png"), "cmdDeadband");
        this.rename = new ReflectCommand((BWidget)this, "Rename", BImage.make((String)"module://icons/x16/rename.png"), "cmdRename");
        this.clear = new ReflectCommand((BWidget)this, "Clear", BImage.make((String)"module://icons/x16/eraser.png"), "cmdClear");
        this.editConfirmed = false;
    }

    public BHistoryManager() {
        this.this();
        BGridPane bGridPane = new BGridPane();
        bGridPane.setColumnCount(5);
        bGridPane.setUniformColumnWidth(true);
        bGridPane.setColumnAlign(BHalign.fill);
        bGridPane.add(null, (BValue)new BButton(this.rename));
        bGridPane.add(null, (BValue)new BButton(this.interval));
        bGridPane.add(null, (BValue)new BButton(this.deadband));
        bGridPane.add(null, (BValue)new BButton(this.layout));
        bGridPane.add(null, (BValue)new BButton(this.clear));
        BEdgePane bEdgePane = new BEdgePane();
        this.table = new BTable();
        bEdgePane.setCenter((BWidget)BTitlePane.makePane((String)"", (BTable)this.table, (String)"objects"));
        bEdgePane.setBottom((BWidget)new BBorderPane((BWidget)bGridPane, BInsets.make((double)5, (double)0.0, (double)0.0, (double)0.0)));
        this.setContent((BWidget)bEdgePane);
        this.autoRegisterForComponentEvents = false;
    }

    static {
        Class clazz = class$com$gc5$ui$history$BHistoryManager;
        if (clazz == null) {
            clazz = class$com$gc5$ui$history$BHistoryManager = BHistoryManager.class("[Lcom.gc5.ui.history.BHistoryManager;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

