/*
 * Decompiled with CFR 0.152.
 */
package com.gc5.alarm;

import com.gc5.BIsmaSoxDevice;
import com.gc5.comm.SoxClient;
import com.gc5.comm.SoxComponent;
import com.gc5.util.TextUtil;
import com.gc5.util.TimeUtil;
import java.io.IOException;
import javax.baja.alarm.AlarmSupport;
import javax.baja.alarm.BAckState;
import javax.baja.alarm.BAlarmClass;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.alarm.BAlarmService;
import javax.baja.alarm.BIAlarmSource;
import javax.baja.alarm.BSourceState;
import javax.baja.collection.BICollection;
import javax.baja.data.BIDataValue;
import javax.baja.driver.alarm.BAlarmDeviceExt;
import javax.baja.naming.BOrd;
import javax.baja.naming.BOrdList;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Cursor;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.timezone.BTimeZone;
import javax.baja.timezone.TimeZoneDatabase;
import javax.baja.util.Array;
import sedona.Buf;
import sedona.Schema;
import sedona.Slot;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BIsmaSoxAlarmDeviceExt
extends BAlarmDeviceExt
implements BIAlarmSource {
    public static final Property enabled = BIsmaSoxAlarmDeviceExt.newProperty((int)0, (boolean)false, null);
    public static final Property alarmClass = BIsmaSoxAlarmDeviceExt.newProperty((int)0, (String)"Default Alarm Class", (BFacets)BFacets.make((String)"fieldEditor", (BIDataValue)BString.make((String)"alarm:AlarmClassFE")));
    public static final Property alarmCount = BIsmaSoxAlarmDeviceExt.newProperty((int)5, (int)0, null);
    public static final Property alarmId = BIsmaSoxAlarmDeviceExt.newProperty((int)5, (int)0, null);
    public static final Property lastReceiveTime = BIsmaSoxAlarmDeviceExt.newProperty((int)9, (BValue)BAbsTime.NULL, (BFacets)BFacets.make((String)"showSeconds", (BIDataValue)BBoolean.TRUE));
    public static final Property lastAlarmTime = BIsmaSoxAlarmDeviceExt.newProperty((int)9, (BValue)BAbsTime.NULL, (BFacets)BFacets.make((String)"showSeconds", (BIDataValue)BBoolean.TRUE));
    public static final Type TYPE;
    public static BIcon icon;
    private SoxClient client;
    Object syncObj;
    boolean executeInProgress;
    boolean alarmSubscribed;
    private AlarmSupport alarmSupport;
    BAlarmClass alarmCls;
    BAlarmService alarmService;
    String pointName;
    int lastAlarmCount;
    SoxComponent alarm;
    SoxComponent alarmComp;
    boolean active;
    static /* synthetic */ Class class$com$gc5$alarm$BIsmaSoxAlarmDeviceExt;
    static /* synthetic */ Class class$com$gc5$alarm$BIsmaSoxAlarmDeviceExt$AlarmRec;

    public boolean getEnabled() {
        return this.getBoolean(enabled);
    }

    public void setEnabled(boolean bl) {
        this.setBoolean(enabled, bl, null);
    }

    public String getAlarmClass() {
        return this.getString(alarmClass);
    }

    public void setAlarmClass(String string) {
        this.setString(alarmClass, string, null);
    }

    public int getAlarmCount() {
        return this.getInt(alarmCount);
    }

    public void setAlarmCount(int n) {
        this.setInt(alarmCount, n, null);
    }

    public int getAlarmId() {
        return this.getInt(alarmId);
    }

    public void setAlarmId(int n) {
        this.setInt(alarmId, n, null);
    }

    public BAbsTime getLastReceiveTime() {
        return (BAbsTime)this.get(lastReceiveTime);
    }

    public void setLastReceiveTime(BAbsTime bAbsTime) {
        this.set(lastReceiveTime, (BValue)bAbsTime, null);
    }

    public BAbsTime getLastAlarmTime() {
        return (BAbsTime)this.get(lastAlarmTime);
    }

    public void setLastAlarmTime(BAbsTime bAbsTime) {
        this.set(lastAlarmTime, (BValue)bAbsTime, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BIcon getIcon() {
        return icon;
    }

    public boolean isParentLegal(BComponent bComponent) {
        return bComponent instanceof BIsmaSoxDevice;
    }

    public final BIsmaSoxDevice getSoxDevice() {
        return (BIsmaSoxDevice)this.getDevice();
    }

    public boolean isActive() {
        return this.active;
    }

    public void started() throws Exception {
        super.started();
        this.alarmSupport = new AlarmSupport((BIAlarmSource)this, this.getAlarmClass());
        this.lastAlarmCount = this.getAlarmCount();
        this.active = false;
        if (this.getEnabled() && !this.alarmSubscribed) {
            this.subscribeAlarmComponent(true);
        }
        this.getAlarmData();
    }

    public void atSteadyState() throws Exception {
        super.atSteadyState();
        if (this.getEnabled() && !this.alarmSubscribed) {
            this.subscribeAlarmComponent(true);
        }
    }

    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (!this.isRunning()) {
            return;
        }
        if (property == enabled) {
            try {
                if (this.getEnabled()) {
                    if (this.alarmSubscribed) {
                        this.subscribeAlarmComponent(false);
                    }
                    this.subscribeAlarmComponent(true);
                } else {
                    this.subscribeAlarmComponent(false);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if ((property == alarmCount || property == alarmId) && this.getAlarmCount() != this.lastAlarmCount && this.getAlarmId() > 0) {
            this.readAlarm();
            this.lastAlarmCount = this.getAlarmCount();
        }
    }

    public void stopped() throws Exception {
        this.subscribeAlarmComponent(false);
        super.stopped();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void subscribeAlarmComponent(boolean bl) throws Exception {
        boolean bl2 = false;
        BIsmaSoxDevice bIsmaSoxDevice = (BIsmaSoxDevice)this.getDevice();
        if (bIsmaSoxDevice.isDown()) {
            System.out.println("Device is down.");
            return;
        }
        try {
            this.getClient();
            SoxComponent soxComponent = this.client.loadApp();
            this.alarm = this.getAlarmEntry(soxComponent);
            if (bl) {
                this.client.subscribe(this.alarm, 2);
                this.alarmSubscribed = true;
            } else {
                this.setAlarmId(-1);
                this.client.unsubscribe(this.alarm, 2);
                this.alarmSubscribed = false;
            }
        }
        catch (Schema.MissingKitManifestException missingKitManifestException) {
            missingKitManifestException.printStackTrace();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            Object var5_8 = null;
            this.client = null;
            return;
        }
        catch (Throwable throwable) {
            Object var5_9 = null;
            this.client = null;
            throw throwable;
        }
    }

    private final SoxComponent getAlarmEntry(SoxComponent soxComponent) throws Exception {
        SoxComponent[] soxComponentArray = soxComponent.children();
        if (soxComponentArray.length > 0) {
            int n = 0;
            while (n < soxComponentArray.length) {
                if (soxComponentArray[n].type.toString().equalsIgnoreCase("iSMA_controlApi::AlarmFile")) {
                    Slot slot;
                    int n2 = 0;
                    while ((slot = soxComponentArray[n].type.slot(n2++)) != null && !slot.isAction()) {
                        soxComponentArray[n].set(slot, this.client.readProp(soxComponentArray[n], slot));
                    }
                    this.alarmComp = soxComponentArray[n];
                    this.setAlarmId(soxComponentArray[n].id());
                    break;
                }
                this.getAlarmEntry(soxComponentArray[n]);
                ++n;
            }
        }
        return this.alarmComp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void readAlarm() {
        BIsmaSoxDevice bIsmaSoxDevice = (BIsmaSoxDevice)this.getDevice();
        if (bIsmaSoxDevice.isDown() || !this.getEnabled()) {
            ((BIsmaSoxDevice)this.getDevice()).getCommunicator().getLog().message(((BIsmaSoxDevice)this.getDevice()).getName() + " Is Down or disabled.");
            return;
        }
        Object object = this.syncObj;
        synchronized (object) {
            while (this.executeInProgress) {
                try {
                    this.syncObj.wait();
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
                this.executeInProgress = true;
            }
        }
        try {
            try {
                int n = this.getAlarmData();
                switch (n) {
                    case 0: {
                        this.setLastReceiveTime(BAbsTime.now());
                        break;
                    }
                    case 1: {
                        ((BIsmaSoxDevice)this.getDevice()).getCommunicator().getLog().message(((BIsmaSoxDevice)this.getDevice()).getName() + " Is Down or disabled.");
                        break;
                    }
                    case 2: {
                        ((BIsmaSoxDevice)this.getDevice()).getCommunicator().getLog().trace(((BIsmaSoxDevice)this.getDevice()).getName() + " ~ No new alarms.");
                        break;
                    }
                    case 3: {
                        ((BIsmaSoxDevice)this.getDevice()).getCommunicator().getLog().message(((BIsmaSoxDevice)this.getDevice()).getName() + " ~ Alarm Database not found.");
                        break;
                    }
                    default: {
                        ((BIsmaSoxDevice)this.getDevice()).getCommunicator().getLog().message(((BIsmaSoxDevice)this.getDevice()).getName() + " ~ Unable to get the alarms.");
                        break;
                    }
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            Object var3_8 = null;
            bIsmaSoxDevice = null;
        }
        catch (Throwable throwable) {
            Object var3_7 = null;
            bIsmaSoxDevice = null;
            throw throwable;
        }
        object = this.syncObj;
        synchronized (object) {
            this.executeInProgress = false;
            this.syncObj.notify();
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getAlarmData() {
        BIsmaSoxDevice bIsmaSoxDevice = (BIsmaSoxDevice)this.getDevice();
        if (bIsmaSoxDevice.isDown() || !this.getEnabled()) {
            System.out.println("Device is down or alarm feature is not enabled.");
            return 1;
        }
        try {
            try {
                long l;
                Buf buf;
                BTimeZone bTimeZone;
                this.getClient();
                this.alarm = this.client.load(this.getAlarmId());
                if (this.alarm == null || !this.alarm.type.toString().equalsIgnoreCase("iSMA_controlApi::AlarmFile")) {
                    SoxComponent soxComponent = this.client.loadApp();
                    this.alarm = this.getAlarmEntry(soxComponent);
                    if (!this.alarmSubscribed) {
                        this.client.subscribe(this.alarm, 2);
                        this.alarmSubscribed = true;
                    }
                }
                int n = 0;
                while (true) {
                    Slot slot;
                    if ((slot = this.alarm.type.slot(n++)) == null || slot.isAction()) {
                        int n2 = 0;
                        String string = "";
                        bTimeZone = null;
                        if (bIsmaSoxDevice.getTimeSync().getTimeId() > 1) {
                            n2 = bIsmaSoxDevice.getTimeSync().getUtcOffset() * 1000;
                            string = bIsmaSoxDevice.getTimeSync().getTimezone();
                            bTimeZone = TimeZoneDatabase.getTimeZone((String)string);
                        }
                        if (bTimeZone == null || bTimeZone.getUtcOffset() != n2) {
                            System.out.println("Time is null.");
                            bTimeZone = BTimeZone.getLocal();
                        }
                        this.active = true;
                        buf = this.client.readPstoreFile(this.alarm);
                        this.active = false;
                        buf.seek(0);
                        int n3 = buf.u2();
                        if (n3 == 49182) break;
                        throw new IOException("Invalid magic number 0x" + Integer.toHexString(n3));
                    }
                    this.alarm.set(slot, this.client.readProp(this.alarm, slot));
                }
                buf.skipBytes(2);
                int n4 = buf.i4();
                buf.seek(80);
                boolean bl = false;
                long l2 = 0L;
                int n5 = 0;
                Class clazz = class$com$gc5$alarm$BIsmaSoxAlarmDeviceExt$AlarmRec;
                if (clazz == null) {
                    clazz = class$com$gc5$alarm$BIsmaSoxAlarmDeviceExt$AlarmRec = BIsmaSoxAlarmDeviceExt.class("[Lcom.gc5.alarm.BIsmaSoxAlarmDeviceExt$AlarmRec;", false);
                }
                Array array = new Array(clazz);
                int n6 = 0;
                while (buf.available() >= 80 && (l = buf.i8()) > 0L) {
                    long l3 = buf.i8();
                    long l4 = buf.i8();
                    int n7 = buf.i4();
                    String string = "";
                    String string2 = "";
                    int n8 = 3;
                    String string3 = "";
                    SoxComponent soxComponent = this.client.load(n7);
                    if (soxComponent == null) {
                        string = "N/A";
                        this.pointName = "N/A";
                        string2 = "N/A";
                        n8 = 3;
                        string3 = "N/A";
                    } else {
                        this.pointName = string = soxComponent.parent().name();
                        string2 = soxComponent.parent().path();
                        n8 = soxComponent.getInt("alarmClass");
                        string3 = soxComponent.type.name;
                    }
                    n5 = string3.equals("BooleanChangeOfStateAlarmExt") ? 0 : (string3.equals("OutOfRangeAlarmExt") ? 1 : 2);
                    int n9 = buf.i4();
                    int n10 = buf.u2();
                    int n11 = buf.u2();
                    int n12 = buf.u2();
                    byte[] byArray = new byte[n12];
                    buf.read(byArray, 0, n12);
                    buf.seek((n6 + 1) * 80 + 80);
                    array.add((Object)new AlarmRec(l, l3, l4, string, string2, n5, n9, n8, n10, n11, n12, byArray));
                    ++n6;
                }
                Class clazz2 = class$com$gc5$alarm$BIsmaSoxAlarmDeviceExt$AlarmRec;
                if (clazz2 == null) {
                    clazz2 = class$com$gc5$alarm$BIsmaSoxAlarmDeviceExt$AlarmRec = BIsmaSoxAlarmDeviceExt.class("[Lcom.gc5.alarm.BIsmaSoxAlarmDeviceExt$AlarmRec;", false);
                }
                Array array2 = new Array(clazz2);
                array2.addAll(array.copy());
                boolean bl2 = false;
                long l5 = 0L;
                int n13 = 0;
                while (n13 < array2.size()) {
                    AlarmRec alarmRec = (AlarmRec)array2.get(n13);
                    l5 = alarmRec.nanos;
                    if (BAbsTime.make((long)alarmRec.toOffNormalNanos).isAfter(this.getLastAlarmTime()) || BAbsTime.make((long)alarmRec.toNormalNanos).isAfter(this.getLastAlarmTime())) {
                        switch (alarmRec.alarmState) {
                            case 3: {
                                this.raiseAlarm(alarmRec.sourcePath, alarmRec.sourceName, BAbsTime.make((long)alarmRec.toOffNormalNanos, (BTimeZone)bTimeZone).encodeToString(), alarmRec.message, alarmRec.offNormalValue, alarmRec.alarmClass, false);
                                this.setLastAlarmTime(BAbsTime.make((long)alarmRec.nanos, (BTimeZone)bTimeZone));
                                break;
                            }
                            case 1: 
                            case 2: 
                            case 4: {
                                this.raiseAlarm(alarmRec.sourcePath, alarmRec.sourceName, BAbsTime.make((long)alarmRec.toNormalNanos, (BTimeZone)bTimeZone).encodeToString(), alarmRec.message, alarmRec.offNormalValue, alarmRec.alarmClass, true);
                                this.setLastAlarmTime(BAbsTime.make((long)alarmRec.nanos, (BTimeZone)bTimeZone));
                                break;
                            }
                        }
                    }
                    ++n13;
                }
            }
            catch (Exception exception) {
                this.active = false;
                exception.printStackTrace();
            }
        }
        catch (Throwable throwable) {
            Object var3_37 = null;
            this.active = false;
            this.client = null;
            throw throwable;
        }
        {
            Object var3_38 = null;
            this.active = false;
            this.client = null;
            return 0;
        }
    }

    public boolean raiseAlarm(String string, String string2, String string3, String string4, String string5, String string6, boolean bl) {
        try {
            if (!bl) {
                this.toNormal(BFacets.make((BFacets)BFacets.make((String)"source", (String)string), (BFacets)BFacets.make((BFacets)BFacets.make((String)"sourceName", (String)string2), (BFacets)BFacets.make((BFacets)BFacets.make((String)"timestamp", (String)string3), (BFacets)BFacets.make((BFacets)BFacets.make((String)"msgText", (String)string4), (BFacets)BFacets.make((BFacets)BFacets.make((String)"offnormalValue", (String)string5), (BFacets)BFacets.make((String)"priority", (String)string6)))))));
                return true;
            }
            this.alarmSupport.setAlarmClass(this.getAlarmClass());
            this.alarmSupport.newOffnormalAlarm(BFacets.make((BFacets)BFacets.make((String)"source", (String)string), (BFacets)BFacets.make((BFacets)BFacets.make((String)"sourceName", (String)string2), (BFacets)BFacets.make((BFacets)BFacets.make((String)"timestamp", (String)string3), (BFacets)BFacets.make((BFacets)BFacets.make((String)"msgText", (String)string4), (BFacets)BFacets.make((BFacets)BFacets.make((String)"offnormalValue", (String)string5), (BFacets)BFacets.make((String)"priority", (String)string6)))))));
            return true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    public BAlarmRecord toNormal(BFacets bFacets) throws Exception {
        BAlarmRecord bAlarmRecord = new BAlarmRecord();
        if (this.getAlarmService() == null) {
            return new BAlarmRecord();
        }
        boolean bl = this.alarmCls.getAckRequired().isToNormal();
        StringBuffer stringBuffer = new StringBuffer("alarm:|bql:select * where ");
        stringBuffer.append("alarmData.sourceName =  '" + this.pointName + "' and sourceState != alarm:SourceState.normal");
        BOrd bOrd = BOrd.make((String)stringBuffer.toString());
        Cursor cursor = ((BICollection)bOrd.resolve((BObject)this.alarmService).get()).cursor();
        boolean bl2 = false;
        while (cursor.next()) {
            bl2 = true;
            BAlarmRecord bAlarmRecord2 = (BAlarmRecord)((BValue)cursor.get()).newCopy(true);
            if (bAlarmRecord2.getSourceState() == BSourceState.alert) continue;
            bAlarmRecord2.setSource(this.getSourceOrd());
            bAlarmRecord2.setAlarmClass(this.getAlarmClass());
            bAlarmRecord2.setNormalTime(Clock.time());
            bAlarmRecord2.setSourceState(BSourceState.normal);
            boolean bl3 = false;
            if (bAlarmRecord2.getAckRequired() || bl) {
                bl3 = true;
            }
            bAlarmRecord2.setAckRequired(bl3);
            bAlarmRecord2.setAlarmData(BFacets.make((BFacets)bAlarmRecord2.getAlarmData(), (BFacets)bFacets));
            if (bl) {
                bAlarmRecord2.setAckState(BAckState.unacked);
            }
            if (this.getAlarmService() != null) {
                this.getAlarmService().routeAlarm(bAlarmRecord2);
            }
            bAlarmRecord = bAlarmRecord2;
        }
        if (!bl2) {
            if (bl) {
                bAlarmRecord.setAckState(BAckState.unacked);
            }
            bAlarmRecord.setSource(this.getSourceOrd());
            bAlarmRecord.setAlarmClass(this.getAlarmClass());
            bAlarmRecord.setNormalTime(Clock.time());
            bAlarmRecord.setSourceState(BSourceState.normal);
            bAlarmRecord.setAckRequired(bl);
            bAlarmRecord.setAlarmData(bFacets);
            if (this.getAlarmService() != null) {
                this.getAlarmService().routeAlarm(bAlarmRecord);
            }
        }
        return bAlarmRecord;
    }

    private final BAlarmService getAlarmService() {
        if (this.alarmService == null) {
            try {
                this.alarmService = (BAlarmService)Sys.getService((Type)BAlarmService.TYPE);
                this.alarmCls = this.alarmService.lookupAlarmClass(this.getAlarmClass());
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return null;
            }
        }
        return this.alarmService;
    }

    public BOrdList getSourceOrd() {
        return BOrdList.make((BOrd)this.getNavOrd());
    }

    public BBoolean doAckAlarm(BAlarmRecord bAlarmRecord) throws Exception {
        return BBoolean.make((boolean)true);
    }

    public void doRouteAlarm(BAlarmRecord bAlarmRecord) throws Exception {
        this.readAlarm();
    }

    public BBoolean ackAlarm(BAlarmRecord bAlarmRecord) {
        try {
            this.alarmSupport.ackAlarm(bAlarmRecord);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return BBoolean.make((boolean)true);
    }

    public SoxClient getClient() {
        if (this.client == null) {
            this.client = new SoxClient((BIsmaSoxDevice)this.getDevice());
        }
        return this.client;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.syncObj = new Object();
        this.executeInProgress = false;
        this.alarmSubscribed = false;
        this.alarmService = null;
        this.pointName = "";
        this.lastAlarmCount = 0;
        this.alarm = null;
        this.alarmComp = null;
        this.active = false;
    }

    public BIsmaSoxAlarmDeviceExt() {
        this.this();
    }

    static {
        Class clazz = class$com$gc5$alarm$BIsmaSoxAlarmDeviceExt;
        if (clazz == null) {
            clazz = class$com$gc5$alarm$BIsmaSoxAlarmDeviceExt = BIsmaSoxAlarmDeviceExt.class("[Lcom.gc5.alarm.BIsmaSoxAlarmDeviceExt;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        icon = BIcon.make((String)"module://icons/x16/alarm.png");
    }

    private static class AlarmRec {
        public final long nanos;
        public final long toNormalNanos;
        public final long toOffNormalNanos;
        public final String sourceName;
        public final String sourcePath;
        public final String offNormalValue;
        public final String alarmClass;
        public final int alarmState;
        public final String txState;
        public final String message;

        public AlarmRec(long l, long l2, long l3, String string, String string2, int n, int n2, int n3, int n4, int n5, int n6, byte[] byArray) {
            this.nanos = TimeUtil.epochMillis + l / 1000000L;
            this.toNormalNanos = TimeUtil.epochMillis + l2 / 1000000L;
            this.toOffNormalNanos = TimeUtil.epochMillis + l3 / 1000000L;
            this.sourceName = string;
            this.sourcePath = "/app" + string2;
            switch (n) {
                case 0: {
                    this.offNormalValue = n2 != 0 ? "True" : "False";
                    break;
                }
                case 1: {
                    this.offNormalValue = Float.toString(Float.intBitsToFloat(n2));
                    break;
                }
                default: {
                    this.offNormalValue = "N/A";
                }
            }
            switch (n3) {
                case 0: {
                    this.alarmClass = "15";
                    break;
                }
                case 1: {
                    this.alarmClass = "75";
                    break;
                }
                case 2: {
                    this.alarmClass = "155";
                    break;
                }
                default: {
                    this.alarmClass = "255";
                }
            }
            this.alarmState = n4;
            switch (n5) {
                case 0: {
                    this.txState = "Idle";
                    break;
                }
                case 1: {
                    this.txState = "Unaccepted";
                    break;
                }
                case 2: {
                    this.txState = "Accepted";
                    break;
                }
                case 3: {
                    this.txState = "Completed";
                    break;
                }
                default: {
                    this.txState = "N/A";
                }
            }
            StringBuffer stringBuffer = new StringBuffer("");
            int n7 = 0;
            while (n7 < n6 - 1) {
                stringBuffer.append(TextUtil.byteToChar(byArray[n7] & 0xFF, '?'));
                ++n7;
            }
            this.message = stringBuffer.toString();
        }
    }
}

