/*
 * Decompiled with CFR 0.152.
 */
package com.gc5.comm;

import java.io.IOException;
import sedona.Buf;
import sedona.sox.SoxException;

public class Msg
extends Buf {
    public static Msg prepareRequest(int n) {
        return Msg.prepareRequest(n, 255);
    }

    static Msg prepareRequest(int n, int n2) {
        Msg msg = new Msg();
        msg.u1(n);
        msg.u1(n2);
        return msg;
    }

    public static Msg makeUpdateReq(int n, int n2) {
        Msg msg = Msg.prepareRequest(99);
        msg.u2(n);
        msg.u1(n2);
        return msg;
    }

    public static Msg makeSubscribeReq(int n, int n2) {
        Msg msg = Msg.prepareRequest(115);
        msg.u2(n);
        msg.u1(n2);
        return msg;
    }

    public static Msg makeUnsubscribeReq(int n, int n2) {
        Msg msg = Msg.prepareRequest(117);
        msg.u2(n);
        msg.u1(n2);
        return msg;
    }

    public boolean isError() {
        boolean bl = false;
        if (this.bytes[0] == 33) {
            bl = true;
        }
        return bl;
    }

    public int command() {
        return this.bytes[0];
    }

    public int replyNum() {
        return this.bytes[1];
    }

    public void setReplyNum(int n) {
        if (n > 255) {
            throw new IllegalStateException("replyNum=" + n + " 0x" + Integer.toHexString(n));
        }
        this.bytes[1] = (byte)(n & 0xFF);
    }

    public void checkResponse(int n) throws IOException {
        int n2 = this.u1();
        int n3 = this.u1();
        if (n2 == 33) {
            String string = this.str();
            throw new SoxException("Request failed: " + string);
        }
        if (n2 != n) {
            String string = "" + (char)n2 + '(' + n2 + ')';
            String string2 = "" + (char)n + '(' + n + ')';
            throw new SoxException(string + " != " + string2);
        }
    }

    public String toString() {
        return (char)this.command() + " replyNum=" + this.replyNum() + ' ' + super.toString();
    }

    public Msg(byte[] byArray) {
        super(byArray);
    }

    public Msg() {
        super(1024);
    }
}

