/*
 * Decompiled with CFR 0.152.
 */
package com.gc5.comm;

import com.gc5.BIsmaSoxDevice;
import com.gc5.comm.Msg;
import com.gc5.util.ByteArrayUtil;
import com.gc5.util.TextUtil;
import java.io.EOFException;
import java.io.IOException;
import javax.baja.sys.BBlob;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BDouble;
import javax.baja.sys.BInteger;
import javax.baja.sys.BLong;
import javax.baja.sys.BNumber;
import javax.baja.sys.BSimple;
import javax.baja.sys.BString;
import sedona.Constants;

public class SoxMsg
extends Msg
implements Constants {
    public static final int MAX_PACKET_SIZE = 1024;
    public BIsmaSoxDevice device;

    public static SoxMsg make() {
        return new SoxMsg();
    }

    public static SoxMsg make(BIsmaSoxDevice bIsmaSoxDevice, byte[] byArray, int n) {
        SoxMsg soxMsg = new SoxMsg(byArray, n);
        soxMsg.device = bIsmaSoxDevice;
        return soxMsg;
    }

    public static SoxMsg make(int n) {
        SoxMsg soxMsg = SoxMsg.make();
        soxMsg.u1(n);
        soxMsg.u1(99);
        return soxMsg;
    }

    public static SoxMsg prepareReq(int n) {
        return SoxMsg.prepareReq(n, 255);
    }

    public static SoxMsg prepareReq(int n, int n2) {
        SoxMsg soxMsg = SoxMsg.make();
        soxMsg.u1(n);
        soxMsg.u1(n2);
        return soxMsg;
    }

    public static SoxMsg makeUpdateRequest(int n, int n2) {
        SoxMsg soxMsg = SoxMsg.make();
        soxMsg.u1(99);
        soxMsg.u1(255);
        soxMsg.u2(n);
        soxMsg.u1(n2);
        return soxMsg;
    }

    public static SoxMsg makeSubscribeRequest(int n, int n2) {
        SoxMsg soxMsg = SoxMsg.make();
        soxMsg.u1(115);
        soxMsg.u1(255);
        soxMsg.u2(n);
        soxMsg.u1(n2);
        return soxMsg;
    }

    public static SoxMsg makeUnsubscribeRequest(int n, int n2) {
        SoxMsg soxMsg = SoxMsg.make();
        soxMsg.u1(117);
        soxMsg.u1(255);
        soxMsg.u2(n);
        soxMsg.u1(n2);
        return soxMsg;
    }

    public static SoxMsg makeRes(SoxMsg soxMsg) {
        SoxMsg soxMsg2 = SoxMsg.make();
        soxMsg2.u1(Character.toUpperCase((char)soxMsg.getCommand()));
        soxMsg2.u1(soxMsg.replyNum());
        return soxMsg2;
    }

    public boolean isRequest() {
        boolean bl = false;
        if (this.bytes[0] >= 97 && this.bytes[0] <= 122) {
            bl = true;
        }
        return bl;
    }

    public boolean isFailed() {
        boolean bl = false;
        if (this.bytes[0] == 33) {
            bl = true;
        }
        return bl;
    }

    public int getCommand() {
        return this.bytes[0];
    }

    public String toString() {
        String string = this.device == null ? "null" : this.device.toPathString();
        return "SoxMsg [device=" + string + ']' + ByteArrayUtil.toString(this.bytes, this.size);
    }

    public BSimple readValue() throws IOException {
        return this.readValue(this.read());
    }

    public BSimple readValue(int n) throws IOException {
        switch (n) {
            case 0: {
                return null;
            }
            case 1: {
                return this.readBool();
            }
            case 2: {
                return BInteger.make((int)this.u1());
            }
            case 3: {
                return BInteger.make((int)this.u2());
            }
            case 4: {
                return BInteger.make((int)this.i4());
            }
            case 5: {
                return BLong.make((long)this.i8());
            }
            case 6: {
                float f = this.f4();
                return Float.isNaN(f) ? null : BDouble.make((double)f);
            }
            case 7: {
                return BDouble.make((double)this.f8());
            }
            case 8: {
                int n2 = this.u2();
                if (n2 == 0) {
                    return BBlob.DEFAULT;
                }
                return BBlob.make((byte[])this.buf(n2));
            }
            case 9: 
            case 101: {
                int n3 = this.u2();
                if (n3 == 0) {
                    return BString.DEFAULT;
                }
                return BString.make((String)this.str(n3));
            }
        }
        throw new IllegalStateException("Unknown value type " + (char)n);
    }

    public BBoolean readBool() throws IOException {
        int n = this.u1();
        switch (n) {
            case 0: {
                return BBoolean.FALSE;
            }
            case 1: {
                return BBoolean.TRUE;
            }
            case 2: {
                return null;
            }
        }
        throw new IOException("invalid bool:" + n);
    }

    public byte[] buf(int n) throws IOException {
        byte[] byArray = new byte[n];
        try {
            int n2 = 0;
            while (n2 < n) {
                byArray[n2] = (byte)this.u1();
                ++n2;
            }
        }
        catch (EOFException eOFException) {
            System.out.println("Found fewer than " + n + " bytes, got partial buf");
            eOFException.printStackTrace();
        }
        return byArray;
    }

    public void buf(String string) {
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            int n2 = TextUtil.hexCharToInt(c);
            int n3 = TextUtil.hexCharToInt(string.charAt(++n));
            this.u1(n2 << 4 | n3);
            ++n;
        }
    }

    public String str(int n) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        try {
            int n2 = 0;
            while (n2 < n) {
                int n3 = this.u1();
                if (n3 == 0) {
                    bl = true;
                }
                if (!bl) {
                    stringBuffer.append((char)n3);
                }
                ++n2;
            }
        }
        catch (EOFException eOFException) {
            eOFException.printStackTrace();
        }
        return stringBuffer.toString();
    }

    public void writeValue(BSimple bSimple, int n) throws IOException {
        switch (n) {
            case 0: {
                break;
            }
            case 1: {
                this.writeBool((BBoolean)bSimple);
                break;
            }
            case 2: {
                this.u1(((BNumber)bSimple).getInt());
                break;
            }
            case 3: {
                this.u2(((BNumber)bSimple).getInt());
                break;
            }
            case 4: {
                this.i4(((BNumber)bSimple).getInt());
                break;
            }
            case 5: {
                this.i8(((BNumber)bSimple).getLong());
                break;
            }
            case 6: {
                this.f4(((BNumber)bSimple).getFloat());
                break;
            }
            case 7: {
                this.f8(((BNumber)bSimple).getDouble());
                break;
            }
            case 8: {
                String string = ((BString)bSimple).getString();
                int n2 = string.length();
                this.u2(n2);
                this.buf(string);
                break;
            }
            case 101: {
                String string = ((BString)bSimple).getString();
                this.u2(string.length() + 1);
                this.str(string);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown value type " + n + '\'' + (char)n + '\'');
            }
        }
    }

    public void writeBool(BBoolean bBoolean) {
        if (bBoolean == null) {
            this.u1(2);
        } else {
            this.bool(bBoolean.getBoolean());
        }
    }

    private SoxMsg(byte[] byArray, int n) {
        super(new byte[n]);
        System.arraycopy(byArray, 0, this.bytes, 0, n);
        this.size = n;
    }

    public SoxMsg() {
    }
}

