/*
 * Decompiled with CFR 0.152.
 */
package com.gc5.core;

import com.gc5.BIsmaSoxDevice;
import com.gc5.comm.SoxComm;
import com.gc5.worker.BIsmaSoxCoalescingWorker;
import com.gc5.worker.BIsmaSoxWorker;
import javax.baja.data.BIDataValue;
import javax.baja.log.Log;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIService;
import javax.baja.sys.BIcon;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.NotRunningException;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.IFuture;
import javax.baja.util.Queue;
import javax.baja.util.Worker;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BIsmaSoxCommunicator
extends BComponent
implements BIService {
    public static final Property worker = BIsmaSoxCommunicator.newProperty((int)4, (BValue)new BIsmaSoxCoalescingWorker(), null);
    public static final Property writeWorker = BIsmaSoxCommunicator.newProperty((int)4, (BValue)new BIsmaSoxCoalescingWorker(), null);
    public static final Property retryCount = BIsmaSoxCommunicator.newProperty((int)0, (int)1, null);
    public static final Property retryTime = BIsmaSoxCommunicator.newProperty((int)0, (BValue)BRelTime.make((long)2000L), (BFacets)BFacets.make((String)"showMilliseconds", (BIDataValue)BBoolean.TRUE));
    public static final Type TYPE;
    private static final BIcon icon;
    SoxComm comm;
    public boolean networkRunning;
    Worker workQueue;
    static /* synthetic */ Class class$com$gc5$core$BIsmaSoxCommunicator;

    public BIsmaSoxWorker getWorker() {
        return (BIsmaSoxWorker)this.get(worker);
    }

    public void setWorker(BIsmaSoxWorker bIsmaSoxWorker) {
        this.set(worker, (BValue)bIsmaSoxWorker, null);
    }

    public BIsmaSoxCoalescingWorker getWriteWorker() {
        return (BIsmaSoxCoalescingWorker)this.get(writeWorker);
    }

    public void setWriteWorker(BIsmaSoxCoalescingWorker bIsmaSoxCoalescingWorker) {
        this.set(writeWorker, (BValue)bIsmaSoxCoalescingWorker, null);
    }

    public int getRetryCount() {
        return this.getInt(retryCount);
    }

    public void setRetryCount(int n) {
        this.setInt(retryCount, n, null);
    }

    public BRelTime getRetryTime() {
        return (BRelTime)this.get(retryTime);
    }

    public void setRetryTime(BRelTime bRelTime) {
        this.set(retryTime, (BValue)bRelTime, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BIcon getIcon() {
        return icon;
    }

    public Type[] getServiceTypes() {
        return new Type[]{TYPE};
    }

    final BIsmaSoxDevice getDevice() {
        return (BIsmaSoxDevice)this.getParent();
    }

    public void serviceStarted() throws Exception {
        try {
            if (this.workQueue == null) {
                this.workQueue = new Worker((Worker.ITodo)new Queue(1000));
            }
            this.workQueue.start("IsmaSox.Cov:" + this.getDevice().getName());
            this.networkRunning = true;
        }
        catch (Throwable throwable) {
            this.getLog().error("Error initializing Device " + this.getName(), throwable);
            throwable.printStackTrace();
        }
    }

    public void serviceStopped() throws Exception {
        if (this.workQueue == null) {
            this.workQueue.stop();
        }
        this.workQueue = null;
        this.networkRunning = false;
    }

    public boolean isCommEnabled() {
        return this.getDevice().isDisabled() ^ true;
    }

    public void started() throws Exception {
        super.started();
        try {
            this.startComm();
        }
        catch (Exception exception) {
            this.getLog().error("Could not start communication handler.", (Throwable)exception);
        }
    }

    public void atSteadyState() throws Exception {
        super.atSteadyState();
        try {
            this.remove("pollScheduler");
        }
        catch (Exception exception) {}
        try {
            this.remove("covScheduler");
        }
        catch (Exception exception) {}
        try {
            this.remove("dispatcher");
        }
        catch (Exception exception) {}
        try {
            this.remove("covWorker");
        }
        catch (Exception exception) {}
    }

    public void stopped() throws Exception {
        super.stopped();
        try {
            this.stopComm();
        }
        catch (Exception exception) {
            this.getLog().error("Could not stop communication handler.", (Throwable)exception);
        }
    }

    public void startComm() throws Exception {
        if (this.isCommEnabled() && this.comm == null) {
            if (this.comm == null) {
                this.comm = SoxComm.make(this);
            }
            try {
                if (this.getLog().isTraceOn()) {
                    this.getLog().trace(this.getName() + "Starting Communication Handler.");
                }
                this.comm.start();
                if (this.getLog().isTraceOn()) {
                    this.getLog().trace(this.getName() + "Started Communication Handler.");
                }
            }
            catch (Throwable throwable) {
                this.getLog().error("Error initializing Device " + this.getDevice().getName(), throwable);
                throwable.printStackTrace();
            }
        }
    }

    public void stopComm() throws Exception {
        if (this.comm != null) {
            if (this.getLog().isTraceOn()) {
                this.getLog().trace(this.getName() + "Stopping Communication Handler.");
            }
            this.comm.stop();
            if (this.getLog().isTraceOn()) {
                this.getLog().trace(this.getName() + "Stopped Communication Handler.");
            }
            this.comm = null;
        }
    }

    public void changed(Property property, Context context) {
        super.changed(property, context);
    }

    public final IFuture dispatch(Runnable runnable) {
        if (!this.networkRunning || !this.workQueue.isRunning()) {
            throw new NotRunningException();
        }
        ((Queue)this.workQueue.getTodo()).enqueue((Object)runnable);
        return null;
    }

    public final IFuture postAsync(Runnable runnable) {
        return this.post(runnable);
    }

    public final IFuture post(Runnable runnable) {
        return this.getWorker().post(runnable);
    }

    public final IFuture postWrite(Runnable runnable) {
        return this.getWriteWorker().post(runnable);
    }

    public SoxComm comm() {
        return this.comm;
    }

    public final Log getLog() {
        return Log.getLog((String)this.getParent().getName());
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.comm = null;
        this.networkRunning = false;
        this.workQueue = null;
    }

    public BIsmaSoxCommunicator() {
        this.this();
    }

    static {
        Class clazz = class$com$gc5$core$BIsmaSoxCommunicator;
        if (clazz == null) {
            clazz = class$com$gc5$core$BIsmaSoxCommunicator = BIsmaSoxCommunicator.class("[Lcom.gc5.core.BIsmaSoxCommunicator;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        icon = BIcon.std((String)"gears.png");
    }
}

