/*
 * Decompiled with CFR 0.152.
 */
package sedonac.steps;

import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import sedona.util.TextUtil;
import sedonac.Compiler;
import sedonac.CompilerStep;
import sedonac.Location;
import sedonac.ast.Expr;
import sedonac.ir.IrField;
import sedonac.ir.IrType;
import sedonac.namespace.Field;
import sedonac.namespace.Type;
import sedonac.namespace.TypeUtil;

public class FieldLayout
extends CompilerStep {
    Location loc;
    IrType[] types;
    HashMap processing;
    HashMap todo;
    int refSize;

    public void run() {
        this.log.debug("  FieldLayout");
        this.findIrTypes();
        this.layoutInstanceFields();
        this.layoutStaticFields();
        if (this.compiler.dumpLayout) {
            this.dump();
        }
        this.quitIfErrors();
    }

    private final void findIrTypes() {
        IrType irType;
        this.todo = new HashMap();
        int n = 0;
        while (n < this.flat.types.length) {
            irType = this.flat.types[n];
            this.todo.put(irType.qname, irType);
            ++n;
        }
        if (this.compiler.ir != null) {
            n = 0;
            while (n < this.compiler.ir.types.length) {
                irType = this.compiler.ir.types[n];
                this.todo.put(irType.qname, irType);
                ++n;
            }
        }
        this.types = this.todo.values().toArray(new IrType[this.todo.size()]);
    }

    private final void layoutInstanceFields() {
        this.processing = new HashMap();
        int n = 0;
        while (n < this.types.length) {
            this.layoutInstanceFields(this.types[n]);
            ++n;
        }
        this.quitIfErrors();
        n = 0;
        while (n < this.types.length) {
            if (this.types[n].sizeof < 0) {
                throw new IllegalStateException();
            }
            ++n;
        }
    }

    private final void layoutInstanceFields(IrType irType) {
        String string = irType.qname;
        if (!this.todo.containsKey(string)) {
            return;
        }
        if (this.processing.containsKey(string)) {
            this.err("Cyclic inline field in '" + string + '\'', this.loc);
            return;
        }
        this.processing.put(string, irType);
        this.loc = new Location(irType.qname);
        int n = 0;
        if (irType.base != null) {
            if (irType.base.sizeof() < 0) {
                this.layoutInstanceFields(TypeUtil.ir(irType.base));
            }
            n = irType.base.isVirtual() ? (n += 2) : irType.base.sizeof();
        }
        if (n < 0) {
            throw new IllegalStateException(irType.qname);
        }
        irType.sizeof = this.layoutFields(n, irType.instanceFields());
        this.processing.remove(string);
        this.todo.remove(string);
    }

    private final void layoutStaticFields() {
        int n = this.layoutFields(0, this.flat.staticFields);
        if (n < 0) {
            throw this.err("Data size could not be computed");
        }
        this.compiler.dataSize = n;
    }

    private final int layoutFields(int n, IrField[] irFieldArray) {
        n = this.layoutFields(irFieldArray, n, 1);
        while (n % 2 != 0) {
            ++n;
        }
        n = this.layoutFields(irFieldArray, n, 2);
        while (n % 4 != 0) {
            ++n;
        }
        n = this.layoutFields(irFieldArray, n, 4);
        IrField irField = null;
        int n2 = 0;
        while (n2 < irFieldArray.length) {
            IrField irField2 = irFieldArray[n2];
            if (irFieldArray[n2].offset == -1) {
                this.loc = new Location(irField2.qname);
                if (!irField2.isInline()) {
                    throw new IllegalStateException(irField2.qname);
                }
                if (irField2.isConst()) {
                    irField2.offset = n;
                } else if (irField2.ctorLengthParam >= 0) {
                    if (irField != null) {
                        throw new IllegalStateException("More than one unsized array? " + irField2.qname);
                    }
                    irField = irField2;
                } else {
                    int n3;
                    Type type;
                    Type type2 = type = irField2.type;
                    if (type.isArray() && type.arrayOf().isRef()) {
                        type2 = irField2.arrayInit ? type.arrayOf() : null;
                    }
                    if (type2 != null && type2.sizeof() < 0) {
                        this.layoutInstanceFields(TypeUtil.ir(type2));
                        if (type2.sizeof() < 0) {
                            return -1;
                        }
                    }
                    if (type.isArray() && type.arrayOf().isRef()) {
                        Type type3 = type.arrayOf();
                        int n4 = type.arrayLength().val();
                        n3 = n4 * this.refSize;
                        if (irField2.arrayInit) {
                            n3 += n4 * type3.sizeof();
                        }
                    } else {
                        n3 = irField2.ctorLengthArg != null ? this.calcDynamicSize(irField2) : type.sizeof();
                    }
                    if (n3 < 0) {
                        throw new IllegalStateException();
                    }
                    if (n % 4 != 0) {
                        throw new IllegalStateException();
                    }
                    irField2.offset = n;
                    n += n3;
                    while (n % 4 != 0) {
                        ++n;
                    }
                }
            }
            ++n2;
        }
        if (irField != null) {
            irField.offset = n;
        }
        if (n % 4 != 0) {
            throw new IllegalStateException();
        }
        return n;
    }

    private final int layoutFields(IrField[] irFieldArray, int n, int n2) {
        if (n % n2 != 0) {
            throw new IllegalStateException();
        }
        int n3 = 0;
        while (n3 < irFieldArray.length) {
            boolean bl;
            IrField irField = irFieldArray[n3];
            Type type = irField.type;
            int n4 = n2;
            if (type.isPrimitive()) {
                if (type.sizeof() == 8) {
                    boolean bl2 = false;
                    if (n2 == 4) {
                        bl2 = true;
                    }
                    bl = bl2;
                    n4 = 8;
                } else {
                    boolean bl3 = false;
                    if (type.sizeof() == n2) {
                        bl3 = true;
                    }
                    bl = bl3;
                }
            } else if (irField.isConst() && !irField.isInline()) {
                boolean bl4 = false;
                if (n2 == 2) {
                    bl4 = true;
                }
                bl = bl4;
            } else {
                boolean bl5 = false;
                if (n2 == this.refSize && !irField.isInline()) {
                    bl5 = bl = true;
                }
            }
            if (bl) {
                irField.offset = n;
                n += n4;
            }
            ++n3;
        }
        return n;
    }

    private final int calcDynamicSize(IrField irField) {
        int n = irField.ctorLengthArg instanceof Expr.Literal ? ((Expr.Literal)irField.ctorLengthArg).asInt() : ((Expr.Field)irField.ctorLengthArg).field.define().asInt();
        int n2 = irField.type.sizeof();
        Field field = TypeUtil.getUnsizedArrayField(irField.type);
        Type type = field.type().arrayOf();
        int n3 = type.isRef() ? this.refSize : type.sizeof();
        return n2 + n3 * n;
    }

    private final void dump() {
        System.out.println("==== FieldLayout =====");
        IrType[] irTypeArray = (IrType[])this.types.clone();
        Arrays.sort(irTypeArray, new Comparator(){

            public final int compare(Object object, Object object2) {
                return object.toString().compareTo(object2.toString());
            }
        });
        int n = 0;
        while (n < irTypeArray.length) {
            IrType irType = irTypeArray[n];
            IrField[] irFieldArray = irType.instanceFields();
            if (irFieldArray.length != 0) {
                System.out.println("  --- " + irType.qname + " [sizeof " + irType.sizeof + "] ---");
                this.dumpFields(irFieldArray);
            }
            ++n;
        }
        System.out.println("  --- static fields [dataSize " + this.compiler.dataSize + "] ---");
        this.dumpFields(this.flat.staticFields);
        System.out.println("  ---------------------");
    }

    private final void dumpFields(IrField[] irFieldArray) {
        Arrays.sort(irFieldArray, new Comparator(){

            public final int compare(Object object, Object object2) {
                return ((IrField)object).offset > ((IrField)object2).offset ? 1 : -1;
            }
        });
        int n = 0;
        while (n < irFieldArray.length) {
            System.out.println("    " + TextUtil.pad((String)(irFieldArray[n].offset + ": "), (int)5) + irFieldArray[n].qname);
            ++n;
        }
    }

    public FieldLayout(Compiler compiler) {
        super(compiler);
        this.refSize = compiler.image == null ? 4 : compiler.image.refSize;
    }
}

