/*
 * Decompiled with CFR 0.152.
 */
package sedona.sox;

import java.net.InetAddress;
import java.util.Hashtable;
import java.util.Properties;
import sedona.dasp.DaspMessage;
import sedona.dasp.DaspSession;
import sedona.dasp.DaspSocket;
import sedona.sox.FileTransfer;
import sedona.sox.ISoxComm;
import sedona.sox.Msg;
import sedona.sox.SoxClient;
import sedona.sox.SoxComponent;
import sedona.sox.SoxException;
import sedona.sox.SoxFile;
import sedona.sox.SoxReceiver;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class SoxExchange
implements ISoxComm {
    SoxClient client;
    Msg[] requests;
    Msg[] responses;
    public final DaspSocket socket;
    public final InetAddress addr;
    public final int port;
    public final String username;
    final String password;
    DaspSession session;
    String closeCause;
    SoxReceiver receiver;
    FileTransfer fileTransfer;
    volatile boolean closing;

    public void send(Msg msg) throws Exception {
        this.checkOpen();
        if (this.client.traceMsg) {
            System.out.println("--> [send] " + (char)msg.command() + " replyNum=" + msg.replyNum());
        }
        this.session.send(msg.bytes, 0, msg.size);
    }

    public Msg request(Msg msg) throws Exception {
        return this.request(new Msg[]{msg})[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Msg[] request(Msg[] var1_1) throws Exception {
        this.checkOpen();
        if (var1_1.length > 255) {
            return this.chunkRequests(var1_1);
        }
        var2_2 = this;
        synchronized (var2_2) {
            var5_3 = 0;
            while (true) {
                block12: {
                    if (var5_3 < var1_1.length) break block12;
                    this.requests = var1_1;
                    this.responses = new Msg[var1_1.length];
                    var5_3 = 0;
                    if (true) ** GOTO lbl24
                }
                var1_1[var5_3].setReplyNum(var5_3);
                ++var5_3;
            }
            do {
                this.send(var1_1[var5_3]);
                ++var5_3;
lbl24:
                // 2 sources

            } while (var5_3 < var1_1.length);
            while (true) {
                var5_3 = 1;
                var6_4 = this.responses.length - 1;
                while (var6_4 >= 0) {
                    if (this.responses[var6_4] == null) {
                        var5_3 = 0;
                        break;
                    }
                    --var6_4;
                }
                if (var5_3 != 0) {
                    var6_5 = this.responses;
                    this.requests = null;
                    this.responses = null;
                    return var6_5;
                }
                try {
                    this.wait(500L);
                }
                catch (InterruptedException v1) {}
                this.checkOpen();
            }
        }
    }

    public synchronized void connect(Hashtable hashtable) throws Exception {
        if (!this.isClosed()) {
            throw new SoxException("Already open!");
        }
        this.session = this.socket.connect(this.addr, this.port, this.username, this.password, hashtable);
        this.session.listener = new DaspSession.Listener(){

            public final void daspSessionClosed(DaspSession daspSession) {
                SoxExchange.this.closeCause = daspSession.closeCause();
                if (!SoxExchange.this.closing) {
                    SoxExchange.this.close();
                }
            }
        };
        this.closeCause = "???";
        this.receiver = new SoxReceiver(this);
        this.receiver.start();
    }

    public SoxClient client() {
        return this.client;
    }

    public DaspSession session() {
        return this.session;
    }

    public int localId() {
        DaspSession daspSession = this.session;
        return daspSession == null ? -1 : daspSession.id;
    }

    public int remoteId() {
        DaspSession daspSession = this.session;
        return daspSession == null ? -1 : daspSession.remoteId();
    }

    public boolean isClosed() {
        DaspSession daspSession = this.session;
        if (daspSession == null) {
            return true;
        }
        if (daspSession.isClosed()) {
            this.closeCause = daspSession.closeCause();
            return true;
        }
        return false;
    }

    public void close() {
        Object object;
        if (this.closing) {
            return;
        }
        this.closing = true;
        try {
            object = this.receiver;
            if (object != null) {
                ((SoxReceiver)object).kill();
            }
            this.receiver = null;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            object = this.session;
            if (object != null) {
                ((DaspSession)object).close();
            }
            this.session = null;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.session = null;
        this.receiver = null;
        this.client.cache = new SoxComponent[1024];
        this.client.allTreeEvents = false;
        this.client.util = null;
        this.client.close();
        try {
            this.client.closed();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        this.closing = false;
    }

    public boolean isSubscribed(SoxComponent soxComponent) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void receive(Msg msg) {
        try {
            SoxExchange soxExchange = this;
            synchronized (soxExchange) {
                int n;
                byte by = msg.bytes[0];
                int n2 = n = msg.bytes[1] & 0xFF;
                if (this.requests == null) return;
                if (this.responses == null) return;
                if (n2 < 0) return;
                if (n2 >= this.requests.length) {
                    return;
                }
                Msg msg2 = this.requests[n2];
                if (by != 33 && by != (msg2.bytes[0] & 0xFFFFFFDF)) {
                    throw new SoxException("Invalid response code " + by + " for " + msg2.bytes[0]);
                }
                this.responses[n2] = msg;
                this.notify();
                return;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Properties getFile(String string, SoxFile soxFile, Properties properties, ISoxComm.TransferListener transferListener) throws Exception {
        this.fileTransfer = new FileTransfer(this, string, soxFile, properties, transferListener);
        try {
            Properties properties2 = this.fileTransfer.getFile();
            Object var6_6 = null;
            this.fileTransfer = null;
            return properties2;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            this.fileTransfer = null;
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Properties putFile(String string, SoxFile soxFile, Properties properties, ISoxComm.TransferListener transferListener) throws Exception {
        this.fileTransfer = new FileTransfer(this, string, soxFile, properties, transferListener);
        try {
            Properties properties2 = this.fileTransfer.putFile();
            Object var6_6 = null;
            this.fileTransfer = null;
            return properties2;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            this.fileTransfer = null;
            throw throwable;
        }
    }

    public synchronized void renameFile(String string, String string2) throws Exception {
        Msg msg = Msg.prepareRequest(98);
        msg.str(string);
        msg.str(string2);
        Msg msg2 = this.request(msg);
        msg2.checkResponse(66);
    }

    public synchronized void connect() throws Exception {
        this.connect(null);
    }

    private final Msg[] chunkRequests(Msg[] msgArray) throws Exception {
        int n = msgArray.length;
        Msg[] msgArray2 = new Msg[n];
        int n2 = 0;
        while (n2 < n) {
            Msg[] msgArray3 = new Msg[Math.min(255, n - n2)];
            System.arraycopy(msgArray, n2, msgArray3, 0, msgArray3.length);
            Msg[] msgArray4 = this.request(msgArray3);
            System.arraycopy(msgArray4, 0, msgArray2, n2, msgArray4.length);
            n2 += msgArray3.length;
        }
        return msgArray2;
    }

    Msg receive(long l) throws Exception {
        DaspMessage daspMessage = this.session.receive(l);
        if (daspMessage == null) {
            return null;
        }
        Msg msg = new Msg(daspMessage.payload());
        if (this.client.traceMsg) {
            System.out.println("<-- [recv] " + (char)msg.command() + " replyNum=" + msg.replyNum());
        }
        return msg;
    }

    void checkOpen() {
        if (this.isClosed()) {
            throw new SoxException("SoxClient closed: " + this.closeCause);
        }
    }

    private final /* synthetic */ void this() {
        this.closeCause = "never opened";
    }

    SoxExchange(SoxClient soxClient) {
        this.this();
        this.client = soxClient;
        this.socket = soxClient.socket;
        this.addr = soxClient.addr;
        this.port = soxClient.port;
        this.username = soxClient.username;
        this.password = soxClient.password;
    }
}

