/*
 * Decompiled with CFR 0.152.
 */
package sedona.xml;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import sedona.xml.XElem;
import sedona.xml.XException;
import sedona.xml.XInputStreamReader;
import sedona.xml.XLocation;
import sedona.xml.XNs;
import sedona.xml.XText;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class XParser {
    public static final int EOF = -1;
    public static final int ELEM_START = 1;
    public static final int ELEM_END = 2;
    public static final int TEXT = 3;
    private static final byte[] charMap = new byte[128];
    private static final int CT_SPACE = 1;
    private static final int CT_NAME = 2;
    private static final String[] internCache;
    private String filename;
    private XInputStreamReader in;
    private int pushback;
    private int line;
    private int col;
    private int type;
    private XText text;
    private int depth;
    private XElem[] stack;
    private XNs[][] nsStack;
    private XNs defaultNs;
    private XText buf;
    private XText entityBuf;
    private String name;
    private String prefix;
    private boolean popStack;
    private boolean emptyElem;

    public static XParser make(File file) throws Exception {
        return XParser.make(file.toString(), new BufferedInputStream(new FileInputStream(file)));
    }

    public static XParser make(String string, String string2) throws Exception {
        return XParser.make(string, new ByteArrayInputStream(string2.getBytes()));
    }

    public static XParser make(String string, InputStream inputStream) throws Exception {
        return new XParser(string, inputStream);
    }

    public String getEncoding() throws IOException {
        return this.in.getEncoding();
    }

    public boolean isZipped() throws IOException {
        return this.in.isZipped();
    }

    public final XElem parse() throws Exception {
        return this.parse(true);
    }

    public final XElem parse(boolean bl) throws Exception {
        if (this.next() != 1) {
            if (bl) {
                this.close();
            }
            throw this.error("Expecting element start");
        }
        return this.parseCurrent(bl);
    }

    public final XElem parseCurrent() throws Exception {
        return this.parseCurrent(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final XElem parseCurrent(boolean bl) throws Exception {
        try {
            XElem xElem;
            int n = 1;
            XElem xElem2 = xElem = this.elem().copy(this.newElem());
            while (n > 0) {
                int n2 = this.next();
                if (n2 == 1) {
                    XElem xElem3 = xElem2;
                    xElem2 = this.elem().copy(this.newElem());
                    xElem3.addContent(xElem2);
                    ++n;
                    continue;
                }
                if (n2 == 2) {
                    xElem2 = xElem2.parent();
                    --n;
                    continue;
                }
                if (n2 == 3) {
                    xElem2.addContent(this.text().copy());
                    continue;
                }
                if (n2 != -1) continue;
                throw new EOFException("Unexpected EOF in XML element");
            }
            XElem xElem4 = xElem;
            Object var3_8 = null;
            if (bl) {
                this.close();
            }
            return xElem4;
        }
        catch (Throwable throwable) {
            block7: {
                Object var3_9 = null;
                if (!bl) break block7;
                this.close();
            }
            throw throwable;
        }
    }

    public final int next() throws Exception {
        if (this.popStack) {
            this.popStack = false;
            this.pop();
        }
        if (this.emptyElem) {
            this.emptyElem = false;
            this.popStack = true;
            this.type = 2;
            return 2;
        }
        while (true) {
            int n;
            try {
                n = this.read();
            }
            catch (EOFException eOFException) {
                this.type = -1;
                return -1;
            }
            if (n == 60) {
                n = this.read();
                if (n == 33) {
                    n = this.read();
                    if (n == 45) {
                        n = this.read();
                        if (n != 45) {
                            throw this.error("Expecting comment");
                        }
                        this.skipComment();
                        continue;
                    }
                    if (n == 91) {
                        this.consume("CDATA[");
                        this.parseCDATA();
                        this.type = 3;
                        return 3;
                    }
                    if (n == 68) {
                        this.consume("OCTYPE");
                        this.skipDocType();
                        continue;
                    }
                    throw this.error("Unexpected markup");
                }
                if (n == 63) {
                    this.skipPI();
                    continue;
                }
                if (n == 47) {
                    this.parseElemEnd();
                    this.popStack = true;
                    this.type = 2;
                    return 2;
                }
                this.parseElemStart(n);
                this.type = 1;
                return 1;
            }
            if (this.parseText(n)) break;
        }
        this.type = 3;
        return 3;
    }

    public void skip() throws Exception {
        this.skip(this.depth);
    }

    public void skip(int n) throws Exception {
        int n2;
        do {
            if (this.type != 2 || this.depth != n) continue;
            return;
        } while ((n2 = this.next()) != -1);
        throw new EOFException("Unexpected EOF in XML");
    }

    public final int type() {
        return this.type;
    }

    public final int depth() {
        return this.depth;
    }

    public final XElem elem() {
        if (this.depth < 1) {
            return null;
        }
        return this.stack[this.depth - 1];
    }

    public final XElem elem(int n) {
        if (n < 0 || n >= this.depth) {
            return null;
        }
        return this.stack[n];
    }

    public final XText text() {
        if (this.type == 3) {
            return this.text;
        }
        return null;
    }

    public final int line() {
        return this.line;
    }

    public final int column() {
        return this.col;
    }

    public final void close() {
        try {
            this.in.close();
        }
        catch (IOException iOException) {}
    }

    private final void parseElemStart(int n) throws Exception {
        int n2;
        XElem xElem = this.push();
        this.parseQName(n);
        xElem.name = this.name;
        xElem.filename = this.filename;
        xElem.line = this.line;
        String string = this.prefix;
        boolean bl = false;
        while (true) {
            n2 = this.skipSpace();
            n = this.read();
            if (n == 62) break;
            if (n == 47) {
                n = this.read();
                if (n != 62) {
                    throw this.error("Expecting /> empty element");
                }
                this.emptyElem = true;
                break;
            }
            if (n2 == 0) {
                throw this.error("Expecting space before attribute");
            }
            bl |= this.parseAttr(n, xElem);
        }
        xElem.ns = string == null ? this.defaultNs : this.prefixToNs(string);
        if (bl) {
            n2 = 0;
            while (n2 < xElem.attrSize) {
                if (xElem.attr[n2 * 3 + 1] != null) {
                    xElem.attr[n2 * 3 + 1] = this.prefixToNs((String)xElem.attr[n2 * 3 + 1]);
                }
                ++n2;
            }
        }
    }

    private final void parseElemEnd() throws Exception {
        this.parseQName(this.read());
        XNs xNs = null;
        xNs = this.prefix == null ? this.defaultNs : this.prefixToNs(this.prefix);
        if (this.depth == 0) {
            throw this.error("Element end without start");
        }
        XElem xElem = this.stack[this.depth - 1];
        if (!xElem.name.equals(this.name) || xElem.ns != xNs) {
            throw this.error("Expecting end of element '" + xElem.qname() + "'[" + xElem.line + ']');
        }
        this.skipSpace();
        if (this.read() != 62) {
            throw this.error("Expecting > end of element");
        }
    }

    private final boolean parseAttr(int n, XElem xElem) throws Exception {
        this.parseQName(n);
        String string = this.prefix;
        String string2 = this.name;
        this.skipSpace();
        if (this.read() != 61) {
            throw this.error("Expecting '='");
        }
        this.skipSpace();
        n = this.read();
        if (n != 34 && n != 39) {
            throw this.error("Expecting quoted attribute value");
        }
        String string3 = this.parseString(n);
        if (string == null) {
            if (string2.equals("xmlns")) {
                this.pushNs(xElem, "", string3);
            }
        } else if (string.equals("xmlns")) {
            this.pushNs(xElem, string2, string3);
            string = null;
            string2 = "xmlns:" + string2;
        } else if (string.equalsIgnoreCase("xml")) {
            string = null;
            string2 = "xml:" + string2;
        }
        xElem.addAttrImpl(string, string2, string3);
        boolean bl = false;
        if (string != null) {
            bl = true;
        }
        return bl;
    }

    private final void parseQName(int n) throws Exception {
        this.prefix = null;
        this.name = this.parseName(n);
        n = this.read();
        if (n == 58) {
            this.prefix = this.name;
            this.name = this.parseName(this.read());
        } else {
            this.pushback = n;
        }
    }

    private final String parseString(int n) throws Exception {
        int n2;
        XText xText = this.buf;
        xText.setLength(0);
        while ((n2 = this.read()) != n) {
            xText.append(this.toCharData(n2));
        }
        return this.bufToString();
    }

    private final String parseName(int n) throws Exception {
        if (!XParser.isName(n)) {
            throw this.error("Expected XML name");
        }
        XText xText = this.buf;
        xText.setLength(0);
        xText.append(n);
        while (XParser.isName(n = this.read())) {
            xText.append(n);
        }
        this.pushback = n;
        return this.bufToString();
    }

    private final void parseCDATA() throws Exception {
        XText xText = this.text;
        xText.length = 0;
        xText.cdata = true;
        int n = -1;
        int n2 = -1;
        int n3 = -1;
        while (true) {
            n = n2;
            n2 = n3;
            n3 = this.read();
            if (n == 93 && n2 == 93 && n3 == 62) {
                xText.setLength(xText.length - 2);
                return;
            }
            xText.append(n3);
        }
    }

    private final boolean parseText(int n) throws Exception {
        XText xText = this.text;
        xText.length = 0;
        xText.cdata = false;
        xText.append(this.toCharData(n));
        boolean bl = XParser.isSpace(n) ^ true;
        while (true) {
            try {
                n = this.read();
            }
            catch (EOFException eOFException) {
                if (bl) {
                    throw eOFException;
                }
                return false;
            }
            if (n == 60) {
                this.pushback = n;
                return bl;
            }
            if (!XParser.isSpace(n)) {
                bl = true;
            }
            xText.append(this.toCharData(n));
        }
    }

    private final boolean skipSpace() throws Exception {
        int n = this.read();
        if (!XParser.isSpace(n)) {
            this.pushback = n;
            return false;
        }
        while (XParser.isSpace(n = this.read())) {
        }
        this.pushback = n;
        return true;
    }

    private final void skipComment() throws Exception {
        int n = -1;
        int n2 = -1;
        int n3 = -1;
        do {
            n = n2;
            n2 = n3;
            n3 = this.read();
        } while (n != 45 || n2 != 45);
        if (n3 != 62) {
            throw this.error("Cannot have -- in middle of comment");
        }
    }

    private final void skipPI() throws Exception {
        int n = -1;
        int n2 = -1;
        do {
            n = n2;
            n2 = this.read();
        } while (n != 63 || n2 != 62);
    }

    private final void skipDocType() throws Exception {
        int n = 1;
        do {
            int n2;
            if ((n2 = this.read()) == 60) {
                ++n;
            }
            if (n2 != 62) continue;
            --n;
        } while (n != 0);
    }

    private final void consume(String string) throws Exception {
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            if (this.read() != string.charAt(n2)) {
                throw this.error("Expected '" + string + '\'');
            }
            ++n2;
        }
    }

    private final int read() throws Exception {
        int n = this.pushback;
        if (n != -1) {
            this.pushback = -1;
            return n;
        }
        n = this.in.read();
        if (n < 0) {
            throw new EOFException("Unexpected EOF in XML input");
        }
        if (n == 10) {
            ++this.line;
            this.col = 0;
            return 10;
        }
        if (n == 13) {
            int n2 = this.in.read();
            if (n2 != 10) {
                this.pushback = n2;
            }
            ++this.line;
            this.col = 0;
            return 10;
        }
        ++this.col;
        return n;
    }

    private final int toCharData(int n) throws Exception {
        if (n == 60) {
            throw this.error("Invalid markup in char data");
        }
        if (n != 38) {
            return n;
        }
        n = this.read();
        if (n == 35) {
            n = this.in.read();
            ++this.col;
            int n2 = 0;
            int n3 = 10;
            if (n == 120) {
                n3 = 16;
            } else {
                n2 = this.toNum(n2, n, n3);
            }
            n = this.in.read();
            ++this.col;
            while (n != 59) {
                n2 = this.toNum(n2, n, n3);
                n = this.in.read();
                ++this.col;
            }
            return (char)n2;
        }
        XText xText = this.entityBuf;
        xText.setLength(0);
        xText.append(n);
        while ((n = this.read()) != 59) {
            xText.append(n);
        }
        String string = xText.string().intern();
        if (string == "lt") {
            return 60;
        }
        if (string == "gt") {
            return 62;
        }
        if (string == "amp") {
            return 38;
        }
        if (string == "quot") {
            return 34;
        }
        if (string == "apos") {
            return 39;
        }
        throw this.error("Unsupported entity &" + string + ';');
    }

    private final int toNum(int n, int n2, int n3) throws Exception {
        n *= n3;
        if (48 <= n2 && n2 <= 57) {
            return n + (n2 - 48);
        }
        if (n3 == 16) {
            if (97 <= n2 && n2 <= 102) {
                return n + 10 + (n2 - 97);
            }
            if (65 <= n2 && n2 <= 70) {
                return n + 10 + (n2 - 65);
            }
        }
        throw this.error("Expected base " + n3 + " number");
    }

    private final String bufToString() {
        char c;
        if (this.buf.length == 1 && ' ' <= (c = this.buf.data[0]) && c < '\u0080') {
            return internCache[c];
        }
        return this.buf.string();
    }

    private final XNs prefixToNs(String string) {
        int n = this.depth - 1;
        while (n >= 0) {
            XNs[] xNsArray = this.nsStack[n];
            if (xNsArray != null) {
                int n2 = 0;
                while (n2 < xNsArray.length) {
                    if (xNsArray[n2].prefix.equals(string)) {
                        return xNsArray[n2];
                    }
                    ++n2;
                }
            }
            --n;
        }
        throw this.error("Undeclared namespace prefix '" + string + '\'');
    }

    private final void pushNs(XElem xElem, String string, String string2) {
        XNs[] xNsArray;
        XNs xNs = new XNs(string, string2);
        if (string == "") {
            this.defaultNs = string2.equals("") ? null : xNs;
        }
        if ((xNsArray = this.nsStack[this.depth - 1]) == null) {
            xNsArray = new XNs[]{xNs};
        } else {
            XNs[] xNsArray2 = new XNs[xNsArray.length + 1];
            System.arraycopy(xNsArray, 0, xNsArray2, 0, xNsArray.length);
            xNsArray2[xNsArray.length] = xNs;
            xNsArray = xNsArray2;
        }
        this.nsStack[this.depth - 1] = xNsArray;
    }

    private final void reEvalDefaultNs() {
        this.defaultNs = null;
        int n = this.depth - 1;
        while (n >= 0) {
            XNs[] xNsArray = this.nsStack[n];
            if (xNsArray != null) {
                int n2 = 0;
                while (n2 < xNsArray.length) {
                    if (xNsArray[n2].isDefault()) {
                        if (!xNsArray[n2].uri.equals("")) {
                            this.defaultNs = xNsArray[n2];
                        }
                        return;
                    }
                    ++n2;
                }
            }
            --n;
        }
    }

    private final XElem push() {
        XElem xElem = this.stack[this.depth];
        if (xElem == null) {
            xElem = this.stack[this.depth] = this.newElem();
        }
        ++this.depth;
        xElem.clearAttr();
        return xElem;
    }

    private final void pop() {
        --this.depth;
        XNs[] xNsArray = this.nsStack[this.depth];
        if (xNsArray != null) {
            this.nsStack[this.depth] = null;
            this.reEvalDefaultNs();
        }
    }

    protected XElem newElem() {
        return new XElem();
    }

    private final XException error(String string) {
        return new XException(string, new XLocation(this.filename, this.line, this.col));
    }

    static boolean isName(int n) {
        boolean bl = true;
        if (n < 128) {
            bl = false;
            if ((charMap[n] & 2) != 0) {
                bl = true;
            }
        }
        return bl;
    }

    static boolean isSpace(int n) {
        boolean bl = false;
        if (n < 128) {
            bl = false;
            if ((charMap[n] & 1) != 0) {
                bl = true;
            }
        }
        return bl;
    }

    private final /* synthetic */ void this() {
        this.pushback = -1;
        this.line = 1;
        this.text = new XText();
        this.stack = new XElem[256];
        this.nsStack = new XNs[256][];
        this.buf = new XText();
        this.entityBuf = new XText();
    }

    protected XParser(String string, InputStream inputStream) throws IOException {
        this.this();
        this.filename = string;
        this.in = new XInputStreamReader(inputStream);
    }

    static {
        int n = 97;
        while (n <= 122) {
            XParser.charMap[n] = 2;
            ++n;
        }
        n = 65;
        while (n <= 90) {
            XParser.charMap[n] = 2;
            ++n;
        }
        n = 48;
        while (n <= 57) {
            XParser.charMap[n] = 2;
            ++n;
        }
        XParser.charMap[45] = 2;
        XParser.charMap[46] = 2;
        XParser.charMap[95] = 2;
        XParser.charMap[10] = 1;
        XParser.charMap[13] = 1;
        XParser.charMap[32] = 1;
        XParser.charMap[9] = 1;
        internCache = new String[128];
        int n2 = 32;
        while (n2 < 128) {
            XParser.internCache[n2] = new String(new char[]{(char)n2}).intern();
            ++n2;
        }
    }
}

