/*
 * Decompiled with CFR 0.152.
 */
package sedona.web;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;

public class WebUtil {
    private static final int HDR_STR = 128;
    private static final int HDR_STR_UNC = 255;
    private static HashMap hdrCodesByName = new HashMap();
    private static HashMap hdrNamesByCode = new HashMap();
    private static HashMap mimeTypesByName = new HashMap();
    private static HashMap mimeTypesByCode = new HashMap();
    private static HashMap compsByName = new HashMap();
    private static HashMap compsByCode = new HashMap();
    private static HashMap mNamesByCode = new HashMap();
    private static HashMap mCodesByName = new HashMap();
    private static HashMap httpReasonsByCode = new HashMap();
    private static int verifyCount;

    public static String readStr(InputStream inputStream) throws IOException {
        char c;
        StringBuffer stringBuffer = new StringBuffer();
        do {
            if ((c = (char)inputStream.read()) > '\u007f') {
                throw new IOException("invalid char:" + c);
            }
            if (c <= '\u0000') continue;
            stringBuffer.append(c);
        } while (c > '\u0000');
        return stringBuffer.toString();
    }

    public static int readU2(InputStream inputStream) throws IOException {
        return inputStream.read() << 8 | inputStream.read();
    }

    public static void writeStr(String string, OutputStream outputStream) throws IOException {
        try {
            byte[] byArray = string.getBytes("UTF-8");
            outputStream.write(byArray, 0, byArray.length);
        }
        catch (Exception exception) {
            throw new IOException(exception.getMessage());
        }
        outputStream.write(0);
    }

    public static void writeU2(int n, OutputStream outputStream) throws IOException {
        outputStream.write(n >> 8 & 0xFF);
        outputStream.write(n & 0xFF);
    }

    public static String readHeader(int n, InputStream inputStream) throws IOException {
        Compressor compressor = WebUtil.getCompressor(n & 0xFFFFFF7F);
        if (compressor != null) {
            if ((n & 0x80) != 0) {
                return compressor.decompress(WebUtil.readStr(inputStream));
            }
            return compressor.decompress(WebUtil.readU2(inputStream));
        }
        return WebUtil.readStr(inputStream);
    }

    public static void writeHeader(Object object, Object object2, OutputStream outputStream) throws IOException {
        Compressor compressor = WebUtil.getCompressor(object.toString());
        if (compressor == null) {
            return;
        }
        int n = WebUtil.compressHeaderName(object.toString());
        int n2 = -1;
        try {
            n2 = compressor.compress(object2.toString());
        }
        catch (IOException iOException) {
            System.out.println("Cannot compress header: " + object + ": " + object2 + " >>>" + iOException.toString());
            return;
        }
        if (n < 0) {
            outputStream.write(255);
            WebUtil.writeStr(object.toString(), outputStream);
            WebUtil.writeStr(object2.toString(), outputStream);
        }
        if (n2 >= 0) {
            outputStream.write(n);
            WebUtil.writeU2(n2, outputStream);
        } else {
            outputStream.write(n | 0x80);
            WebUtil.writeStr(object2.toString(), outputStream);
        }
    }

    public static int compressHeaderName(String string) {
        Integer n = (Integer)hdrCodesByName.get(string);
        return n != null ? n : -1;
    }

    public static String decompressHeaderName(int n) {
        return (String)hdrNamesByCode.get(new Integer(n & 0xFFFFFF7F));
    }

    public static int compressMethod(String string) {
        Integer n = (Integer)mCodesByName.get(string);
        return n != null ? n : -1;
    }

    public static String decompressMethod(int n) {
        return (String)mNamesByCode.get(new Integer(n));
    }

    public static int compressStatusCode(int n) {
        return n / 100 << 5 | n % 100 & 0x1F;
    }

    public static int decompressStatusCode(int n) {
        return ((n &= 0xFF) >> 5) * 100 + (n & 0x1F);
    }

    public static String httpCodeToReason(int n) {
        String string = (String)httpReasonsByCode.get(new Integer(n));
        return string != null ? string : "-";
    }

    public static long compressMaxAge(String string) throws IOException {
        return (long)MaxAgeCompressor.INST.compress(string) * 1000L;
    }

    public static int compressInt(String string) throws IOException {
        return IntCompressor.INST.compress(string);
    }

    private static final Compressor getCompressor(String string) {
        Compressor compressor = (Compressor)compsByName.get(string);
        return compressor;
    }

    private static final Compressor getCompressor(int n) {
        Compressor compressor = (Compressor)compsByCode.get(new Integer(n));
        return compressor;
    }

    private static final void verify(Object object, Object object2) {
        if (!object.equals(object2)) {
            throw new RuntimeException(object + " != " + object2);
        }
        ++verifyCount;
    }

    private static final void verify(int n, int n2) {
        if (n != n2) {
            throw new RuntimeException(n + " != " + n2);
        }
        ++verifyCount;
    }

    public static void main(String[] stringArray) {
        WebUtil.d("hdrCodesByName:");
        Iterator iterator = hdrCodesByName.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            WebUtil.d(string + " --> " + hdrCodesByName.get(string));
        }
        WebUtil.verify(WebUtil.compressMethod("DELETE"), 68);
        WebUtil.verify(WebUtil.compressMethod("GET"), 71);
        WebUtil.verify(WebUtil.compressMethod("HEAD"), 72);
        WebUtil.verify(WebUtil.compressMethod("OPTIONS"), 79);
        WebUtil.verify(WebUtil.compressMethod("POST"), 80);
        WebUtil.verify(WebUtil.compressMethod("PUT"), 85);
        WebUtil.verify(WebUtil.compressMethod("TRACE"), 84);
        WebUtil.verify(WebUtil.decompressMethod(68), "DELETE");
        WebUtil.verify(WebUtil.decompressMethod(71), "GET");
        WebUtil.verify(WebUtil.decompressMethod(72), "HEAD");
        WebUtil.verify(WebUtil.decompressMethod(79), "OPTIONS");
        WebUtil.verify(WebUtil.decompressMethod(80), "POST");
        WebUtil.verify(WebUtil.decompressMethod(85), "PUT");
        WebUtil.verify(WebUtil.decompressMethod(84), "TRACE");
        WebUtil.verify(WebUtil.compressStatusCode(200), 64);
        WebUtil.verify(WebUtil.decompressStatusCode(64), 200);
        WebUtil.verify(WebUtil.compressStatusCode(400), 128);
        WebUtil.verify(WebUtil.decompressStatusCode(128), 400);
        WebUtil.verify(WebUtil.compressStatusCode(404), 132);
        WebUtil.verify(WebUtil.decompressStatusCode(132), 404);
        WebUtil.verify(WebUtil.compressStatusCode(202), 66);
        WebUtil.verify(WebUtil.decompressStatusCode(66), 202);
        WebUtil.verify(WebUtil.compressStatusCode(100), 32);
        WebUtil.verify(WebUtil.decompressStatusCode(32), 100);
        WebUtil.verify(WebUtil.compressStatusCode(500), 160);
        WebUtil.verify(WebUtil.decompressStatusCode(160), 500);
        try {
            int n = WebUtil.compressHeaderName("Accept");
            WebUtil.d("chn=" + n);
            WebUtil.verify(n, 1);
            Compressor compressor = WebUtil.getCompressor("Accept");
            int n2 = compressor.compress("application/octet-stream,text/plain,text/html");
            WebUtil.d("c=" + n2);
            WebUtil.verify(n2, 40961);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        System.out.println("total verifies: " + verifyCount);
    }

    private static final void d(Object object) {
        System.out.println(object);
    }

    static {
        hdrCodesByName.put("Accept", new Integer(1));
        hdrCodesByName.put("Accept-Charset", new Integer(2));
        hdrCodesByName.put("Accept-Encoding", new Integer(3));
        hdrCodesByName.put("Accept-Language", new Integer(4));
        hdrCodesByName.put("Accept-Ranges", new Integer(5));
        hdrCodesByName.put("Age", new Integer(6));
        hdrCodesByName.put("Allow", new Integer(7));
        hdrCodesByName.put("Authorization", new Integer(8));
        hdrCodesByName.put("Awake-Time", new Integer(9));
        hdrCodesByName.put("Cache-Control", new Integer(10));
        hdrCodesByName.put("Connection", new Integer(11));
        hdrCodesByName.put("Content-Encoding", new Integer(12));
        hdrCodesByName.put("Content-Language", new Integer(13));
        hdrCodesByName.put("Content-Length", new Integer(14));
        hdrCodesByName.put("Content-Location", new Integer(15));
        hdrCodesByName.put("Content-MD5", new Integer(16));
        hdrCodesByName.put("Content-Type", new Integer(17));
        hdrCodesByName.put("Cookie", new Integer(18));
        hdrCodesByName.put("Date", new Integer(19));
        hdrCodesByName.put("ETag", new Integer(20));
        hdrCodesByName.put("Expect", new Integer(21));
        hdrCodesByName.put("Expires", new Integer(22));
        hdrCodesByName.put("From", new Integer(23));
        hdrCodesByName.put("Host", new Integer(24));
        hdrCodesByName.put("If-Match", new Integer(25));
        hdrCodesByName.put("If-Modified-Since", new Integer(26));
        hdrCodesByName.put("If-None-Match", new Integer(27));
        hdrCodesByName.put("If-Range", new Integer(28));
        hdrCodesByName.put("If-Unmodified-Since", new Integer(29));
        hdrCodesByName.put("Last-Modified", new Integer(30));
        hdrCodesByName.put("Location", new Integer(31));
        hdrCodesByName.put("Max-Forwards", new Integer(32));
        hdrCodesByName.put("Pragma", new Integer(33));
        hdrCodesByName.put("Proxy-Authenticate", new Integer(34));
        hdrCodesByName.put("Proxy-Authorization", new Integer(35));
        hdrCodesByName.put("Range", new Integer(36));
        hdrCodesByName.put("Referer", new Integer(37));
        hdrCodesByName.put("Retry-After", new Integer(38));
        hdrCodesByName.put("Server", new Integer(39));
        hdrCodesByName.put("Set-Cookie", new Integer(40));
        hdrCodesByName.put("Sleep-Time", new Integer(41));
        hdrCodesByName.put("TE", new Integer(42));
        hdrCodesByName.put("Transaction-Id", new Integer(43));
        hdrCodesByName.put("Trailer", new Integer(44));
        hdrCodesByName.put("Transfer-Encoding", new Integer(45));
        hdrCodesByName.put("Upgrade", new Integer(46));
        hdrCodesByName.put("User-Agent", new Integer(47));
        hdrCodesByName.put("Vary", new Integer(48));
        hdrCodesByName.put("Via", new Integer(49));
        hdrCodesByName.put("Warning", new Integer(50));
        hdrCodesByName.put("WWW-Authenticate", new Integer(51));
        hdrNamesByCode.put(new Integer(1), "Accept");
        hdrNamesByCode.put(new Integer(2), "Accept-Charset");
        hdrNamesByCode.put(new Integer(3), "Accept-Encoding");
        hdrNamesByCode.put(new Integer(4), "Accept-Language");
        hdrNamesByCode.put(new Integer(5), "Accept-Ranges");
        hdrNamesByCode.put(new Integer(6), "Age");
        hdrNamesByCode.put(new Integer(7), "Allow");
        hdrNamesByCode.put(new Integer(8), "Authorization");
        hdrNamesByCode.put(new Integer(9), "Awake-Time");
        hdrNamesByCode.put(new Integer(10), "Cache-Control");
        hdrNamesByCode.put(new Integer(11), "Connection");
        hdrNamesByCode.put(new Integer(12), "Content-Encoding");
        hdrNamesByCode.put(new Integer(13), "Content-Language");
        hdrNamesByCode.put(new Integer(14), "Content-Length");
        hdrNamesByCode.put(new Integer(15), "Content-Location");
        hdrNamesByCode.put(new Integer(16), "Content-MD5");
        hdrNamesByCode.put(new Integer(17), "Content-Type");
        hdrNamesByCode.put(new Integer(18), "Cookie");
        hdrNamesByCode.put(new Integer(19), "Date");
        hdrNamesByCode.put(new Integer(20), "ETag");
        hdrNamesByCode.put(new Integer(21), "Expect");
        hdrNamesByCode.put(new Integer(22), "Expires");
        hdrNamesByCode.put(new Integer(23), "From");
        hdrNamesByCode.put(new Integer(24), "Host");
        hdrNamesByCode.put(new Integer(25), "If-Match");
        hdrNamesByCode.put(new Integer(26), "If-Modified-Since");
        hdrNamesByCode.put(new Integer(27), "If-None-Match");
        hdrNamesByCode.put(new Integer(28), "If-Range");
        hdrNamesByCode.put(new Integer(29), "If-Unmodified-Since");
        hdrNamesByCode.put(new Integer(30), "Last-Modified");
        hdrNamesByCode.put(new Integer(31), "Location");
        hdrNamesByCode.put(new Integer(32), "Max-Forwards");
        hdrNamesByCode.put(new Integer(33), "Pragma");
        hdrNamesByCode.put(new Integer(34), "Proxy-Authenticate");
        hdrNamesByCode.put(new Integer(35), "Proxy-Authorization");
        hdrNamesByCode.put(new Integer(36), "Range");
        hdrNamesByCode.put(new Integer(37), "Referer");
        hdrNamesByCode.put(new Integer(38), "Retry-After");
        hdrNamesByCode.put(new Integer(39), "Server");
        hdrNamesByCode.put(new Integer(40), "Set-Cookie");
        hdrNamesByCode.put(new Integer(41), "Sleep-Time");
        hdrNamesByCode.put(new Integer(42), "TE");
        hdrNamesByCode.put(new Integer(43), "Transaction-Id");
        hdrNamesByCode.put(new Integer(44), "Trailer");
        hdrNamesByCode.put(new Integer(45), "Transfer-Encoding");
        hdrNamesByCode.put(new Integer(46), "Upgrade");
        hdrNamesByCode.put(new Integer(47), "User-Agent");
        hdrNamesByCode.put(new Integer(48), "Vary");
        hdrNamesByCode.put(new Integer(49), "Via");
        hdrNamesByCode.put(new Integer(50), "Warning");
        hdrNamesByCode.put(new Integer(51), "WWW-Authenticate");
        mimeTypesByName.put("text/plain", new Integer(45057));
        mimeTypesByName.put("text/html", new Integer(45058));
        mimeTypesByName.put("text/xml", new Integer(45059));
        mimeTypesByName.put("text/csv", new Integer(45060));
        mimeTypesByName.put("application/octet-stream", new Integer(40961));
        mimeTypesByCode.put(new Integer(40961), "application/octet-stream");
        mimeTypesByCode.put(new Integer(45057), "text/plain");
        mimeTypesByCode.put(new Integer(45058), "text/html");
        mimeTypesByCode.put(new Integer(45059), "text/xml");
        mimeTypesByCode.put(new Integer(45060), "text/csv");
        compsByName.put("Accept", MimeTypeCompressor.INST);
        compsByName.put("Age", IntCompressor.INST);
        compsByName.put("Awake-Time", IntCompressor.INST);
        compsByName.put("Cache-Control", MaxAgeCompressor.INST);
        compsByName.put("Content-Length", IntCompressor.INST);
        compsByName.put("Content-Type", MimeTypeCompressor.INST);
        compsByName.put("ETag", IntCompressor.INST);
        compsByName.put("Expect", IntCompressor.INST);
        compsByName.put("If-Match", IntCompressor.INST);
        compsByName.put("If-None-Match", IntCompressor.INST);
        compsByName.put("Max-Forwards", IntCompressor.INST);
        compsByName.put("Retry-After", IntCompressor.INST);
        compsByName.put("Sleep-Time", IntCompressor.INST);
        compsByName.put("Transaction-Id", IntCompressor.INST);
        compsByName.put("Warning", IntCompressor.INST);
        compsByCode.put(new Integer(1), MimeTypeCompressor.INST);
        compsByCode.put(new Integer(6), IntCompressor.INST);
        compsByCode.put(new Integer(9), IntCompressor.INST);
        compsByCode.put(new Integer(10), MaxAgeCompressor.INST);
        compsByCode.put(new Integer(14), IntCompressor.INST);
        compsByCode.put(new Integer(17), MimeTypeCompressor.INST);
        compsByCode.put(new Integer(20), IntCompressor.INST);
        compsByCode.put(new Integer(21), IntCompressor.INST);
        compsByCode.put(new Integer(25), IntCompressor.INST);
        compsByCode.put(new Integer(27), IntCompressor.INST);
        compsByCode.put(new Integer(32), IntCompressor.INST);
        compsByCode.put(new Integer(38), IntCompressor.INST);
        compsByCode.put(new Integer(41), IntCompressor.INST);
        compsByCode.put(new Integer(43), IntCompressor.INST);
        compsByCode.put(new Integer(50), IntCompressor.INST);
        mNamesByCode.put(new Integer(68), "DELETE");
        mNamesByCode.put(new Integer(71), "GET");
        mNamesByCode.put(new Integer(72), "HEAD");
        mNamesByCode.put(new Integer(79), "OPTIONS");
        mNamesByCode.put(new Integer(80), "POST");
        mNamesByCode.put(new Integer(85), "PUT");
        mNamesByCode.put(new Integer(84), "TRACE");
        mCodesByName.put("DELETE", new Integer(68));
        mCodesByName.put("GET", new Integer(71));
        mCodesByName.put("HEAD", new Integer(72));
        mCodesByName.put("OPTIONS", new Integer(79));
        mCodesByName.put("POST", new Integer(80));
        mCodesByName.put("PUT", new Integer(85));
        mCodesByName.put("TRACE", new Integer(84));
        httpReasonsByCode.put(new Integer(200), "OK");
        httpReasonsByCode.put(new Integer(202), "Accepted");
        httpReasonsByCode.put(new Integer(204), "No Content");
        httpReasonsByCode.put(new Integer(301), "Moved Permanently");
        httpReasonsByCode.put(new Integer(304), "Not Modified");
        httpReasonsByCode.put(new Integer(307), "Temporary Redirect");
        httpReasonsByCode.put(new Integer(400), "Bad Request");
        httpReasonsByCode.put(new Integer(401), "Unauthorized");
        httpReasonsByCode.put(new Integer(404), "Not Found");
        httpReasonsByCode.put(new Integer(408), "Request Timeout");
        httpReasonsByCode.put(new Integer(500), "Internal Server Error");
        httpReasonsByCode.put(new Integer(501), "Not Implemented");
        httpReasonsByCode.put(new Integer(502), "Bad Gateway");
        httpReasonsByCode.put(new Integer(504), "Gateway Timeout");
        verifyCount = 0;
    }

    static class Compressor {
        public static final Compressor INST = new Compressor();

        int compress(String string) throws IOException {
            return -1;
        }

        String decompress(int n) throws IOException {
            return String.valueOf(n);
        }

        String decompress(String string) throws IOException {
            return string;
        }

        Compressor() {
        }
    }

    static class MaxAgeCompressor
    extends Compressor {
        public static final Compressor INST = new MaxAgeCompressor();

        int compress(String string) throws IOException {
            try {
                int n = string.indexOf("max-age=");
                if (n >= 0) {
                    return Integer.parseInt(string.substring(n + 8));
                }
                return -1;
            }
            catch (NumberFormatException numberFormatException) {
                throw new IOException(numberFormatException.getMessage());
            }
        }

        String decompress(int n) {
            return "max-age=" + n;
        }

        MaxAgeCompressor() {
        }
    }

    static class IntCompressor
    extends Compressor {
        public static final IntCompressor INST = new IntCompressor();

        public int compress(String string) throws IOException {
            try {
                char c = Integer.decode(string).intValue();
                return c < '\u0000' || c > (char)-1 ? (char)'\uffffffff' : c;
            }
            catch (NumberFormatException numberFormatException) {
                throw new IOException(numberFormatException.getMessage());
            }
        }

        IntCompressor() {
        }
    }

    static class MimeTypeCompressor
    extends Compressor {
        public static final Compressor INST = new MimeTypeCompressor();

        public int compress(String string) {
            int n = string.indexOf(",");
            String string2 = n >= 0 ? string.substring(0, n) : string;
            Integer n2 = (Integer)mimeTypesByName.get(string2);
            return n2 != null ? n2 : -1;
        }

        public String decompress(int n) {
            String string = (String)mimeTypesByCode.get(new Integer(n));
            return string != null ? string : "";
        }

        MimeTypeCompressor() {
        }
    }

    static class UnsupportedCompressor
    extends Compressor {
        public static final Compressor INST = new UnsupportedCompressor();

        int compress(String string) throws IOException {
            throw new IOException("Unsupported Header");
        }

        String decompress(int n) throws IOException {
            throw new IOException("Unsupported Header");
        }

        String decompress(String string) throws IOException {
            throw new IOException("Unsupported Header");
        }

        UnsupportedCompressor() {
        }
    }

    static class AvoidCompressor
    extends Compressor {
        public static final Compressor INST = new AvoidCompressor();

        int compress(String string) {
            System.out.println("Warning: use max-age directive instead!");
            return -1;
        }

        String decompress(int n) {
            return String.valueOf(n);
        }

        String decompress(String string) {
            return string;
        }

        AvoidCompressor() {
        }
    }
}

