/*
 * Decompiled with CFR 0.152.
 */
package sedonac.analysis;

import java.util.ArrayList;
import sedonac.analysis.DepthFirstIterator;
import sedonac.ast.Stmt;

public final class BasicBlock {
    private static int gid = 0;
    protected final int id;
    protected ArrayList stmts = new ArrayList();
    protected ArrayList backEdges = new ArrayList();
    protected ArrayList jumpEdges = new ArrayList();

    public final void addJump(BasicBlock basicBlock) {
        this.jumpEdges.add(basicBlock);
        basicBlock.backEdges.add(this);
    }

    public final void removeJump(BasicBlock basicBlock) {
        this.jumpEdges.remove(basicBlock);
        basicBlock.backEdges.remove(this);
    }

    public final Stmt[] stmts() {
        return this.stmts.toArray(new Stmt[this.stmts.size()]);
    }

    public final void addStmt(Stmt stmt) {
        this.stmts.add(stmt);
    }

    public final boolean hasStmts() {
        return this.stmts.isEmpty() ^ true;
    }

    public final Stmt getFirstStmt() {
        return this.stmts.isEmpty() ? null : (Stmt)this.stmts.get(0);
    }

    public final Stmt getLastStmt() {
        return this.stmts.isEmpty() ? null : (Stmt)this.stmts.get(this.stmts.size() - 1);
    }

    public final boolean hasPathTo(BasicBlock basicBlock) {
        DepthFirstIterator depthFirstIterator = new DepthFirstIterator(this);
        while (depthFirstIterator.hasNext()) {
            if (depthFirstIterator.next() != basicBlock) continue;
            return true;
        }
        return false;
    }

    public final String toString() {
        StringBuffer stringBuffer = new StringBuffer("Block [").append(this.id).append("]\n");
        stringBuffer.append("jump: ").append(this.listEdges(this.jumpEdges)).append("\n");
        stringBuffer.append("back: ").append(this.listEdges(this.backEdges)).append("\n");
        if (!this.hasStmts()) {
            return stringBuffer.append("<empty>\n").toString();
        }
        int n = 0;
        while (n < this.stmts.size()) {
            Stmt stmt = (Stmt)this.stmts.get(n);
            stringBuffer.append(n).append(": ");
            if (stmt.label != null) {
                stringBuffer.append(stmt.label).append(": ");
            }
            stringBuffer.append(BasicBlock.toStmtString(stmt)).append('\n');
            ++n;
        }
        return stringBuffer.toString();
    }

    private final String listEdges(ArrayList arrayList) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < arrayList.size()) {
            if (n > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(((BasicBlock)arrayList.get((int)n)).id);
            ++n;
        }
        return stringBuffer.toString();
    }

    public static final String toStmtString(Stmt stmt) {
        StringBuffer stringBuffer = new StringBuffer();
        switch (stmt.id) {
            case 11: {
                stringBuffer.append("assert(").append(((Stmt.Assert)stmt).cond).append(')');
                break;
            }
            case 1: {
                stringBuffer.append(((Stmt.ExprStmt)stmt).expr);
                break;
            }
            case 2: {
                Stmt.LocalDef localDef = (Stmt.LocalDef)stmt;
                stringBuffer.append(localDef);
                if (localDef.init == null) break;
                stringBuffer.append(" = ").append(localDef.init);
                break;
            }
            case 4: {
                stringBuffer.append("if (").append(((Stmt.If)stmt).cond).append(')');
                break;
            }
            case 7: {
                stringBuffer.append("while (").append(((Stmt.While)stmt).cond).append(')');
                break;
            }
            case 8: {
                stringBuffer.append("do_while (").append(((Stmt.DoWhile)stmt).cond).append(')');
                break;
            }
            case 13: {
                stringBuffer.append("switch(").append(((Stmt.Switch)stmt).cond).append(')');
                break;
            }
            case 6: {
                Stmt.Foreach foreach = (Stmt.Foreach)stmt;
                stringBuffer.append("foreach(").append(foreach.local).append(": ").append(foreach.array);
                if (foreach.length != null) {
                    stringBuffer.append(", ").append(foreach.length);
                }
                stringBuffer.append(')');
                break;
            }
            case 12: {
                stringBuffer.append("goto ").append(((Stmt.Goto)stmt).destLabel);
                break;
            }
            case 3: {
                Stmt.Return return_ = (Stmt.Return)stmt;
                stringBuffer.append("return");
                if (return_.expr == null) break;
                stringBuffer.append(' ').append(return_.expr);
                break;
            }
            case 9: {
                stringBuffer.append("break");
                break;
            }
            case 10: {
                stringBuffer.append("continue");
                break;
            }
            default: {
                stringBuffer.append(stmt);
            }
        }
        return stringBuffer.toString();
    }

    public BasicBlock() {
        this.id = gid++;
    }
}

