/*
 * Decompiled with CFR 0.152.
 */
package sedonac.test;

import sedonac.Compiler;
import sedonac.ast.Expr;
import sedonac.parser.Parser;
import sedonac.test.Test;

public class ParserTest
extends Test {
    public void testExpr() {
        this.verifyLiteral(this.expr("true"), 1, Boolean.TRUE);
        this.verifyLiteral(this.expr("false"), 2, Boolean.FALSE);
        this.verifyLiteral(this.expr("0xab"), 3, new Integer(171));
        this.verifyLiteral(this.expr("2.4"), 5, new Float(2.4f));
        this.verifyLiteral(this.expr("\"hi\""), 9, "hi");
        this.verifyLiteral(this.expr("null"), 8, null);
        this.verifyName(this.expr("foo"), "foo");
        this.verifyName(this.verifyName(this.expr("foo.bar"), "bar"), "foo");
        this.verifyName(this.verifyName(this.verifyName(this.expr("foo.bar.roo"), "roo"), "bar"), "foo");
        this.verifyName(this.verifyUnary(this.expr("-x"), 20), "x");
        this.verifyName(this.verifyUnary(this.expr("!x"), 21), "x");
        this.verifyName(this.verifyUnary(this.expr("~x"), 22), "x");
        this.verifyName(this.verifyUnary(this.expr("++x"), 23), "x");
        this.verifyName(this.verifyUnary(this.expr("--x"), 24), "x");
        this.verifyName(this.verifyUnary(this.expr("x++"), 25), "x");
        this.verifyName(this.verifyUnary(this.expr("x--"), 26), "x");
        this.verifyBinary(this.expr("a = b"), 45);
        this.verifyBinary(this.expr("a == b"), 29);
        this.verifyBinary(this.expr("a != b"), 30);
        this.verifyBinary(this.expr("a > b"), 31);
        this.verifyBinary(this.expr("a >= b"), 32);
        this.verifyBinary(this.expr("a < b"), 33);
        this.verifyBinary(this.expr("a <= b"), 34);
        this.verifyBinary(this.expr("a | b"), 35);
        this.verifyBinary(this.expr("a ^ b"), 36);
        this.verifyBinary(this.expr("a & b"), 37);
        this.verifyBinary(this.expr("a << b"), 38);
        this.verifyBinary(this.expr("a >> b"), 39);
        this.verifyBinary(this.expr("a * b"), 40);
        this.verifyBinary(this.expr("a / b"), 41);
        this.verifyBinary(this.expr("a % b"), 42);
        this.verifyBinary(this.expr("a + b"), 43);
        this.verifyBinary(this.expr("a - b"), 44);
        this.verifyCond(this.expr("a || b"), 27);
        this.verifyCond(this.expr("a && b"), 28);
        this.verifyCond(this.expr("a && b && c"), 28);
        this.verifyCond(this.expr("a || b || c || d"), 27);
        Expr.Ternary ternary = (Expr.Ternary)this.expr("c ? t : f");
        this.verifyEq(ternary.id, 57);
        this.verifyName(ternary.cond, "c");
        this.verifyName(ternary.trueExpr, "t");
        this.verifyName(ternary.falseExpr, "f");
        this.verifyCall(this.expr("c()"), "c", new String[0]);
        this.verifyCall(this.expr("c(a)"), "c", new String[]{"a"});
        this.verifyCall(this.expr("c(a, b)"), "c", new String[]{"a", "b"});
        this.verifyCall(this.expr("c(a, b, c)"), "c", new String[]{"a", "b", "c"});
        this.verifyCall(this.verifyName(this.expr("c(a, b).foo"), "foo"), "c", new String[]{"a", "b"});
        this.verifyCall(this.verifyCall(this.verifyCall(this.expr("x().y().z()"), "z", null), "y", null), "x", null);
        Expr.Index index = (Expr.Index)this.expr("x[i][j]");
        this.verifyEq(index.id, 64);
        this.verifyName(index.index, "j");
        this.verifyEq(index.target.id, 64);
        this.verifyName(((Expr.Index)index.target).target, "x");
        this.verifyName(((Expr.Index)index.target).index, "i");
        Expr.Cond cond = (Expr.Cond)this.expr("a+b*c|d&&e*(f+g)");
        Expr.Binary binary = (Expr.Binary)cond.operands.get(0);
        Expr.Binary binary2 = (Expr.Binary)binary.lhs;
        Expr.Name name = (Expr.Name)binary2.lhs;
        this.verifyName(name, "a");
        Expr.Binary binary3 = (Expr.Binary)binary2.rhs;
        Expr.Name name2 = (Expr.Name)binary3.lhs;
        this.verifyName(name2, "b");
        Expr.Name name3 = (Expr.Name)binary3.rhs;
        this.verifyName(name3, "c");
        Expr.Name name4 = (Expr.Name)binary.rhs;
        this.verifyName(name4, "d");
        Expr.Binary binary4 = (Expr.Binary)cond.operands.get(1);
        Expr.Name name5 = (Expr.Name)binary4.lhs;
        this.verifyName(name5, "e");
        Expr.Binary binary5 = (Expr.Binary)binary4.rhs;
        Expr.Name name6 = (Expr.Name)binary5.lhs;
        this.verifyName(name6, "f");
        Expr.Name name7 = (Expr.Name)binary5.rhs;
        this.verifyName(name7, "g");
    }

    void verifyLiteral(Expr expr, int n, Object object) {
        Expr.Literal literal = (Expr.Literal)expr;
        this.verifyEq(literal.id, n);
        this.verifyEq(literal.value, object);
    }

    Expr verifyName(Expr expr, String string) {
        Expr.Name name = (Expr.Name)expr;
        this.verifyEq(name.id, 58);
        this.verifyEq(name.name, string);
        return name.target;
    }

    Expr verifyUnary(Expr expr, int n) {
        Expr.Unary unary = (Expr.Unary)expr;
        this.verifyEq(unary.id, n);
        return unary.operand;
    }

    void verifyBinary(Expr expr, int n) {
        Expr.Binary binary = (Expr.Binary)expr;
        this.verifyEq(binary.id, n);
        this.verifyName(binary.lhs, "a");
        this.verifyName(binary.rhs, "b");
    }

    void verifyCond(Expr expr, int n) {
        Expr.Cond cond = (Expr.Cond)expr;
        this.verifyEq(cond.id, n);
        int n2 = 0;
        while (n2 < cond.operands.size()) {
            this.verifyName((Expr)cond.operands.get(n2), "" + (char)(97 + n2));
            ++n2;
        }
    }

    Expr verifyCall(Expr expr, String string, String[] stringArray) {
        if (stringArray == null) {
            stringArray = new String[]{};
        }
        Expr.Call call = (Expr.Call)expr;
        this.verifyEq(call.id, 65);
        this.verifyEq(call.name, string);
        this.verifyEq(call.args.length, stringArray.length);
        int n = 0;
        while (n < stringArray.length) {
            this.verifyEq(((Expr.Name)call.args[n]).name, stringArray[n]);
            ++n;
        }
        return call.target;
    }

    Expr expr(String string) {
        Parser parser = new Parser(new Compiler(), string);
        parser.readTokens();
        return parser.expr();
    }
}

