/*
 * Decompiled with CFR 0.152.
 */
package sedonac.steps;

import java.util.ArrayList;
import java.util.HashMap;
import sedonac.Compiler;
import sedonac.CompilerStep;
import sedonac.Location;
import sedonac.ir.IrMethod;
import sedonac.ir.IrSlot;
import sedonac.ir.IrType;
import sedonac.ir.IrVTable;
import sedonac.scode.SCodeImage;

public class VTableLayout
extends CompilerStep {
    SCodeImage image;
    Location loc;

    public void run() {
        this.log.debug("  VTableLayout");
        int n = 0;
        while (n < this.flat.virtTypes.length) {
            this.layout(this.flat.virtTypes[n]);
            ++n;
        }
        this.quitIfErrors();
    }

    private final void layout(IrType irType) {
        IrMethod irMethod;
        int n;
        Object object;
        ArrayList<IrMethod> arrayList = new ArrayList<IrMethod>();
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        if (!irType.isVirtual()) {
            object = ((IrType)irType.base).vtable;
            if (object == null) {
                throw new IllegalStateException(irType.qname());
            }
            n = 0;
            while (n < object.methods.length) {
                irMethod = object.methods[n];
                irMethod.vindex = arrayList.size();
                hashMap.put(irMethod.name, new Integer(irMethod.vindex));
                arrayList.add(irMethod);
                ++n;
            }
        }
        object = irType.declared;
        n = 0;
        while (n < ((IrSlot[])object).length) {
            if (!object[n].isField()) {
                irMethod = (IrMethod)object[n];
                if (irMethod.isOverride()) {
                    Integer n2 = (Integer)hashMap.get(irMethod.name);
                    if (n2 == null) {
                        this.err("Unknown override '" + irMethod.qname + '\'');
                    } else {
                        irMethod.vindex = n2;
                        arrayList.set(irMethod.vindex, irMethod);
                    }
                } else if (irMethod.isVirtual()) {
                    irMethod.vindex = arrayList.size();
                    hashMap.put(irMethod.name, new Integer(irMethod.vindex));
                    arrayList.add(irMethod);
                }
            }
            ++n;
        }
        irType.vtable = new IrVTable();
        irType.vtable.methods = arrayList.toArray(new IrMethod[arrayList.size()]);
    }

    private final void dump() {
        int n = 0;
        while (n < this.flat.types.length) {
            this.dump(this.flat.types[n]);
            ++n;
        }
    }

    private final void dump(IrType irType) {
        if (irType.vtable == null) {
            return;
        }
        System.out.println("---- " + irType.qname + " vtable ----");
        int n = 0;
        while (n < irType.vtable.methods.length) {
            IrMethod irMethod = irType.vtable.methods[n];
            String string = irMethod == null ? "null" : irMethod.qname;
            System.out.println("  " + n + ":  " + string);
            ++n;
        }
    }

    public VTableLayout(Compiler compiler) {
        super(compiler);
        this.image = compiler.image;
    }
}

