/*
 * Decompiled with CFR 0.152.
 */
package com.kodaro.tenant;

import com.kodaro.tenant.BInvoiceRecord;
import com.kodaro.tenant.BInvoiceStrings;
import com.kodaro.tenant.BInvoices;
import com.kodaro.tenant.BMeter;
import com.kodaro.tenant.BMeterSummary;
import com.kodaro.tenant.BSuite;
import com.kodaro.tenant.ui.BConsolidatedMeters;
import com.kodaro.tenant.util.BComplexTable;
import com.tridium.pdf.BITableToPdf;
import com.tridium.pdf.BPxViewToPdf;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.OutputStream;
import java.util.Vector;
import javax.baja.agent.AgentInfo;
import javax.baja.agent.BAbstractPxView;
import javax.baja.agent.BPxView;
import javax.baja.collection.TableCursor;
import javax.baja.data.BIDataValue;
import javax.baja.email.BBlobPart;
import javax.baja.email.BEmail;
import javax.baja.email.BEmailAddress;
import javax.baja.email.BEmailAddressList;
import javax.baja.email.BEmailPartList;
import javax.baja.email.BEmailService;
import javax.baja.file.ExportOp;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdTarget;
import javax.baja.pdf.BPdfExporter;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBlob;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDouble;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BInteger;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BInvoice
extends BComponent {
    public static final String PX = "module://kodarotenant/px/";
    public static final Property invoiceNumber = BInvoice.newProperty((int)256, (String)"INV1000", null);
    public static final Property start = BInvoice.newProperty((int)256, (BValue)BAbsTime.NULL, (BFacets)BFacets.make((String)"showTimeZone", (BIDataValue)BBoolean.FALSE));
    public static final Property end = BInvoice.newProperty((int)256, (BValue)BAbsTime.NULL, (BFacets)BFacets.make((String)"showTimeZone", (BIDataValue)BBoolean.FALSE));
    public static final Property charges = BInvoice.newProperty((int)256, (double)0.0, (BFacets)BInvoice.makeMoneyFacets());
    public static final Property adjustment = BInvoice.newProperty((int)256, (double)0.0, (BFacets)BInvoice.makeMoneyFacets());
    public static final Property tax = BInvoice.newProperty((int)257, (double)0.0, (BFacets)BInvoice.makeMoneyFacets());
    public static final Property subtotal = BInvoice.newProperty((int)257, (double)0.0, (BFacets)BInvoice.makeMoneyFacets());
    public static final Property total = BInvoice.newProperty((int)257, (double)0.0, (BFacets)BInvoice.makeMoneyFacets());
    public static final Property comments1 = BInvoice.newProperty((int)256, (String)"", null);
    public static final Property comments2 = BInvoice.newProperty((int)256, (String)"", null);
    public static final Property comments3 = BInvoice.newProperty((int)256, (String)"", null);
    public static final Property fee1Enabled = BInvoice.newProperty((int)256, (boolean)false, null);
    public static final Property fee2Enabled = BInvoice.newProperty((int)256, (boolean)false, null);
    public static final Property fee3Enabled = BInvoice.newProperty((int)256, (boolean)false, null);
    public static final Property minInvoiceEnabled = BInvoice.newProperty((int)256, (boolean)false, null);
    public static final Property invoiceFrom = BInvoice.newProperty((int)256, (BValue)BEmailAddress.NULL, null);
    public static final Property invoiceCc = BInvoice.newProperty((int)256, (BValue)BEmailAddressList.NULL, null);
    public static final Property invoiceBcc = BInvoice.newProperty((int)256, (BValue)BEmailAddressList.NULL, null);
    public static final Property ownerName = BInvoice.newProperty((int)256, (String)"Owner", null);
    public static final Property ownerLine1 = BInvoice.newProperty((int)256, (String)"15375 Barranca Pkwy", null);
    public static final Property ownerLine2 = BInvoice.newProperty((int)256, (String)"Tenant I-104", null);
    public static final Property ownerLine3 = BInvoice.newProperty((int)256, (String)"Irvine, CA 92618", null);
    public static final Property ownerLine4 = BInvoice.newProperty((int)256, (String)"Phone: (949) 788-0701", null);
    public static final Property ownerLine5 = BInvoice.newProperty((int)256, (String)"Fax: (949) 788-0797", null);
    public static final Property ownerLine6 = BInvoice.newProperty((int)256, (String)"http://www.kodaro.com", null);
    public static final Property minInvoice = BInvoice.newProperty((int)256, (double)0.0, (BFacets)BInvoice.makeMoneyFacets());
    public static final Property fee1 = BInvoice.newProperty((int)256, (double)0.0, (BFacets)BInvoice.makeMoneyFacets());
    public static final Property fee1Description = BInvoice.newProperty((int)256, (String)"Fees", (BFacets)BFacets.make((String)"fieldWidth", (BIDataValue)BInteger.make((int)15)));
    public static final Property fee2 = BInvoice.newProperty((int)256, (double)0.0, (BFacets)BInvoice.makeMoneyFacets());
    public static final Property fee2Description = BInvoice.newProperty((int)256, (String)"Fees", (BFacets)BFacets.make((String)"fieldWidth", (BIDataValue)BInteger.make((int)15)));
    public static final Property fee3 = BInvoice.newProperty((int)256, (double)0.0, (BFacets)BInvoice.makeMoneyFacets());
    public static final Property fee3Description = BInvoice.newProperty((int)256, (String)"Fees", (BFacets)BFacets.make((String)"fieldWidth", (BIDataValue)BInteger.make((int)15)));
    public static final Property taxRate = BInvoice.newProperty((int)256, (double)0.0, (BFacets)BFacets.makeNumeric(null, (int)5, (double)0.0, (double)1.0));
    public static final Property emailRecipients = BInvoice.newProperty((int)256, (BValue)BEmailAddressList.NULL, null);
    public static final Property emailSubject = BInvoice.newProperty((int)256, (String)"Invoice", null);
    public static final Property emailBody = BInvoice.newProperty((int)256, (String)"See attached.", null);
    public static final Property account = BInvoice.newProperty((int)256, (String)"", null);
    public static final Property tenantName = BInvoice.newProperty((int)256, (String)"", null);
    public static final Property tenantLine1 = BInvoice.newProperty((int)256, (String)"", null);
    public static final Property tenantLine2 = BInvoice.newProperty((int)256, (String)"", null);
    public static final Property tenantLine3 = BInvoice.newProperty((int)256, (String)"", null);
    public static final Property tenantLine4 = BInvoice.newProperty((int)256, (String)"", null);
    public static final Property tenantLine5 = BInvoice.newProperty((int)256, (String)"", null);
    public static final Property tenantLine6 = BInvoice.newProperty((int)256, (String)"", null);
    public static final Property invoiceText1 = BInvoice.newProperty((int)256, (String)"", null);
    public static final Property invoiceText2 = BInvoice.newProperty((int)256, (String)"", null);
    public static final Property invoiceText3 = BInvoice.newProperty((int)256, (String)"", null);
    public static final Property invoiceText4 = BInvoice.newProperty((int)256, (String)"", null);
    public static final Property invoiceText5 = BInvoice.newProperty((int)256, (String)"", null);
    public static final Property invoiceText6 = BInvoice.newProperty((int)256, (String)"", null);
    public static final Property Invoice = BInvoice.newProperty((int)4, (BValue)new BPxView(BOrd.make((String)"module://kodarotenant/px/Invoice.px")), null);
    public static final Property InvoiceExport = BInvoice.newProperty((int)4, (BValue)new BPxView(BOrd.make((String)"module://kodarotenant/px/InvoiceExport.px")), null);
    public static final Property OwnerInvoice = BInvoice.newProperty((int)4, (BValue)new BPxView(BOrd.make((String)"module://kodarotenant/px/OwnerInvoice.px")), null);
    public static final Action sendEmail = BInvoice.newAction((int)272, null);
    public static final Action getLineItems = BInvoice.newAction((int)260, null);
    public static final Action getMeterSummaries = BInvoice.newAction((int)260, null);
    public static final Action recalculate = BInvoice.newAction((int)276, null);
    public static final Action recalculateSendEmail = BInvoice.newAction((int)276, null);
    public static final Type TYPE = Sys.loadType(BInvoice.class);
    private static BIcon icon = BIcon.std((String)"dollarBill.png");

    public String getInvoiceNumber() {
        return this.getString(invoiceNumber);
    }

    public void setInvoiceNumber(String v) {
        this.setString(invoiceNumber, v, null);
    }

    public BAbsTime getStart() {
        return (BAbsTime)this.get(start);
    }

    public void setStart(BAbsTime v) {
        this.set(start, (BValue)v, null);
    }

    public BAbsTime getEnd() {
        return (BAbsTime)this.get(end);
    }

    public void setEnd(BAbsTime v) {
        this.set(end, (BValue)v, null);
    }

    public double getCharges() {
        return this.getDouble(charges);
    }

    public void setCharges(double v) {
        this.setDouble(charges, v, null);
    }

    public double getAdjustment() {
        return this.getDouble(adjustment);
    }

    public void setAdjustment(double v) {
        this.setDouble(adjustment, v, null);
    }

    public double getTax() {
        return this.getDouble(tax);
    }

    public void setTax(double v) {
        this.setDouble(tax, v, null);
    }

    public double getSubtotal() {
        return this.getDouble(subtotal);
    }

    public void setSubtotal(double v) {
        this.setDouble(subtotal, v, null);
    }

    public double getTotal() {
        return this.getDouble(total);
    }

    public void setTotal(double v) {
        this.setDouble(total, v, null);
    }

    public String getComments1() {
        return this.getString(comments1);
    }

    public void setComments1(String v) {
        this.setString(comments1, v, null);
    }

    public String getComments2() {
        return this.getString(comments2);
    }

    public void setComments2(String v) {
        this.setString(comments2, v, null);
    }

    public String getComments3() {
        return this.getString(comments3);
    }

    public void setComments3(String v) {
        this.setString(comments3, v, null);
    }

    public boolean getFee1Enabled() {
        return this.getBoolean(fee1Enabled);
    }

    public void setFee1Enabled(boolean v) {
        this.setBoolean(fee1Enabled, v, null);
    }

    public boolean getFee2Enabled() {
        return this.getBoolean(fee2Enabled);
    }

    public void setFee2Enabled(boolean v) {
        this.setBoolean(fee2Enabled, v, null);
    }

    public boolean getFee3Enabled() {
        return this.getBoolean(fee3Enabled);
    }

    public void setFee3Enabled(boolean v) {
        this.setBoolean(fee3Enabled, v, null);
    }

    public boolean getMinInvoiceEnabled() {
        return this.getBoolean(minInvoiceEnabled);
    }

    public void setMinInvoiceEnabled(boolean v) {
        this.setBoolean(minInvoiceEnabled, v, null);
    }

    public BEmailAddress getInvoiceFrom() {
        return (BEmailAddress)this.get(invoiceFrom);
    }

    public void setInvoiceFrom(BEmailAddress v) {
        this.set(invoiceFrom, (BValue)v, null);
    }

    public BEmailAddressList getInvoiceCc() {
        return (BEmailAddressList)this.get(invoiceCc);
    }

    public void setInvoiceCc(BEmailAddressList v) {
        this.set(invoiceCc, (BValue)v, null);
    }

    public BEmailAddressList getInvoiceBcc() {
        return (BEmailAddressList)this.get(invoiceBcc);
    }

    public void setInvoiceBcc(BEmailAddressList v) {
        this.set(invoiceBcc, (BValue)v, null);
    }

    public String getOwnerName() {
        return this.getString(ownerName);
    }

    public void setOwnerName(String v) {
        this.setString(ownerName, v, null);
    }

    public String getOwnerLine1() {
        return this.getString(ownerLine1);
    }

    public void setOwnerLine1(String v) {
        this.setString(ownerLine1, v, null);
    }

    public String getOwnerLine2() {
        return this.getString(ownerLine2);
    }

    public void setOwnerLine2(String v) {
        this.setString(ownerLine2, v, null);
    }

    public String getOwnerLine3() {
        return this.getString(ownerLine3);
    }

    public void setOwnerLine3(String v) {
        this.setString(ownerLine3, v, null);
    }

    public String getOwnerLine4() {
        return this.getString(ownerLine4);
    }

    public void setOwnerLine4(String v) {
        this.setString(ownerLine4, v, null);
    }

    public String getOwnerLine5() {
        return this.getString(ownerLine5);
    }

    public void setOwnerLine5(String v) {
        this.setString(ownerLine5, v, null);
    }

    public String getOwnerLine6() {
        return this.getString(ownerLine6);
    }

    public void setOwnerLine6(String v) {
        this.setString(ownerLine6, v, null);
    }

    public double getMinInvoice() {
        return this.getDouble(minInvoice);
    }

    public void setMinInvoice(double v) {
        this.setDouble(minInvoice, v, null);
    }

    public double getFee1() {
        return this.getDouble(fee1);
    }

    public void setFee1(double v) {
        this.setDouble(fee1, v, null);
    }

    public String getFee1Description() {
        return this.getString(fee1Description);
    }

    public void setFee1Description(String v) {
        this.setString(fee1Description, v, null);
    }

    public double getFee2() {
        return this.getDouble(fee2);
    }

    public void setFee2(double v) {
        this.setDouble(fee2, v, null);
    }

    public String getFee2Description() {
        return this.getString(fee2Description);
    }

    public void setFee2Description(String v) {
        this.setString(fee2Description, v, null);
    }

    public double getFee3() {
        return this.getDouble(fee3);
    }

    public void setFee3(double v) {
        this.setDouble(fee3, v, null);
    }

    public String getFee3Description() {
        return this.getString(fee3Description);
    }

    public void setFee3Description(String v) {
        this.setString(fee3Description, v, null);
    }

    public double getTaxRate() {
        return this.getDouble(taxRate);
    }

    public void setTaxRate(double v) {
        this.setDouble(taxRate, v, null);
    }

    public BEmailAddressList getEmailRecipients() {
        return (BEmailAddressList)this.get(emailRecipients);
    }

    public void setEmailRecipients(BEmailAddressList v) {
        this.set(emailRecipients, (BValue)v, null);
    }

    public String getEmailSubject() {
        return this.getString(emailSubject);
    }

    public void setEmailSubject(String v) {
        this.setString(emailSubject, v, null);
    }

    public String getEmailBody() {
        return this.getString(emailBody);
    }

    public void setEmailBody(String v) {
        this.setString(emailBody, v, null);
    }

    public String getAccount() {
        return this.getString(account);
    }

    public void setAccount(String v) {
        this.setString(account, v, null);
    }

    public String getTenantName() {
        return this.getString(tenantName);
    }

    public void setTenantName(String v) {
        this.setString(tenantName, v, null);
    }

    public String getTenantLine1() {
        return this.getString(tenantLine1);
    }

    public void setTenantLine1(String v) {
        this.setString(tenantLine1, v, null);
    }

    public String getTenantLine2() {
        return this.getString(tenantLine2);
    }

    public void setTenantLine2(String v) {
        this.setString(tenantLine2, v, null);
    }

    public String getTenantLine3() {
        return this.getString(tenantLine3);
    }

    public void setTenantLine3(String v) {
        this.setString(tenantLine3, v, null);
    }

    public String getTenantLine4() {
        return this.getString(tenantLine4);
    }

    public void setTenantLine4(String v) {
        this.setString(tenantLine4, v, null);
    }

    public String getTenantLine5() {
        return this.getString(tenantLine5);
    }

    public void setTenantLine5(String v) {
        this.setString(tenantLine5, v, null);
    }

    public String getTenantLine6() {
        return this.getString(tenantLine6);
    }

    public void setTenantLine6(String v) {
        this.setString(tenantLine6, v, null);
    }

    public String getInvoiceText1() {
        return this.getString(invoiceText1);
    }

    public void setInvoiceText1(String v) {
        this.setString(invoiceText1, v, null);
    }

    public String getInvoiceText2() {
        return this.getString(invoiceText2);
    }

    public void setInvoiceText2(String v) {
        this.setString(invoiceText2, v, null);
    }

    public String getInvoiceText3() {
        return this.getString(invoiceText3);
    }

    public void setInvoiceText3(String v) {
        this.setString(invoiceText3, v, null);
    }

    public String getInvoiceText4() {
        return this.getString(invoiceText4);
    }

    public void setInvoiceText4(String v) {
        this.setString(invoiceText4, v, null);
    }

    public String getInvoiceText5() {
        return this.getString(invoiceText5);
    }

    public void setInvoiceText5(String v) {
        this.setString(invoiceText5, v, null);
    }

    public String getInvoiceText6() {
        return this.getString(invoiceText6);
    }

    public void setInvoiceText6(String v) {
        this.setString(invoiceText6, v, null);
    }

    public BPxView getInvoice() {
        return (BPxView)this.get(Invoice);
    }

    public void setInvoice(BPxView v) {
        this.set(Invoice, (BValue)v, null);
    }

    public BPxView getInvoiceExport() {
        return (BPxView)this.get(InvoiceExport);
    }

    public void setInvoiceExport(BPxView v) {
        this.set(InvoiceExport, (BValue)v, null);
    }

    public BPxView getOwnerInvoice() {
        return (BPxView)this.get(OwnerInvoice);
    }

    public void setOwnerInvoice(BPxView v) {
        this.set(OwnerInvoice, (BValue)v, null);
    }

    public void sendEmail() {
        this.invoke(sendEmail, null, null);
    }

    public BComplexTable getLineItems() {
        return (BComplexTable)this.invoke(getLineItems, null, null);
    }

    public BComplexTable getMeterSummaries() {
        return (BComplexTable)this.invoke(getMeterSummaries, null, null);
    }

    public void recalculate() {
        this.invoke(recalculate, null, null);
    }

    public void recalculateSendEmail() {
        this.invoke(recalculateSendEmail, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BComplexTable doGetLineItems() {
        BAbsTime end = this.getEnd();
        end = end.subtract(BRelTime.make((long)1L));
        BMeter[] meters = this.getTenant().getMeters();
        Vector<BInvoiceStrings> v = new Vector<BInvoiceStrings>();
        for (int i = 0; i < meters.length; ++i) {
            BInvoiceRecord[] ary = meters[i].getInvoiceRecords(this.getStart(), end);
            for (int j = 0; j < ary.length; ++j) {
                v.addElement(new BInvoiceStrings(ary[j]));
            }
        }
        BInvoiceStrings[] recs = new BInvoiceStrings[v.size()];
        v.copyInto((Object[])recs);
        return new BComplexTable((BComplex)new BInvoiceStrings(), (BComplex[])recs);
    }

    public BComplexTable doGetMeterSummaries() {
        BAbsTime end = this.getEnd();
        end = end.subtract(BRelTime.make((long)1L));
        BMeter[] meters = this.getTenant().getMeters();
        BMeterSummary[] recs = new BMeterSummary[meters.length];
        for (int i = 0; i < meters.length; ++i) {
            double quantity = 0.0;
            double cost = 0.0;
            double rate = 0.0;
            BInvoiceRecord[] ary = meters[i].getInvoiceRecords(this.getStart(), end);
            int j = ary.length;
            while (--j >= 0) {
                quantity += ary[j].getQuantity();
                cost += ary[j].getCharges();
            }
            if (cost > 0.0) {
                rate = cost / quantity;
            }
            recs[i] = new BMeterSummary();
            recs[i].setMeter(meters[i].getTitle());
            recs[i].setQuantity(quantity, meters[i].getUnitSymbol());
            recs[i].setAverageRate(rate, meters[i].getUnitSymbol());
            recs[i].setAmount(cost, this.getTenant().getOwner().getCurrencySymbol());
        }
        return new BComplexTable((BComplex)new BMeterSummary(), (BComplex[])recs);
    }

    public void doRecalculate() {
        BAbsTime end = this.getEnd();
        end = end.subtract(BRelTime.make((long)1L));
        BInvoiceRecord[] ary = this.getTenant().getInvoiceRecords(this.getStart(), end);
        double amt = 0.0;
        for (int i = 0; i < ary.length; ++i) {
            amt += ary[i].getCharges();
        }
        this.setCharges(amt);
        amt += this.getFee1();
        this.setFee1Enabled(this.getFee1() > 0.0);
        amt += this.getFee2();
        this.setFee2Enabled(this.getFee2() > 0.0);
        amt += this.getFee3();
        this.setFee3Enabled(this.getFee3() > 0.0);
        amt += this.getAdjustment();
        this.setMinInvoiceEnabled(this.getMinInvoice() > 0.0);
        if (amt < this.getMinInvoice()) {
            amt = this.getMinInvoice();
        }
        this.setSubtotal(amt);
        this.setTax(amt * this.getTaxRate());
        this.setTotal(amt += this.getTax());
    }

    public void doRecalculateSendEmail() {
        this.doRecalculate();
        this.doSendEmail();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doSendEmail() {
        BEmailService emailService = (BEmailService)Sys.getService((Type)BEmailService.TYPE);
        if (emailService == null) {
            throw new IllegalStateException("Email Service not found!");
        }
        try {
            if (this.getEmailRecipients().isNull() && this.getInvoiceCc().isNull() && this.getInvoiceBcc().isNull()) {
                throw new IllegalStateException("Invoice starting " + this.getStart() + " has no email recipients");
            }
            if (this.getInvoiceFrom().isNull()) {
                throw new IllegalStateException("Invoice not sent, no owner email: " + this.getTenant().getAccount());
            }
            BPxView view = this.getInvoiceExport();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ExportOp op = ExportOp.make((OrdTarget)this.getNavOrd().resolve((BObject)this), (OutputStream)baos);
            Class<BInvoice> clazz = BInvoice.class;
            synchronized (BInvoice.class) {
                BConsolidatedMeters.invoice = this;
                BPxViewToPdf exporter = new BPxViewToPdf((BAbstractPxView)view);
                exporter.export(op);
                // ** MonitorExit[var5_6] (shouldn't be in output)
                baos.flush();
                BEmail email = new BEmail(this.getEmailRecipients(), this.getEmailSubject(), this.getEmailBody());
                email.setDate(Clock.time());
                email.setFrom(this.getInvoiceFrom());
                if (!this.getInvoiceCc().isNull()) {
                    email.setCc(this.getInvoiceCc());
                }
                if (!this.getInvoiceBcc().isNull()) {
                    email.setBcc(this.getInvoiceBcc());
                }
                BBlobPart blobpart = new BBlobPart("invoice.pdf", BBlob.make((byte[])baos.toByteArray()));
                try {
                    blobpart.setMimeType("application/pdf");
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                BEmailPartList partList = new BEmailPartList();
                partList.add("invoice", (BValue)blobpart);
                switch (this.getTenant().getEmailLineItems().getOrdinal()) {
                    case 1: {
                        partList.add("details", (BValue)this.makeDetailsCsv());
                        break;
                    }
                    case 2: {
                        partList.add("details", (BValue)this.makeDetailsPdf());
                    }
                }
                email.setAttachments(partList);
                emailService.send(email);
            }
        }
        catch (Exception x) {
            this.getTenant().getOwner().handleError(this.getTenant(), "Emailing invoice", x);
        }
    }

    public BIcon getIcon() {
        return icon;
    }

    public BSuite getTenant() {
        for (BComplex c = this.getParent(); c != null; c = c.getParent()) {
            if (!(c instanceof BSuite)) continue;
            return (BSuite)c;
        }
        return null;
    }

    public boolean isParentLegal(BComponent c) {
        return c instanceof BInvoices;
    }

    public static BFacets makeMoneyFacets() {
        return BFacets.make((String)"precision", (BIDataValue)BDouble.make((double)2.0));
    }

    public void set(Object msg) {
    }

    private BBlobPart makeDetailsCsv() throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        dos.writeBytes(this.getAccount());
        dos.writeByte(10);
        dos.writeBytes(this.getTenantName());
        dos.writeByte(10);
        dos.writeByte(10);
        dos.writeBytes("Meter,");
        dos.writeBytes("User,");
        dos.writeBytes("Start,");
        dos.writeBytes("End,");
        dos.writeBytes("Rate,");
        dos.writeBytes("Quantity\n");
        BComplexTable t = this.doGetLineItems();
        TableCursor c = t.cursor();
        String lastMeter = "";
        String curMeter = "";
        while (c.next()) {
            BInvoiceStrings r = (BInvoiceStrings)((Object)c.get());
            curMeter = r.getMeter();
            if (!curMeter.equals(lastMeter)) {
                dos.writeByte(10);
            }
            lastMeter = curMeter;
            dos.writeByte(34);
            dos.writeBytes(r.getMeter());
            dos.writeBytes("\",\"");
            dos.writeBytes(r.getUser());
            dos.writeBytes("\",");
            dos.writeBytes(r.getStart());
            dos.writeByte(44);
            dos.writeBytes(r.getEnd());
            dos.writeByte(44);
            dos.writeBytes(r.getRate());
            dos.writeByte(44);
            dos.writeBytes(r.getQuantity());
            dos.writeByte(10);
        }
        dos.flush();
        BBlobPart ret = new BBlobPart("invoice.csv", BBlob.make((byte[])baos.toByteArray()));
        try {
            ret.setMimeType("text/csv");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return ret;
    }

    private BBlobPart makeDetailsPdf() throws Exception {
        BComplexTable tbl = this.doGetLineItems();
        BPdfExporter ex = null;
        AgentInfo[] list = tbl.getAgents().list();
        for (int i = 0; i < list.length; ++i) {
            if (!list[i].getAgentType().is(BITableToPdf.TYPE)) continue;
            ex = (BPdfExporter)list[i].getInstance();
            break;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        OrdTarget ot = new OrdTarget(this.getNavOrd().resolve((BObject)this), (BObject)tbl);
        ExportOp op = ExportOp.make((OrdTarget)ot, (OutputStream)baos);
        ex.export(op);
        baos.flush();
        BBlobPart ret = new BBlobPart("details.pdf", BBlob.make((byte[])baos.toByteArray()));
        try {
            ret.setMimeType("application/pdf");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return ret;
    }

    public static class Summary {
        public String meter;
        public String quantity;
        public String averageRate;
        public String cost;
    }
}

