/*
 * Decompiled with CFR 0.152.
 */
package com.kodaro.tenant;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.baja.data.BIDataValue;
import javax.baja.history.BHistoryRecord;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BDouble;
import javax.baja.sys.BFacets;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BInvoiceRecord
extends BHistoryRecord {
    public static final Property meter = BInvoiceRecord.newProperty((int)0, (String)"", null);
    public static final Property quantity = BInvoiceRecord.newProperty((int)0, (double)0.0, (BFacets)BFacets.make((String)"precision", (BIDataValue)BDouble.make((double)5.0)));
    public static final Property rate = BInvoiceRecord.newProperty((int)0, (double)0.0, (BFacets)BFacets.make((String)"precision", (BIDataValue)BDouble.make((double)5.0)));
    public static final Property start = BInvoiceRecord.newProperty((int)0, (BValue)BAbsTime.NULL, null);
    public static final Property user = BInvoiceRecord.newProperty((int)0, (String)"", null);
    public static final Type TYPE = Sys.loadType(BInvoiceRecord.class);

    public String getMeter() {
        return this.getString(meter);
    }

    public void setMeter(String v) {
        this.setString(meter, v, null);
    }

    public double getQuantity() {
        return this.getDouble(quantity);
    }

    public void setQuantity(double v) {
        this.setDouble(quantity, v, null);
    }

    public double getRate() {
        return this.getDouble(rate);
    }

    public void setRate(double v) {
        this.setDouble(rate, v, null);
    }

    public BAbsTime getStart() {
        return (BAbsTime)this.get(start);
    }

    public void setStart(BAbsTime v) {
        this.set(start, (BValue)v, null);
    }

    public String getUser() {
        return this.getString(user);
    }

    public void setUser(String v) {
        this.setString(user, v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public double getCharges() {
        double ret = this.getRate() * this.getQuantity();
        if (Double.isNaN(ret)) {
            return 0.0;
        }
        return ret;
    }

    public BRelTime getDuration() {
        return this.getStart().delta(this.getEnd());
    }

    public BAbsTime getEnd() {
        return this.getTimestamp();
    }

    public String getRateString() {
        return this.get(rate).toString((Context)this.getSlotFacets((Slot)rate));
    }

    public String getQuantityString() {
        return this.get(quantity).toString((Context)this.getSlotFacets((Slot)quantity));
    }

    public boolean isFixedSize() {
        return false;
    }

    public void setEnd(BAbsTime t) {
        this.setTimestamp(t);
    }

    protected final void doRead(DataInput datainput) throws IOException {
        this.setQuantity(datainput.readDouble());
        this.setRate(datainput.readDouble());
        this.setStart((BAbsTime)BAbsTime.DEFAULT.decode(datainput));
        this.setUser(datainput.readUTF());
    }

    protected final void doWrite(DataOutput dataoutput) throws IOException {
        dataoutput.writeDouble(this.getQuantity());
        dataoutput.writeDouble(this.getRate());
        this.getStart().encode(dataoutput);
        dataoutput.writeUTF(this.getUser());
    }
}

